/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.classes;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.BasicPhpStubElementTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.Attributes;
import com.jetbrains.php.lang.parser.parsing.TypeDeclaration;
import com.jetbrains.php.lang.parser.parsing.classes.ClassMemberModifiers;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public final class ClassConstant {
    private static final ParserPart CONSTANT_PARSER_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            PsiBuilder.Marker classConstant = builder.mark();
            if (!ClassConstant.parseConstantName(builder, false)) {
                classConstant.error(PhpParserErrors.expected(PhpTokenTypes.IDENTIFIER));
                return PhpElementTypes.EMPTY_INPUT;
            }
            builder.match(PhpTokenTypes.opASGN);
            IElementType result = Expression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("initializer", new Object[0])));
            }
            classConstant.done(BasicPhpStubElementTypes.CLASS_CONST);
            return BasicPhpStubElementTypes.CLASS_CONST;
        }
    };

    public static boolean parseConstantName(PhpPsiBuilder builder, boolean remapKeywordToIdentifier) {
        if (builder.compareAndEat(PhpTokenTypes.IDENTIFIER)) {
            return true;
        }
        if (builder.compare(PhpTokenTypes.tsKEYWORDS)) {
            if (remapKeywordToIdentifier) {
                builder.remapToIdentifier();
            }
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker classConstants = builder.mark();
        Attributes.parseAttributesList(builder);
        ClassMemberModifiers.parseConstantModifiers(builder);
        Attributes.parseAttributesList(builder);
        if (!builder.compareAndEat(PhpTokenTypes.kwCONST)) {
            classConstants.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        Attributes.parseAttributesList(builder);
        PsiBuilder.Marker beforePossibleType = builder.mark();
        IElementType type = TypeDeclaration.parseType(builder, PhpElementTypes.CLASS_CONSTANT_TYPE);
        if (type != PhpElementTypes.EMPTY_INPUT && builder.compare(PhpTokenTypes.opASGN)) {
            beforePossibleType.rollbackTo();
        } else {
            beforePossibleType.drop();
        }
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, CONSTANT_PARSER_PART.parse(builder), CONSTANT_PARSER_PART, false);
        builder.match(PhpTokenTypes.opSEMICOLON);
        classConstants.done(PhpElementTypes.CLASS_CONSTANTS);
        return BasicPhpStubElementTypes.CLASS_CONST;
    }
}

