/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions.primary;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.BasicPhpStubElementTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.calls.Function;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;
import com.jetbrains.php.lang.parser.parsing.classes.ClassDeclaration;
import com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class NewExpression {
    public static IElementType parse(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.kwNEW)) {
            return NewExpression.parseNewExpression(builder);
        }
        return PhpElementTypes.EMPTY_INPUT;
    }

    public static IElementType tryParseAnonymousClassOrWithArguments(PhpPsiBuilder builder) {
        PsiBuilder.Marker newMark = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwNEW)) {
            return NewExpression.tryParseNewExpressionWithAnonymousClassOrArguments(builder, newMark);
        }
        newMark.rollbackTo();
        return PhpElementTypes.EMPTY_INPUT;
    }

    @NotNull
    private static IElementType parseNewExpression(PhpPsiBuilder builder) {
        Optional<IElementType> result = NewExpression.subParseWithoutArguments(builder);
        if (result.isPresent()) {
            IElementType iElementType = result.get() == BasicPhpStubElementTypes.CLASS ? PhpElementTypes.NEW_EXPRESSION : PhpElementTypes.EMPTY_INPUT;
            if (iElementType == null) {
                NewExpression.$$$reportNull$$$0(0);
            }
            return iElementType;
        }
        if (builder.compare(PhpTokenTypes.chLPAREN)) {
            Function.parseFunctionCallParameterList(builder);
        }
        IElementType iElementType = PhpElementTypes.NEW_EXPRESSION;
        if (iElementType == null) {
            NewExpression.$$$reportNull$$$0(1);
        }
        return iElementType;
    }

    private static IElementType tryParseNewExpressionWithAnonymousClassOrArguments(PhpPsiBuilder builder, PsiBuilder.Marker newMark) {
        Optional<IElementType> result = NewExpression.subParseWithoutArguments(builder);
        if (result.isPresent()) {
            return NewExpression.handleSubParseResult(result.get(), newMark);
        }
        if (!builder.compare(PhpTokenTypes.chLPAREN)) {
            newMark.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        Function.parseFunctionCallParameterList(builder);
        newMark.drop();
        return PhpElementTypes.NEW_EXPRESSION;
    }

    private static Optional<IElementType> subParseWithoutArguments(PhpPsiBuilder builder) {
        IElementType anonymousClass = ClassDeclaration.parseClass(builder, true);
        if (anonymousClass != PhpElementTypes.EMPTY_INPUT) {
            return Optional.of(anonymousClass);
        }
        IElementType result = ClassReference.parseClassNameReference(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.expected(PhpFrontBackBundle.message("class.name", new Object[0])));
        }
        if (result == PhpElementTypes.CLASS_CONSTANT_REFERENCE) {
            return Optional.of(PhpElementTypes.EMPTY_INPUT);
        }
        while (Variable.parseArrayDeref(builder) != PhpElementTypes.EMPTY_INPUT) {
            if (result != PhpElementTypes.CLASS_REFERENCE) continue;
            return Optional.of(PhpElementTypes.EMPTY_INPUT);
        }
        return Optional.empty();
    }

    private static IElementType handleSubParseResult(IElementType result, PsiBuilder.Marker marker) {
        if (result == BasicPhpStubElementTypes.CLASS) {
            marker.drop();
            return PhpElementTypes.NEW_EXPRESSION;
        }
        marker.rollbackTo();
        return PhpElementTypes.EMPTY_INPUT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/parser/parsing/expressions/primary/NewExpression", "parseNewExpression"));
    }
}

