/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BasicPhpPsiUtil {
    private BasicPhpPsiUtil() {
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable ASTNode node, @NotNull IElementType type) {
        if (type == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(0);
        }
        return PsiUtilCore.getElementType((ASTNode)node) == type;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable PsiElement element, @NotNull IElementType type) {
        if (type == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(1);
        }
        return PsiUtilCore.getElementType((PsiElement)element) == type;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable PsiElement element, @NotNull TokenSet types) {
        if (types == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(2);
        }
        return types.contains(PsiUtilCore.getElementType((PsiElement)element));
    }

    @Nullable
    public static PsiElement findFullPhpTagAtOffset(@Nullable PsiFile file, int offset) {
        if (offset > 0 && file != null) {
            PsiElement openTagAt = file.findElementAt(offset - 1);
            return BasicPhpPsiUtil.isOfType(openTagAt, PhpTokenTypes.PHP_OPENING_TAG) && openTagAt.getTextLength() == 5 ? openTagAt : null;
        }
        return null;
    }

    @Deprecated
    @Nullable
    @Contract(value="null, _ -> null", pure=true)
    public static PsiElement getParentByCondition(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(3);
        }
        return BasicPhpPsiUtil.getParentByCondition(element, condition, null);
    }

    @Nullable
    @Contract(value="null, _, _ -> null", pure=true)
    public static PsiElement getParentByCondition(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition, @Nullable Condition<? super PsiElement> stopAt) {
        if (condition == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(4);
        }
        for (PsiElement curElement = element; curElement != null; curElement = curElement.getParent()) {
            if (stopAt != null && stopAt.value((Object)curElement)) {
                return null;
            }
            if (condition.value((Object)curElement)) {
                return curElement;
            }
            if (!(curElement instanceof PsiFile)) continue;
            return null;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null", pure=true)
    public static PsiElement getParentByElementTypeCondition(@Nullable PsiElement element, IElementType elementType) {
        for (PsiElement curElement = element; curElement != null; curElement = curElement.getParent()) {
            if (BasicPhpPsiUtil.isOfType(curElement, elementType)) {
                return curElement;
            }
            if (!(curElement instanceof PsiFile)) continue;
            return null;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null", pure=true)
    public static PsiElement getParentByElementTypeCondition(@Nullable PsiElement element, TokenSet elementType) {
        for (PsiElement curElement = element; curElement != null; curElement = curElement.getParent()) {
            if (BasicPhpPsiUtil.isOfType(curElement, elementType)) {
                return curElement;
            }
            if (!(curElement instanceof PsiFile)) continue;
            return null;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _, _ -> null", pure=true)
    public static PsiElement getParentByElementTypeCondition(@Nullable PsiElement element, IElementType elementType, IElementType stopAt) {
        for (PsiElement curElement = element; curElement != null; curElement = curElement.getParent()) {
            if (stopAt != null && BasicPhpPsiUtil.isOfType(curElement, stopAt)) {
                return null;
            }
            if (BasicPhpPsiUtil.isOfType(curElement, elementType)) {
                return curElement;
            }
            if (!(curElement instanceof PsiFile)) continue;
            return null;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getNextSiblingByCondition(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(5);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement nextSibling = element.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (!condition.value((Object)nextSibling)) continue;
            return nextSibling;
        }
        return null;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static PsiElement getPrevSiblingIgnoreWhitespace(@Nullable PsiElement element, boolean strict) {
        if (element == null) {
            return null;
        }
        PsiElement prevSibling = strict ? element.getPrevSibling() : element;
        while (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        return prevSibling;
    }

    public static boolean isArgumentUnpacking(@Nullable PsiElement argument) {
        return argument != null && BasicPhpPsiUtil.isOfType(argument.getPrevSibling(), PhpTokenTypes.opVARIADIC);
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static PsiElement getNextSiblingIgnoreWhitespace(@Nullable PsiElement element, boolean strict) {
        if (element == null) {
            return null;
        }
        PsiElement nextSibling = strict ? element.getNextSibling() : element;
        while (nextSibling instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        return nextSibling;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getChildOfType(@Nullable PsiElement element, @NotNull IElementType type) {
        ASTNode childNode;
        if (type == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(6);
        }
        if (element == null) {
            return null;
        }
        ASTNode elementNode = element.getNode();
        if (elementNode != null && (childNode = elementNode.findChildByType(type)) != null) {
            return childNode.getPsi();
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getChildOfType(@Nullable PsiElement element, @NotNull TokenSet type) {
        ASTNode childNode;
        if (type == null) {
            BasicPhpPsiUtil.$$$reportNull$$$0(7);
        }
        if (element == null) {
            return null;
        }
        ASTNode elementNode = element.getNode();
        if (elementNode != null && (childNode = elementNode.findChildByType(type)) != null) {
            return childNode.getPsi();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/psi/BasicPhpPsiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isOfType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentByCondition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getNextSiblingByCondition";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildOfType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

