/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram;

import com.intellij.database.DbModelRegistry;
import com.intellij.database.diagram.DbDiagramProvider;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicMultiLevelObject;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.properties.Level;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDiagramElementManager
extends AbstractDiagramElementManager<DbElement> {
    @Nullable
    public DbElement findInDataContext(@NotNull DataContext context) {
        BasicElement element;
        if (context == null) {
            DbDiagramElementManager.$$$reportNull$$$0(0);
        }
        if ((element = DatabaseContextFun.fromDatabaseTree(context) ? (BasicElement)DatabaseContextFun.getSelectedElements(context).first() : DatabaseContextFun.getEditorObject(context)) == null) {
            return DatabaseContextFun.getSelectedDbElementFromEditor(context);
        }
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        DbModelRegistry registry = (DbModelRegistry)project.getService(DbModelRegistry.class);
        return registry.findDbElement(element);
    }

    @NotNull
    public Collection<DbElement> findElementsInDataContext(@NotNull DataContext context) {
        JBIterable elements;
        if (context == null) {
            DbDiagramElementManager.$$$reportNull$$$0(1);
        }
        if (DatabaseContextFun.fromDatabaseTree(context)) {
            elements = DatabaseContextFun.getSelectedElements(context);
        } else {
            BasicElement element = DatabaseContextFun.getEditorObject(context);
            JBIterable jBIterable = elements = element != null ? JBIterable.of((Object)element) : JBIterable.empty();
        }
        if (elements.isEmpty()) {
            DbElement dbElementFromEditor = DatabaseContextFun.getSelectedDbElementFromEditor(context);
            Set<DbElement> set = dbElementFromEditor != null ? Collections.singleton(dbElementFromEditor) : Collections.emptySet();
            if (set == null) {
                DbDiagramElementManager.$$$reportNull$$$0(2);
            }
            return set;
        }
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            Set<DbElement> set = Collections.emptySet();
            if (set == null) {
                DbDiagramElementManager.$$$reportNull$$$0(3);
            }
            return set;
        }
        DbModelRegistry registry = (DbModelRegistry)project.getService(DbModelRegistry.class);
        List list = elements.filterMap(e -> registry.findDbElement((BasicElement)e)).toList();
        if (list == null) {
            DbDiagramElementManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean isAcceptableAsNode(@Nullable Object element) {
        return DbDiagramElementManager.isAcceptedAsNodeImpl(element);
    }

    public static boolean isAcceptedAsNodeImpl(Object element) {
        if (element instanceof BasicNode) {
            return element instanceof BasicLikeTable && DbImplUtilCore.isDataTable(((BasicLikeTable)element).getKind()) || element instanceof BasicNamespace || element instanceof BasicRoot || element instanceof DataSourceNode;
        }
        if (element instanceof DbElement) {
            return element instanceof DbTable && DbImplUtilCore.isDataTable((DbTable)element) || element instanceof DasNamespace || element instanceof DbDataSource;
        }
        return false;
    }

    public Object @NotNull [] getNodeItems(@NotNull DbElement parent) {
        if (parent == null) {
            DbDiagramElementManager.$$$reportNull$$$0(5);
        }
        if (!parent.isValid()) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                DbDiagramElementManager.$$$reportNull$$$0(6);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        SmartList result2 = new SmartList();
        for (DbElement element : parent.getDasChildren(null)) {
            if (element instanceof DbTableKey) continue;
            result2.add(element);
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)result2);
        if (objectArray == null) {
            DbDiagramElementManager.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    @Nullable
    public Icon getItemIcon(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            DbDiagramElementManager.$$$reportNull$$$0(8);
        }
        return element instanceof DbElement ? DbPresentationCore.getIcon((DbElement)element) : super.getItemIcon(element, presentation);
    }

    public boolean canCollapse(DbElement element) {
        return super.canCollapse((Object)element);
    }

    public boolean isContainerFor(DbElement parent, DbElement child) {
        return child.getParent() == parent;
    }

    public String getElementTitle(DbElement element) {
        return element.getName();
    }

    @Nullable
    public SimpleColoredText getPresentableElementTitle(DbElement element, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DbDiagramElementManager.$$$reportNull$$$0(9);
        }
        return DbDiagramElementManager.getPresentableElementName(element, builder);
    }

    @Nullable
    public SimpleColoredText getItemName(@Nullable DbElement nodeElement, @Nullable Object nodeItem, @NotNull DiagramBuilder builder) {
        DbElement element;
        if (builder == null) {
            DbDiagramElementManager.$$$reportNull$$$0(10);
        }
        if ((element = (DbElement)ObjectUtils.tryCast((Object)nodeItem, DbElement.class)) == null) {
            return null;
        }
        return DbDiagramElementManager.getPresentableElementName(element, builder);
    }

    private static SimpleColoredText getPresentableElementName(DbElement element, DiagramBuilder builder) {
        String comment;
        SimpleColoredText text2 = new SimpleColoredText(element.getName(), DEFAULT_TITLE_ATTR);
        boolean commentsEnabled = builder.getDataModel().getNodeContentManager().isCategoryEnabled(DbDiagramProvider.Holder.COMMENTS);
        if (commentsEnabled && !StringUtil.isEmptyOrSpaces((String)(comment = DbDiagramElementManager.getPresentableComment(element)))) {
            text2.append("  " + comment, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
        return text2;
    }

    @Nls
    private static String getPresentableComment(DbElement element) {
        String comment = element.getComment();
        if (comment == null) {
            return null;
        }
        int maxCommentLength = 64;
        comment = StringUtil.shortenTextWithEllipsis((String)comment, (int)64, (int)0);
        return "/* " + comment.replaceAll("\\R", "\u21b2") + " */";
    }

    @Nullable
    public SimpleColoredText getItemType(@Nullable Object element) {
        if (element instanceof DbColumn) {
            DbColumn c2 = (DbColumn)element;
            if (DbDiagramElementManager.isTypeNotIntrospected(c2)) {
                return null;
            }
            String typeName = c2.getDasType().getSpecification();
            return new SimpleColoredText(StringUtil.toLowerCase((String)typeName), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        return null;
    }

    private static boolean isTypeNotIntrospected(DbElement e) {
        BasicMultiLevelObject lo;
        Level l;
        BasicMinorObject min;
        BasicMajorObject maj;
        Object object = e.getDelegate();
        return object instanceof BasicMinorObject && (maj = (min = (BasicMinorObject)object).getMajorObject()) instanceof BasicMultiLevelObject && (l = (lo = (BasicMultiLevelObject)((Object)maj)).getDetailsLevel()) != null && l.level < Level.L2.level;
    }

    @Nullable
    @Nls
    public String getNodeTooltip(DbElement element) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diagram/DbDiagramElementManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diagram/DbDiagramElementManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInDataContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInDataContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNodeItems";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableElementTitle";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

