/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.clickhouse.plan;

import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.clickhouse.plan.CHouseRawPlanData;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHousePlanModelBuilder
extends AbstractPlanModelBuilder<CHouseRawPlanData, JSONObject> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = Map.ofEntries(Map.entry("Expression", PlanModel.NodeType.TRANSFORM), Map.entry("Distinct", PlanModel.NodeType.UNIQUE), Map.entry("Join", PlanModel.NodeType.JOIN), Map.entry("Filter", PlanModel.NodeType.FILTER), Map.entry("Union", PlanModel.NodeType.UNION), Map.entry("SettingQuotaAndLimits", PlanModel.NodeType.OPERATION), Map.entry("ReadFromMemoryStorage", PlanModel.NodeType.ACCESS), Map.entry("ReadFromStorage", PlanModel.NodeType.ACCESS), Map.entry("ReadFromPreparedSource", PlanModel.NodeType.ACCESS));
    private static final Set<String> HANDLED_KEYS = Set.of("Node Type", "Plans", "Plan");

    public CHousePlanModelBuilder() {
        super(EnumSet.noneOf(PlanModel.Feature.class));
    }

    @Override
    @NotNull
    public CHouseRawPlanData createData() {
        return new CHouseRawPlanData();
    }

    @Override
    protected void parseData() {
        this.parseRoot(((CHouseRawPlanData)this.myData).json);
    }

    private void parseRoot(@NotNull String json) throws PlanRetrievalException {
        JSONArray data;
        if (json == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(0);
        }
        try {
            data = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Database returned invalid JSON", e);
        }
        if (data.length() == 0) {
            throw new PlanRetrievalException("Database returned empty plan");
        }
        if (data.length() > 1) {
            throw new PlanRetrievalException("Database returned multiple plans");
        }
        try {
            this.openNode(null);
            this.parseStatement(data.getJSONObject(0));
            this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Database returned plan in unknown format", e);
        }
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull JSONObject object) {
        if (object == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(1);
        }
        StringBuilder desc = new StringBuilder();
        Iterator it = object.keys();
        while (it.hasNext()) {
            String str;
            String key2 = (String)it.next();
            if (HANDLED_KEYS.contains(key2) || (str = object.optString(key2, null)) == null) continue;
            desc.append(key2).append(" = ").append(str).append(";\n");
        }
        String string = desc.toString();
        if (string == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull JSONObject object) {
        if (object == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(3);
        }
        return object.optString("Description", null);
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull JSONObject object) {
        if (object == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    @Nullable
    protected BigDecimal parseActualNumRows(@NotNull JSONObject state) {
        if (state == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(5);
        }
        return super.parseActualNumRows(state);
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull JSONObject object) {
        if (object == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Nullable
    private static JSONArray getSubPlans(@Nullable JSONObject object) {
        return object == null ? null : object.optJSONArray("Plans");
    }

    @Override
    protected void parseSubPlans(@NotNull JSONObject object) {
        JSONArray plans;
        if (object == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(7);
        }
        if ((plans = CHousePlanModelBuilder.getSubPlans(object)) != null) {
            for (int i2 = 0; i2 < plans.length(); ++i2) {
                JSONObject subPlan = plans.optJSONObject(i2);
                if (subPlan == null) {
                    this.unsupportedFormat();
                }
                this.parsePlan(subPlan);
            }
        }
    }

    @Override
    protected void parseStatement(@NotNull JSONObject root) {
        if (root == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(8);
        }
        this.openNode(null);
        JSONObject object = root.optJSONObject("Plan");
        if (object == null) {
            this.unsupportedFormat("No root plan");
        }
        this.myActual = false;
        this.parsePlan(object);
        this.closeNode(this.createNode(root, PlanModel.NodeType.SELECT, null));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull JSONObject object) {
        if (object == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseActualTotalTime(@NotNull JSONObject state) {
        if (state == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(10);
        }
        return super.parseActualTotalTime(state);
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull JSONObject object) {
        if (object == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseActualStartupTime(@NotNull JSONObject state) {
        if (state == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(12);
        }
        return super.parseActualStartupTime(state);
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull JSONObject object) {
        if (object == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(13);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull JSONObject object) {
        if (object == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(14);
        }
        return false;
    }

    @Override
    protected void parsePlan(@NotNull JSONObject state) {
        if (state == null) {
            CHousePlanModelBuilder.$$$reportNull$$$0(15);
        }
        this.openNode(null);
        this.parseSubPlans(state);
        String nodeType = state.optString("Node Type");
        PlanModel.NodeType type = TYPE_MAPPING.get(nodeType);
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        PlanModel.GenericNode node = this.createNode(state, type, nodeType);
        this.closeNode(node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/clickhouse/plan/CHousePlanModelBuilder";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/clickhouse/plan/CHousePlanModelBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseActualNumRows";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseActualTotalTime";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseActualStartupTime";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

