/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.inspections;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.FixWithProgress;
import com.intellij.database.dialects.mssql.MsAzureAuthProviderBase;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MsAuthArtifactValidator
extends DatabaseConfigValidator<LocalDataSource> {
    @Override
    public Class<? extends LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, @NotNull LocalDataSource target2, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        MsAzureAuthProviderBase auth;
        if (project == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(2);
        }
        if ((auth = (MsAzureAuthProviderBase)ObjectUtils.tryCast((Object)DatabaseAuthProvider.get(target2), MsAzureAuthProviderBase.class)) == null) {
            return;
        }
        this.validateRequired(auth.getRequiredArtifact(target2), project, target2, problems, DatabaseBundle.message("notification.title.azure.active.directory.authentication", new Object[0]));
    }

    public void validateRequired(@NotNull MsAzureAuthProviderBase.RequiredArtifact req2, final @NotNull Project project, @NotNull LocalDataSource target2, @NotNull Consumer<? super DataSourceProblem> problems, @NotNull @Nls String title) {
        DatabaseDriver driver;
        if (req2 == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(3);
        }
        if (project == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(4);
        }
        if (target2 == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(5);
        }
        if (problems == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(6);
        }
        if (title == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(7);
        }
        if ((driver = target2.getDatabaseDriver()) != null && !this.usesArtifact(req2, target2)) {
            final ErrorInfo.Fix setUpFix = req2.createSetUpFix(driver, false);
            if (setUpFix == null) {
                return;
            }
            FixWithProgress fix = new FixWithProgress(setUpFix.getName()){

                @Override
                public void run(@NotNull ProgressIndicator indicator, @Nullable DatabaseConfigEditor editor2) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeAndWait(() -> DataSourceUiUtil.applyFix(project, setUpFix, editor2));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/mssql/inspections/MsAuthArtifactValidator$1", "run"));
                }
            };
            problems.consume((Object)new DataSourceProblem(target2, this, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(title, DatabaseBundle.message("notification.content.extra.libraries.required.href.action0.download", new Object[0]), DatabaseBundle.message("notification.content.extra.libraries.required", new Object[0]), fix), fix));
        }
    }

    public boolean usesArtifact(@NotNull MsAzureAuthProviderBase.RequiredArtifact req2, @NotNull LocalDataSource target2) {
        DatabaseDriver driver;
        if (req2 == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(8);
        }
        if (target2 == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(9);
        }
        if ((driver = target2.getDatabaseDriver()) != null && this.usesArtifact(req2, driver)) {
            return true;
        }
        return JdbcConsoleRunContext.expandPackUrls(target2.getClasspathElements()).find(req2::checkFile) != null;
    }

    public boolean usesArtifact(@NotNull MsAzureAuthProviderBase.RequiredArtifact req2, DatabaseDriver driver) {
        DatabaseDriver.ArtifactRef artifactRef;
        if (req2 == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(10);
        }
        return (artifactRef = MsAzureAuthProviderBase.RequiredArtifact.Companion.findArtifact(driver, req2.getArtifactId())) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "req";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/mssql/inspections/MsAuthArtifactValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProblems";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "validateRequired";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "usesArtifact";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

