/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.eval.scratch;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.CommonBundle;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.eval.Php3v4lInterpretersService;
import com.jetbrains.php.eval.scratch.PhpEvalScratchFileEditorWithPreview;
import com.jetbrains.php.eval.scratch.PhpEvalVersionFeatureUsageCollector;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class PhpRunEvalScratchFileAction
extends AnAction
implements DumbAware {
    @NonNls
    private static final String SHOW_SHARE_IN_EVAL_CONFIRMATION = "php.show.share.in.eval.confirmation";
    private static final int RETRIES = 13;
    @NotNull
    private static final Icon ICON = AllIcons.Actions.Execute;
    private static final int DELAY = 750;
    private final PhpEvalScratchFileEditorWithPreview myEditor;
    private boolean isEnabled;

    public PhpRunEvalScratchFileAction(PhpEvalScratchFileEditorWithPreview editor) {
        super(PhpBundle.message((String)"action.run.on.3v4l.org.text", (Object[])new Object[0]), PhpBundle.message((String)"action.submits.code.to.3v4l.org.show.result.in.preview.editor.description", (Object[])new Object[0]), ICON);
        this.myEditor = editor;
        this.isEnabled = false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(0);
        }
        if (!PhpRunEvalScratchFileAction.confirmShare(e.getProject())) {
            return;
        }
        if (this.myEditor.myIndicator != null) {
            this.myEditor.myIndicator.cancel();
        }
        this.myEditor.setCurrentUrl(null);
        this.myEditor.setWaitingForResponse(true);
        PhpRunEvalScratchFileAction.setPreviewText(PhpBundle.message((String)"waiting.for.3v4l.org.response", (Object[])new Object[0]), this.myEditor);
        PhpRunEvalScratchFileAction.executeUnderProgress(e, indicator -> this.initiateSubmitToEval((ProgressIndicator)indicator), this.myEditor);
        PhpEvalVersionFeatureUsageCollector.logAction(this.myEditor.getVersion().getId());
    }

    private static boolean confirmShare(@Nullable Project project) {
        if (!PropertiesComponent.getInstance().getBoolean(SHOW_SHARE_IN_EVAL_CONFIRMATION, true)) {
            return true;
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)PhpBundle.message((String)"action.run.on.3v4l.org.text", (Object[])new Object[0]), (String)PhpBundle.message((String)"dialog.message.do.you.want.to.upload.content.scratch.file.to.3v4l.org.make.it.public", (Object[])new Object[0])).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected) {
                    PropertiesComponent.getInstance().setValue(PhpRunEvalScratchFileAction.SHOW_SHARE_IN_EVAL_CONFIRMATION, false, true);
                }
            }
        })).noText(CommonBundle.getCancelButtonText())).ask(project);
    }

    private static void executeUnderProgress(@NotNull AnActionEvent e, Consumer<ProgressIndicator> runnable, PhpEvalScratchFileEditorWithPreview editor) {
        if (e == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(1);
        }
        Project project = PhpRunEvalScratchFileAction.getEventProject((AnActionEvent)e);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Task.Backgroundable task = PhpRunEvalScratchFileAction.createTask(project, runnable, editor);
            editor.myIndicator = PhpRunEvalScratchFileAction.createIndicator(task);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)editor.myIndicator);
        });
    }

    @NotNull
    private static BackgroundableProcessIndicator createIndicator(Task.Backgroundable task) {
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(task);
        indicator.setIndeterminate(false);
        BackgroundableProcessIndicator backgroundableProcessIndicator = indicator;
        if (backgroundableProcessIndicator == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(2);
        }
        return backgroundableProcessIndicator;
    }

    @NotNull
    private static Task.Backgroundable createTask(@Nullable Project project, final Consumer<ProgressIndicator> runnable, final PhpEvalScratchFileEditorWithPreview editor) {
        return new Task.Backgroundable(project, PhpBundle.message((String)"progress.title.executing.3v4l.org", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                runnable.accept(indicator);
            }

            public void onCancel() {
                editor.setWaitingForResponse(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/eval/scratch/PhpRunEvalScratchFileAction$2", "run"));
            }
        };
    }

    private void initiateSubmitToEval(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(3);
        }
        indicator.setText(PhpBundle.message((String)"progress.text.submitting.code.to.3v4l.org", (Object[])new Object[0]));
        VirtualFile file = this.myEditor.getFile();
        if (file == null) {
            return;
        }
        PendingRequest request = PhpRunEvalScratchFileAction.submitCodeToEval(file.getName(), this.myEditor.getEditor().getDocument().getText(), this.myEditor.getVersion());
        if (request == null) {
            PhpRunEvalScratchFileAction.errorOccurred(indicator, this.myEditor);
        } else {
            request.setPreviewFromEvalFetch(this.myEditor, indicator);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(4);
        }
        e.getPresentation().setEnabled(this.isEnabled);
        e.getPresentation().setIcon(this.myEditor.isWaitingForResponse() ? ExecutionUtil.getLiveIndicator((Icon)ICON) : ICON);
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    private static void setPreviewFromEvalFetch(@NotNull @NlsSafe String evalUrl, int retriesLeft, boolean atLeastOneSuccessfulFetch, ProgressIndicator indicator, PhpEvalScratchFileEditorWithPreview editor) {
        if (evalUrl == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(5);
        }
        indicator.setFraction(PhpRunEvalScratchFileAction.computeFraction(retriesLeft));
        indicator.setText(PhpBundle.message((String)"progress.text.fetching.result.from", (Object[])new Object[]{evalUrl}));
        editor.setCurrentUrl(evalUrl);
        editor.setWaitingForResponse(true);
        indicator.checkCanceled();
        EvalResultAccess result = PhpRunEvalScratchFileAction.fetchResultFromEval(evalUrl);
        if (result == null) {
            PhpRunEvalScratchFileAction.tryRetryFetchWithDelay(evalUrl, retriesLeft, atLeastOneSuccessfulFetch, indicator, editor);
            return;
        }
        PreviewOutput previewOutput = PreviewOutput.create(result);
        PhpRunEvalScratchFileAction.setPreviewText(previewOutput.output, previewOutput.versionsRanges, editor);
        if (result.busy) {
            PhpRunEvalScratchFileAction.tryRetryFetchWithDelay(evalUrl, retriesLeft, true, indicator, editor);
        } else {
            PhpRunEvalScratchFileAction.stopFetch(indicator, editor);
        }
    }

    private static void stopFetch(ProgressIndicator indicator, PhpEvalScratchFileEditorWithPreview editor) {
        editor.setWaitingForResponse(false);
        indicator.cancel();
    }

    private static double computeFraction(int retriesLeft) {
        return (double)(13 - retriesLeft + 1) * 1.0 / 14.0;
    }

    private static void tryRetryFetchWithDelay(@NotNull @NlsSafe String evalUrl, int retriesLeft, boolean atLeastOneSuccessfulFetch, ProgressIndicator indicator, PhpEvalScratchFileEditorWithPreview editor) {
        if (evalUrl == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(6);
        }
        if (retriesLeft > 0) {
            PhpRunEvalScratchFileAction.retryFetchWithDelay(evalUrl, retriesLeft, atLeastOneSuccessfulFetch, indicator, editor);
            return;
        }
        if (!atLeastOneSuccessfulFetch) {
            PhpRunEvalScratchFileAction.errorOccurred(indicator, editor);
        } else {
            PhpRunEvalScratchFileAction.stopFetch(indicator, editor);
        }
        PhpRunEvalScratchFileAction.notifyRetryAction(evalUrl, atLeastOneSuccessfulFetch, editor);
    }

    private static void notifyRetryAction(final @NotNull String evalUrl, final boolean atLeastOneSuccessfulFetch, final PhpEvalScratchFileEditorWithPreview editor) {
        if (evalUrl == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(7);
        }
        final Notification notification = new Notification("PHP 3v4l", PhpBundle.message((String)"notification.content.timeout.while.fetching.data.from", (Object[])new Object[]{evalUrl}), NotificationType.WARNING);
        notification.addAction(new AnAction(PhpBundle.message((String)"action.retry.text", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                notification.expire();
                PhpRunEvalScratchFileAction.executeUnderProgress(e, indicator -> PhpRunEvalScratchFileAction.setPreviewFromEvalFetch(evalUrl, 13, atLeastOneSuccessfulFetch, indicator, editor), editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/eval/scratch/PhpRunEvalScratchFileAction$3", "actionPerformed"));
            }
        });
        Notifications.Bus.notify((Notification)notification);
        Disposer.register((Disposable)editor, () -> notification.expire());
    }

    private static void errorOccurred(@NotNull ProgressIndicator indicator, PhpEvalScratchFileEditorWithPreview editor) {
        if (indicator == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(8);
        }
        PhpRunEvalScratchFileAction.setPreviewText(PhpBundle.message((String)"error.during.access.to.3v4l.org", (Object[])new Object[0]), editor);
        PhpRunEvalScratchFileAction.stopFetch(indicator, editor);
    }

    private static void retryFetchWithDelay(String evalUrl, int retriesLeft, boolean atLeastOneSuccessfulFetch, ProgressIndicator indicator, PhpEvalScratchFileEditorWithPreview editor) {
        indicator.checkCanceled();
        try {
            Thread.sleep(750L);
            PhpRunEvalScratchFileAction.setPreviewFromEvalFetch(evalUrl, retriesLeft - 1, atLeastOneSuccessfulFetch, indicator, editor);
        }
        catch (InterruptedException e) {
            PhpRunEvalScratchFileAction.stopFetch(indicator, editor);
        }
    }

    private static void setPreviewText(@Nls String text, PhpEvalScratchFileEditorWithPreview editor) {
        PhpRunEvalScratchFileAction.setPreviewText("", Collections.singletonList(new InlayInfo(0, text)), editor);
    }

    private static void setPreviewText(@Nls String text, List<InlayInfo> inlayInfos, PhpEvalScratchFileEditorWithPreview editor) {
        ApplicationManager.getApplication().invokeLater(() -> {
            editor.setLayout(TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW);
            WriteAction.run(() -> ((TextEditor)editor.getPreviewEditor()).getEditor().getDocument().setText((CharSequence)text));
            PhpRunEvalScratchFileAction.setInlays(inlayInfos, editor);
        });
    }

    private static void setInlays(List<InlayInfo> inlayInfos, PhpEvalScratchFileEditorWithPreview editor) {
        InlayModel inlayModel = ((TextEditor)editor.getPreviewEditor()).getEditor().getInlayModel();
        editor.disposeAllInlays();
        for (InlayInfo inlayInfo : inlayInfos) {
            editor.addInlay((Inlay<EditorCustomElementRenderer>)inlayModel.addBlockElement(inlayInfo.editorOffset(), new InlayProperties().showAbove(true), (EditorCustomElementRenderer)new EvalPreviewInlaysRenderer(inlayInfo, editor)));
        }
    }

    @NlsSafe
    @Nullable
    @VisibleForTesting
    public static EvalResultAccess fetchResultFromEval(@NotNull String evalUrl) {
        if (evalUrl == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(9);
        }
        try {
            return PhpRunEvalScratchFileAction.fetchResultFromEvalResponse(JsonParser.parseString((String)HttpRequests.request((String)evalUrl).accept("application/json").readString()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    private static EvalResultAccess fetchResultFromEvalResponse(JsonElement element) {
        try {
            if (element == null) {
                return null;
            }
            return new EvalResultAccess(PhpRunEvalScratchFileAction.getElements(element, "versions"), ContainerUtil.map(PhpRunEvalScratchFileAction.getElements(element, "output"), StringUtil::unescapeXmlEntities), PhpRunEvalScratchFileAction.isBusy(element));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @NotNull
    private static List<String> getElements(JsonElement element, String name) {
        ArrayList<String> res = new ArrayList<String>();
        JsonArray output = element.getAsJsonObject().get("output").getAsJsonArray();
        for (int i = 0; i < output.size(); ++i) {
            res.add(output.get(i).getAsJsonObject().get(name).getAsString());
        }
        ArrayList<String> arrayList = res;
        if (arrayList == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static boolean isBusy(JsonElement element) {
        return element != null && element.getAsJsonObject().get("script").getAsJsonObject().get("state").getAsString().equals("busy");
    }

    @Nullable
    @VisibleForTesting
    public static PendingRequest submitCodeToEval(@NotNull @NlsSafe String name, @NotNull @NlsSafe String content, @NotNull Php3v4lInterpretersService.Php3v4lInterpreterVersion version) {
        if (name == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(11);
        }
        if (content == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(12);
        }
        if (version == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(13);
        }
        RequestBuilder post = HttpRequests.post((String)"https://3v4l.org/new", (String)"application/x-www-form-urlencoded").accept("application/json");
        try {
            return (PendingRequest)post.connect(request -> {
                JsonElement element;
                EvalResultAccess resultAccess;
                String data = "title=" + name + "&code=" + URLEncoder.encode(content, StandardCharsets.UTF_8) + "&version=" + version.getId();
                request.write(data);
                if (!version.isBuiltin() && (resultAccess = PhpRunEvalScratchFileAction.fetchResultFromEvalResponse(element = JsonParser.parseString((String)request.readString()))) != null) {
                    String shortId = element.getAsJsonObject().getAsJsonObject("script").getAsJsonPrimitive("short").getAsString();
                    String versionPostfix = (version.isBranch() ? "/rfc#" : "#v") + version.getId();
                    return new BranchBasedRequest(resultAccess, "https://3v4l.org/" + shortId + versionPostfix);
                }
                String location = request.getConnection().getHeaderField("location");
                return location != null ? new UrlBasedRequest(location) : null;
            });
        }
        catch (IOException | NullPointerException ex) {
            return null;
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PhpRunEvalScratchFileAction.$$$reportNull$$$0(14);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/eval/scratch/PhpRunEvalScratchFileAction";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evalUrl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/eval/scratch/PhpRunEvalScratchFileAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndicator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeUnderProgress";
                break;
            }
            case 2: 
            case 10: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initiateSubmitToEval";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPreviewFromEvalFetch";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryRetryFetchWithDelay";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notifyRetryAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "errorOccurred";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fetchResultFromEval";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "submitCodeToEval";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 10, 14 -> new IllegalStateException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @VisibleForTesting
    public static interface PendingRequest {
        public void setPreviewFromEvalFetch(PhpEvalScratchFileEditorWithPreview var1, @NotNull ProgressIndicator var2);
    }

    @VisibleForTesting
    public record EvalResultAccess(List<@NlsSafe String> versions, List<@NlsSafe String> output, boolean busy) {
    }

    record PreviewOutput(List<InlayInfo> versionsRanges, @NlsSafe String output) {
        @NotNull
        public static PreviewOutput create(@NotNull EvalResultAccess result) {
            if (result == null) {
                PreviewOutput.$$$reportNull$$$0(0);
            }
            ArrayList<InlayInfo> ranges = new ArrayList<InlayInfo>();
            StringBuilder output = new StringBuilder();
            int size = result.output.size();
            for (int i = 0; i < size; ++i) {
                ranges.add(new InlayInfo(output.length(), "Output for: " + result.versions.get(i)));
                output.append(result.output.get(i));
                if (i >= size - 1) continue;
                output.append("\n");
            }
            return new PreviewOutput(ranges, output.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/eval/scratch/PhpRunEvalScratchFileAction$PreviewOutput", "create"));
        }
    }

    record InlayInfo(int editorOffset, String text) {
    }

    private static class EvalPreviewInlaysRenderer
    implements EditorCustomElementRenderer {
        private final InlayInfo myFolding;
        private final PhpEvalScratchFileEditorWithPreview myEditor;

        private EvalPreviewInlaysRenderer(InlayInfo folding, PhpEvalScratchFileEditorWithPreview editor) {
            this.myFolding = folding;
            this.myEditor = editor;
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                EvalPreviewInlaysRenderer.$$$reportNull$$$0(0);
            }
            return inlay.getEditor().getComponent().getWidth();
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            if (inlay == null) {
                EvalPreviewInlaysRenderer.$$$reportNull$$$0(1);
            }
            if (g == null) {
                EvalPreviewInlaysRenderer.$$$reportNull$$$0(2);
            }
            if (targetRegion == null) {
                EvalPreviewInlaysRenderer.$$$reportNull$$$0(3);
            }
            if (textAttributes == null) {
                EvalPreviewInlaysRenderer.$$$reportNull$$$0(4);
            }
            Editor editor = ((TextEditor)this.myEditor.getPreviewEditor()).getEditor();
            float hintUtilFontSize = Math.max(1.0f, editor.getColorsScheme().getEditorFontSize2D() - 1.0f);
            g.setFont(UIUtil.getLabelFont().deriveFont(0, hintUtilFontSize));
            Color inlayTextForeground = editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLAY_TEXT_WITHOUT_BACKGROUND).getForegroundColor();
            g.setColor((Color)ObjectUtils.notNull((Object)inlayTextForeground, () -> editor.getColorsScheme().getDefaultForeground()));
            g.drawString(this.myFolding.text(), targetRegion.getLocation().x, targetRegion.getLocation().y + editor.getAscent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRegion";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/eval/scratch/PhpRunEvalScratchFileAction$EvalPreviewInlaysRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    public record BranchBasedRequest(EvalResultAccess resultAccess, String evalUrl) implements PendingRequest
    {
        @Override
        public void setPreviewFromEvalFetch(PhpEvalScratchFileEditorWithPreview editor, @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                BranchBasedRequest.$$$reportNull$$$0(0);
            }
            PreviewOutput previewOutput = PreviewOutput.create(this.resultAccess);
            PhpRunEvalScratchFileAction.setPreviewText(previewOutput.output, previewOutput.versionsRanges, editor);
            editor.setCurrentUrl(this.evalUrl);
            PhpRunEvalScratchFileAction.stopFetch(indicator, editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/eval/scratch/PhpRunEvalScratchFileAction$BranchBasedRequest", "setPreviewFromEvalFetch"));
        }
    }

    @VisibleForTesting
    public record UrlBasedRequest(String url) implements PendingRequest
    {
        @Override
        public void setPreviewFromEvalFetch(PhpEvalScratchFileEditorWithPreview editor, @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                UrlBasedRequest.$$$reportNull$$$0(0);
            }
            PhpRunEvalScratchFileAction.setPreviewFromEvalFetch(this.url, 13, false, indicator, editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/eval/scratch/PhpRunEvalScratchFileAction$UrlBasedRequest", "setPreviewFromEvalFetch"));
        }
    }
}

