/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J5\u0010\u0010\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0005J\u001a\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00042\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0004J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001c"}, d2={"Lai/grazie/nlp/utils/ModelVocabulary;", "", "token2index", "", "", "", "index2token", "(Ljava/util/Map;Ljava/util/Map;)V", "getIndex2token", "()Ljava/util/Map;", "size", "getSize", "()I", "getToken2index", "component1", "component2", "copy", "equals", "", "other", "getTokenByIndex", "idx", "getTokenIndex", "token", "unkToken", "hashCode", "toString", "Companion", "nlp-common"})
public final class ModelVocabulary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Integer> token2index;
    @NotNull
    private final Map<Integer, String> index2token;

    public ModelVocabulary(@NotNull Map<String, Integer> token2index, @NotNull Map<Integer, String> index2token) {
        Intrinsics.checkNotNullParameter(token2index, (String)"token2index");
        Intrinsics.checkNotNullParameter(index2token, (String)"index2token");
        this.token2index = token2index;
        this.index2token = index2token;
    }

    @NotNull
    public final Map<String, Integer> getToken2index() {
        return this.token2index;
    }

    @NotNull
    public final Map<Integer, String> getIndex2token() {
        return this.index2token;
    }

    public final int getTokenIndex(@NotNull String token, @Nullable String unkToken) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        if (unkToken != null) {
            int n;
            Integer n2 = this.token2index.get(token);
            if (n2 != null) {
                n = n2;
            } else {
                Integer n3 = this.token2index.get(unkToken);
                Intrinsics.checkNotNull((Object)n3);
                n = ((Number)n3).intValue();
            }
            return n;
        }
        Integer n = this.token2index.get(token);
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    public static /* synthetic */ int getTokenIndex$default(ModelVocabulary modelVocabulary, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        return modelVocabulary.getTokenIndex(string2, string3);
    }

    @NotNull
    public final String getTokenByIndex(int idx) {
        String string2 = this.index2token.get(idx);
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    public final int getSize() {
        return this.token2index.size();
    }

    @NotNull
    public final Map<String, Integer> component1() {
        return this.token2index;
    }

    @NotNull
    public final Map<Integer, String> component2() {
        return this.index2token;
    }

    @NotNull
    public final ModelVocabulary copy(@NotNull Map<String, Integer> token2index, @NotNull Map<Integer, String> index2token) {
        Intrinsics.checkNotNullParameter(token2index, (String)"token2index");
        Intrinsics.checkNotNullParameter(index2token, (String)"index2token");
        return new ModelVocabulary(token2index, index2token);
    }

    public static /* synthetic */ ModelVocabulary copy$default(ModelVocabulary modelVocabulary, Map map, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            map = modelVocabulary.token2index;
        }
        if ((n & 2) != 0) {
            map2 = modelVocabulary.index2token;
        }
        return modelVocabulary.copy(map, map2);
    }

    @NotNull
    public String toString() {
        return "ModelVocabulary(token2index=" + this.token2index + ", index2token=" + this.index2token + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.token2index).hashCode();
        result2 = result2 * 31 + ((Object)this.index2token).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelVocabulary)) {
            return false;
        }
        ModelVocabulary modelVocabulary = (ModelVocabulary)other;
        if (!Intrinsics.areEqual(this.token2index, modelVocabulary.token2index)) {
            return false;
        }
        return Intrinsics.areEqual(this.index2token, modelVocabulary.index2token);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006J\u0014\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0007\u00a8\u0006\u000e"}, d2={"Lai/grazie/nlp/utils/ModelVocabulary$Companion;", "", "()V", "fromDict", "Lai/grazie/nlp/utils/ModelVocabulary;", "rawVocab", "", "", "", "fromTokens", "tokens", "", "loadFromTextLines", "file", "nlp-common"})
    @SourceDebugExtension(value={"SMAP\nModelVocabulary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelVocabulary.kt\nai/grazie/nlp/utils/ModelVocabulary$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n766#2:53\n857#2,2:54\n*S KotlinDebug\n*F\n+ 1 ModelVocabulary.kt\nai/grazie/nlp/utils/ModelVocabulary$Companion\n*L\n13#1:53\n13#1:54,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModelVocabulary loadFromTextLines(@NotNull String file) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$filter$iv = StringsKt.lines((CharSequence)file);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List tokens = (List)destination$iv$iv;
            return this.fromTokens(tokens);
        }

        @NotNull
        public final ModelVocabulary fromDict(@NotNull Map<String, Integer> rawVocab) {
            Intrinsics.checkNotNullParameter(rawVocab, (String)"rawVocab");
            Map token2index = new HashMap();
            Map index2token = new HashMap();
            for (Map.Entry<String, Integer> entry2 : rawVocab.entrySet()) {
                String token = entry2.getKey();
                int index = ((Number)entry2.getValue()).intValue();
                Integer n = index;
                token2index.put(token, n);
                n = index;
                index2token.put(n, token);
            }
            return new ModelVocabulary(token2index, index2token);
        }

        @NotNull
        public final ModelVocabulary fromTokens(@NotNull List<String> tokens) {
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            Map token2index = new HashMap();
            Map index2token = new HashMap();
            Iterator<String> iterator = tokens.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int tokenIdx = n++;
                String token = iterator.next();
                Integer n2 = tokenIdx;
                token2index.put(token, n2);
                n2 = tokenIdx;
                index2token.put(n2, token);
            }
            return new ModelVocabulary(token2index, index2token);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

