/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.ContentPanel;
import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.ExportHTMLAction;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.impl.SelectInEditorHandler;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DuplicatesForm
implements Disposable {
    private final JLabel mySendToLeftButton = new JLabel(AllIcons.Duplicates.SendToTheLeft);
    private final JLabel mySendToRightButton = new JLabel(AllIcons.Duplicates.SendToTheRight);
    private final JPanel myButtonsPanel = new JPanel(new BorderLayout());
    @NonNls
    private static final String SEND_TO_LEFT_ID = "DuplicatesForm.SendToLeft";
    @NonNls
    private static final String SEND_TO_RIGHT_ID = "DuplicatesForm.SendToRight";
    @NonNls
    private static final String ourHelpID = "find.locateDuplicates.result";
    private final JBSplitter myPanel;
    private final Tree myDuplicatesTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
    private final MyDuplicatesModelListener myDupModelListener = new MyDuplicatesModelListener();
    private final Map<DuplicatesPresentation, DuplicatesView> myViews = new HashMap<DuplicatesPresentation, DuplicatesView>();
    private final Map<Editor, List<RangeHighlighter>> myInEditorHighlighters = new HashMap<Editor, List<RangeHighlighter>>();
    private final HighlightManager myHighlightManager;
    private DuplicatesModel myModel;
    private final Project myProject;
    private static final DataKey<DuplicatesModel> MODEL = DataKey.create((String)"DUPLICATES_MODEL");
    private static final String SCROLL_TO_SOURCE = "DuplicatesForm.settings.scrollToSource";
    private final MyGlassPanePainter myGlassPanePainter = new MyGlassPanePainter();
    private static DupInfo ourDuplicates;

    private DuplicatesForm(Project project2) {
        this.myProject = project2;
        this.myHighlightManager = HighlightManager.getInstance((Project)this.myProject);
        this.myPanel = new MySplitter();
        this.myPanel.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myDuplicatesTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myDuplicatesTree);
        SelectInEditorHandler.installKeyListener((JComponent)this.myDuplicatesTree);
        this.addNavigationAndSelecting();
        this.myDuplicatesTree.setShowsRootHandles(true);
        this.myDuplicatesTree.setRootVisible(false);
        final MyColoredTreeCellRenderer cellRenderer = new MyColoredTreeCellRenderer();
        this.myDuplicatesTree.setCellRenderer((TreeCellRenderer)cellRenderer);
        PopupHandler.installPopupMenu((JComponent)this.myDuplicatesTree, (ActionGroup)DuplicatesForm.createPopup(this.getComponent()), (String)"DuplicatesPopup");
        this.myDuplicatesTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = DuplicatesForm.this.myDuplicatesTree.getRowForLocation(e.getX(), e.getY());
                if (row >= 0) {
                    Rectangle rowBounds = DuplicatesForm.this.myDuplicatesTree.getRowBounds(row);
                    cellRenderer.setBounds(rowBounds);
                    if (!DuplicatesForm.this.processClick(e, rowBounds.getLocation(), DuplicatesForm.this.mySendToLeftButton, 0)) {
                        DuplicatesForm.this.processClick(e, new Point(rowBounds.x + DuplicatesForm.this.mySendToLeftButton.getWidth(), rowBounds.y), DuplicatesForm.this.mySendToRightButton, 1);
                    }
                }
            }
        });
        this.myButtonsPanel.add((Component)this.mySendToLeftButton, "West");
        this.myButtonsPanel.add((Component)this.mySendToRightButton, "East");
        this.myButtonsPanel.setBackground(UIUtil.getTreeBackground());
        IdeGlassPaneUtil.installPainter((JComponent)this.myDuplicatesTree, (Painter)this.myGlassPanePainter, (Disposable)this);
        this.myDuplicatesTree.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Object nodeUnder;
                int row = DuplicatesForm.this.myDuplicatesTree.getRowForLocation(e.getX(), e.getY());
                if (row >= 0 && (nodeUnder = DuplicatesForm.this.myDuplicatesTree.getPathForRow(row).getLastPathComponent()) instanceof CodeNode) {
                    Rectangle rowBounds = DuplicatesForm.this.myDuplicatesTree.getRowBounds(row);
                    cellRenderer.setBounds(rowBounds);
                    Point point = e.getPoint();
                    Rectangle checkBounds = DuplicatesForm.this.mySendToLeftButton.getBounds();
                    checkBounds.setLocation(rowBounds.getLocation());
                    Icon icon = null;
                    if (checkBounds.contains(point)) {
                        icon = AllIcons.Duplicates.SendToTheLeft;
                    } else {
                        checkBounds = DuplicatesForm.this.mySendToRightButton.getBounds();
                        checkBounds.setLocation(new Point(rowBounds.x + AllIcons.Duplicates.SendToTheRight.getIconWidth(), rowBounds.y));
                        if (checkBounds.contains(point)) {
                            icon = AllIcons.Duplicates.SendToTheRight;
                        }
                    }
                    if (icon != null) {
                        DuplicatesForm.this.myGlassPanePainter.setPaint(icon, checkBounds.getLocation());
                        return;
                    }
                }
                DuplicatesForm.this.myGlassPanePainter.setPaint(null, null);
            }
        });
    }

    private void addNavigationAndSelecting() {
        final EditSourceOnDoubleClickHandler.TreeMouseListener listener2 = new EditSourceOnDoubleClickHandler.TreeMouseListener((JTree)this.myDuplicatesTree);
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                listener2.onDoubleClick(e);
                CodeNode selectedNode = DuplicatesForm.this.getCodeNode();
                if (selectedNode != null) {
                    PsiFragment fragment = selectedNode.getFragment();
                    UsageInfo info = fragment.getUsageInfo();
                    if (info == null) {
                        return true;
                    }
                    PsiElement[] elements = fragment.getElements();
                    assert (elements.length > 0);
                    PsiElement first = elements[0];
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(DuplicatesForm.this.myProject, info.getVirtualFile(), first.getTextOffset());
                    Editor editor = FileEditorManager.getInstance((Project)DuplicatesForm.this.myProject).openTextEditor(descriptor, false);
                    if (editor != null) {
                        List<RangeHighlighter> oldHighlighters = DuplicatesForm.this.myInEditorHighlighters.get(editor);
                        if (oldHighlighters != null) {
                            for (RangeHighlighter highlighter : oldHighlighters) {
                                DuplicatesForm.this.myHighlightManager.removeSegmentHighlighter(editor, highlighter);
                            }
                        }
                        List<RangeHighlighter> newHighlighters = DuplicatesForm.highlightPsiFragment(editor, fragment, DuplicatesForm.this.myHighlightManager, 0);
                        DuplicatesForm.this.myInEditorHighlighters.put(editor, newHighlighters);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dupLocator/resultUI/DuplicatesForm$3", "onDoubleClick"));
            }
        }.installOn((Component)this.myDuplicatesTree);
    }

    private boolean processClick(MouseEvent e, Point location, JLabel label, int idx) {
        Point point = e.getPoint();
        Rectangle checkBounds = label.getBounds();
        checkBounds.setLocation(location);
        CodeNode selectedNode = this.myModel.getSelectedCodeNode();
        if (selectedNode != null && checkBounds.contains(point)) {
            this.myModel.setDiff(idx, selectedNode);
            e.consume();
            return true;
        }
        return false;
    }

    public JTree getDuplicatesTree() {
        return this.myDuplicatesTree;
    }

    private static DefaultActionGroup createPopup(JComponent component) {
        DefaultActionGroup group = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        group.add(actionManager.getAction("EditSource"));
        group.add(actionManager.getAction("ViewSource"));
        group.addSeparator();
        AnAction action = actionManager.getAction(SEND_TO_LEFT_ID);
        action.registerCustomShortcutSet(action.getShortcutSet(), component);
        group.add(action);
        action = actionManager.getAction(SEND_TO_RIGHT_ID);
        action.registerCustomShortcutSet(action.getShortcutSet(), component);
        group.add(action);
        return group;
    }

    public void addToolbarActionsTo(ContentPanel panel) {
        panel.addActionSeparator();
        AutoScrollToSourceHandler scrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return PropertiesComponent.getInstance().getBoolean(DuplicatesForm.SCROLL_TO_SOURCE);
            }

            protected void setAutoScrollMode(boolean state) {
                PropertiesComponent.getInstance().setValue(DuplicatesForm.SCROLL_TO_SOURCE, state);
            }
        };
        scrollToSourceHandler.install((JTree)this.myDuplicatesTree);
        panel.addAction((AnAction)scrollToSourceHandler.createToggleAction());
        if (DuplicatesForm.canEliminate()) {
            panel.addAction(new EliminateDuplicatesAction());
        }
        panel.addAction(new ExportHTMLAction(this.myModel.getRoot()));
    }

    private static boolean canEliminate() {
        for (int i = 0; i < ourDuplicates.getPatterns(); ++i) {
            DuplicatesPresentation profile = DuplicatesPresentation.Service.findPresentationForDuplicate(ourDuplicates, i);
            if (profile == null || !profile.isFixAbilityProvided()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private CodeNode getCodeNode() {
        BasicTreeNode node;
        CodeNode codeNode = this.myModel.getSelectedCodeNode();
        if (codeNode != null) {
            return codeNode;
        }
        TreePath selectionPath = this.myDuplicatesTree.getSelectionPath();
        if (selectionPath != null && (node = (BasicTreeNode)selectionPath.getLastPathComponent()) instanceof GroupNode && node.getChildCount() > 0) {
            return (CodeNode)node.getChildAt(0);
        }
        return null;
    }

    private void setModel(DuplicatesModel model2) {
        if (this.myModel != null) {
            this.myModel.removeListener(this.myDupModelListener);
        }
        this.myModel = model2;
        this.myDuplicatesTree.setModel(model2.getTreeModel());
        this.myDuplicatesTree.setSelectionModel(model2.getSelectionModel());
        model2.addListener(this.myDupModelListener);
        this.myDupModelListener.updateDuplicatesView();
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public static DuplicatesForm create(Project project2, DupInfo duplicates) {
        ourDuplicates = duplicates;
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        DuplicatesForm form = new DuplicatesForm(project2);
        DuplicatesModel model2 = new DuplicatesModel(duplicates, project2);
        form.setModel(model2);
        return form;
    }

    public void dispose() {
        for (Editor editor : this.myInEditorHighlighters.keySet()) {
            List<RangeHighlighter> highlighters = this.myInEditorHighlighters.get(editor);
            for (RangeHighlighter highlighter : highlighters) {
                this.myHighlightManager.removeSegmentHighlighter(editor, highlighter);
            }
        }
    }

    public static List<RangeHighlighter> highlightPsiFragment(Editor editor, PsiFragment fragment, HighlightManager highlightManager, int firstOffset) {
        PsiElement[] elements = fragment.getElements();
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        for (PsiElement element : elements) {
            if (element == null) continue;
            TextRange range = element.getTextRange();
            int startOffset = range.getStartOffset() - firstOffset;
            int endOffset = range.getEndOffset() - firstOffset;
            highlightManager.addRangeHighlight(editor, startOffset, endOffset, EditorColors.SEARCH_RESULT_ATTRIBUTES, false, highlighters);
        }
        return highlighters;
    }

    private class MyDuplicatesModelListener
    implements DuplicatesModel.Listener {
        private final Alarm myAlarm = new Alarm();

        private MyDuplicatesModelListener() {
        }

        @Override
        public void onSelectionChanged() {
            this.myAlarm.cancelAllRequests();
            DuplicatesModel model2 = DuplicatesForm.this.myModel;
            this.myAlarm.addRequest(() -> {
                if (model2 == DuplicatesForm.this.myModel && DuplicatesForm.this.myPanel.isDisplayable()) {
                    this.updateDuplicatesView();
                }
            }, 200);
        }

        private void updateDuplicatesView() {
            JComponent component;
            CodeNode left = DuplicatesForm.this.myModel.getLeft();
            CodeNode right = DuplicatesForm.this.myModel.getRight();
            if (left == null || right == null) {
                return;
            }
            DuplicatesPresentation presentation = left.getPresentation();
            DuplicatesView view = null;
            if (presentation != null && (view = DuplicatesForm.this.myViews.get(presentation)) == null) {
                view = presentation.createView(DuplicatesForm.this.myProject);
                Disposer.register((Disposable)DuplicatesForm.this, (Disposable)view);
                DuplicatesForm.this.myViews.put(presentation, view);
            }
            JComponent currentViewComponent = DuplicatesForm.this.myPanel.getSecondComponent();
            JComponent jComponent = component = view != null ? view.getComponent() : null;
            if (component != currentViewComponent) {
                if (currentViewComponent != null) {
                    currentViewComponent.setVisible(false);
                }
                DuplicatesForm.this.myPanel.setSecondComponent(component);
                if (component != null) {
                    component.setMinimumSize((Dimension)JBUI.size((int)10));
                    component.setVisible(true);
                }
            }
            if (view != null) {
                view.setContent(left, right);
            }
            DuplicatesForm.this.myDuplicatesTree.repaint();
        }
    }

    private static class MyGlassPanePainter
    extends AbstractPainter {
        private Icon myIcon;
        private Point myPoint;

        private MyGlassPanePainter() {
        }

        public boolean setPaint(Icon icon, Point point) {
            this.myIcon = (Icon)this.setNeedsRepaint(this.myIcon, icon);
            this.myPoint = (Point)this.setNeedsRepaint(this.myPoint, point);
            return this.needsRepaint();
        }

        public void executePaint(Component component, Graphics2D g) {
            if (this.myIcon == null) {
                return;
            }
            this.myIcon.paintIcon(component, g, this.myPoint.x, this.myPoint.y);
        }
    }

    private class MySplitter
    extends JBSplitter
    implements UiDataProvider {
        MySplitter() {
            super("DuplicatesForm.settings", 0.3f);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MySplitter.$$$reportNull$$$0(0);
            }
            sink.set(PlatformCoreDataKeys.SELECTED_ITEM, (Object)DuplicatesForm.this.getCodeNode());
            sink.set(PlatformCoreDataKeys.HELP_ID, (Object)DuplicatesForm.ourHelpID);
            if (DuplicatesForm.this.myModel == null) {
                return;
            }
            sink.set(MODEL, (Object)DuplicatesForm.this.myModel);
            CodeNode codeNode = DuplicatesForm.this.myModel.getSelectedCodeNode();
            sink.lazy(CommonDataKeys.NAVIGATABLE, () -> codeNode != null ? codeNode.getOpenFileDescriptorIfValid() : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/dupLocator/resultUI/DuplicatesForm$MySplitter", "uiDataSnapshot"));
        }
    }

    private class MyColoredTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyColoredTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JPanel panel = new JPanel(new BorderLayout(5, 0));
            Color background = UIUtil.getTreeBackground((boolean)sel, (boolean)true);
            UIUtil.changeBackGround((Component)panel, (Color)background);
            SimpleColoredComponent component = new SimpleColoredComponent();
            component.setOpaque(true);
            panel.add((Component)component, "Center");
            if (value instanceof GroupNode) {
                ((GroupNode)value).getTitle(sel).customize(component);
            } else if (value instanceof CodeNode) {
                CodeNode codeNode = (CodeNode)value;
                panel.add((Component)DuplicatesForm.this.myButtonsPanel, "West");
                DuplicatesForm.this.mySendToLeftButton.setIcon(codeNode.isLeftInDiff() ? AllIcons.Duplicates.SendToTheLeft : AllIcons.Duplicates.SendToTheLeftGrayed);
                DuplicatesForm.this.mySendToRightButton.setIcon(codeNode.isRightInDiff() ? AllIcons.Duplicates.SendToTheRight : AllIcons.Duplicates.SendToTheRightGrayed);
                codeNode.getTitle(sel).customize(component);
                panel.setToolTipText(DupLocatorBundle.message("tooltip.tree.text", new Object[0]));
            }
            return panel;
        }
    }

    private static class EliminateDuplicatesAction
    extends AnAction {
        EliminateDuplicatesAction() {
            super(DupLocatorBundle.messagePointer("eliminate.duplicates.action.text", new Object[0]), DupLocatorBundle.messagePointer("eliminate.duplicates.action.text", new Object[0]), AllIcons.Actions.Replace);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                EliminateDuplicatesAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CodeNode node;
            if (e == null) {
                EliminateDuplicatesAction.$$$reportNull$$$0(1);
            }
            if ((node = (CodeNode)ObjectUtils.tryCast((Object)e.getData(PlatformCoreDataKeys.SELECTED_ITEM), CodeNode.class)) == null) {
                return;
            }
            DuplicatesPresentation profile = node.getPresentation();
            assert (profile != null);
            profile.applyFix(node);
        }

        public void update(@NotNull AnActionEvent e) {
            CodeNode node;
            boolean enabled;
            if (e == null) {
                EliminateDuplicatesAction.$$$reportNull$$$0(2);
            }
            boolean bl = enabled = (node = (CodeNode)ObjectUtils.tryCast((Object)e.getData(PlatformCoreDataKeys.SELECTED_ITEM), CodeNode.class)) != null;
            if (enabled) {
                DuplicatesPresentation profile = node.getPresentation();
                enabled = profile != null && profile.isFixAvailable(node);
            }
            e.getPresentation().setEnabled(enabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dupLocator/resultUI/DuplicatesForm$EliminateDuplicatesAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$EliminateDuplicatesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2 -> new IllegalArgumentException(string2);
            };
        }
    }

    private static class SendToAction
    extends AnAction {
        private final int myDiffIndex;

        SendToAction(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, Icon icon, String actionId, int diffIndex) {
            super(text2, description, icon);
            this.myDiffIndex = diffIndex;
            this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)actionId), null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SendToAction.$$$reportNull$$$0(0);
            }
            DuplicatesModel myModel = (DuplicatesModel)e.getData(MODEL);
            myModel.setDiff(this.myDiffIndex, myModel.getSelectedCodeNode());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SendToAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            Object codeNode = e.getData(PlatformCoreDataKeys.SELECTED_ITEM);
            if (!(codeNode instanceof CodeNode) || e.getData(MODEL) == null) {
                presentation.setEnabled(false);
                return;
            }
            presentation.setEnabled(true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SendToAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dupLocator/resultUI/DuplicatesForm$SendToAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$SendToAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    public static class SendToLeftAction
    extends SendToAction {
        public SendToLeftAction() {
            super(DupLocatorBundle.message("duplicates.send.to.left.action", new Object[0]), DupLocatorBundle.message("duplicates.send.to.left.action.description", new Object[0]), AllIcons.Duplicates.SendToTheLeft, DuplicatesForm.SEND_TO_LEFT_ID, 0);
        }
    }

    public static class SendToRightAction
    extends SendToAction {
        public SendToRightAction() {
            super(DupLocatorBundle.message("duplicates.send.to.right.action", new Object[0]), DupLocatorBundle.message("duplicates.send.to.right.action.description", new Object[0]), AllIcons.Duplicates.SendToTheRight, DuplicatesForm.SEND_TO_RIGHT_ID, 1);
        }
    }
}

