/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.codeinsight;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;

public final class CucumberEnterHandler
extends EnterHandlerDelegateAdapter {
    public static final String PYSTRING_QUOTES = "\"\"\"";

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            CucumberEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CucumberEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            CucumberEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            CucumberEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            CucumberEnterHandler.$$$reportNull$$$0(4);
        }
        if (!(file instanceof GherkinFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffsetValue = (Integer)caretOffset.get();
        if (caretOffsetValue < 3) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        String docText = document.getText();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement probableQuotes = file.findElementAt(caretOffsetValue - 1);
        if (probableQuotes != null && probableQuotes.getNode().getElementType() == GherkinTokenTypes.PYSTRING) {
            PsiElement probablePyStringText;
            PsiElement psiElement = probablePyStringText = document.getTextLength() == PYSTRING_QUOTES.length() ? null : file.findElementAt(caretOffsetValue - 1 - PYSTRING_QUOTES.length());
            if (probablePyStringText == null || probablePyStringText.getNode().getElementType() != GherkinTokenTypes.PYSTRING_TEXT) {
                int line = document.getLineNumber(caretOffsetValue);
                int lineStart = document.getLineStartOffset(line);
                int textStart = CharArrayUtil.shiftForward((CharSequence)docText, (int)lineStart, (String)" \t");
                String space = docText.subSequence(lineStart, textStart).toString();
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + space + "\n" + space + PYSTRING_QUOTES));
                editor.getCaretModel().moveCaretRelatively(-3, -1, false, false, true);
                return EnterHandlerDelegate.Result.Stop;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/cucumber/codeinsight/CucumberEnterHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

