/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.OptionalStepDefinitionExtensionPoint;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.inspections.CucumberStepDefinitionCreationContext;
import org.jetbrains.plugins.cucumber.inspections.model.CreateStepDefinitionFileModel;
import org.jetbrains.plugins.cucumber.inspections.ui.CreateStepDefinitionFileDialog;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.CucumberStepHelper;

public abstract class CucumberCreateStepFixBase
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(CucumberCreateStepFixBase.class);

    protected abstract void createStepOrSteps(GherkinStep var1, @NotNull CucumberStepDefinitionCreationContext var2);

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            CucumberCreateStepFixBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        GherkinStep step;
        GherkinFile featureFile;
        ArrayList<CucumberStepDefinitionCreationContext> pairs;
        if (project == null) {
            CucumberCreateStepFixBase.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            CucumberCreateStepFixBase.$$$reportNull$$$0(2);
        }
        if (!(pairs = new ArrayList<CucumberStepDefinitionCreationContext>(CucumberCreateStepFixBase.getStepDefinitionContainers(featureFile = (GherkinFile)(step = (GherkinStep)descriptor.getPsiElement()).getContainingFile()))).isEmpty()) {
            pairs.add(0, new CucumberStepDefinitionCreationContext());
            JBPopupFactory popupFactory = JBPopupFactory.getInstance();
            ListPopup popupStep = popupFactory.createListPopup((ListPopupStep)new BaseListPopupStep<CucumberStepDefinitionCreationContext>(CucumberBundle.message("choose.step.definition.file", new Object[0]), new ArrayList<CucumberStepDefinitionCreationContext>(pairs)){

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(CucumberStepDefinitionCreationContext value) {
                    if (value.getPsiFile() == null) {
                        String string = CucumberBundle.message("create.new.file", new Object[0]);
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }
                    PsiFile psiFile = value.getPsiFile();
                    VirtualFile file = value.getPsiFile().getVirtualFile();
                    assert (file != null);
                    StepDefinitionCreator stepDefinitionCreator = CucumberStepHelper.getExtensionMap().get(value.getFrameworkType()).getStepDefinitionCreator();
                    String string = stepDefinitionCreator.getStepDefinitionFilePath(psiFile);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                public Icon getIconFor(CucumberStepDefinitionCreationContext value) {
                    PsiFile psiFile = value.getPsiFile();
                    return psiFile == null ? AllIcons.Actions.IntentionBulb : psiFile.getIcon(0);
                }

                public PopupStep<?> onChosen(CucumberStepDefinitionCreationContext selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> CucumberCreateStepFixBase.this.createStepOrSteps(step, selectedValue));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberCreateStepFixBase$1", "getTextFor"));
                }
            });
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                popupStep.showCenteredInCurrentWindow(step.getProject());
            } else {
                this.createStepOrSteps(step, (CucumberStepDefinitionCreationContext)pairs.get(1));
            }
        } else {
            this.createStepOrSteps(step, new CucumberStepDefinitionCreationContext());
        }
    }

    public static Set<CucumberStepDefinitionCreationContext> getStepDefinitionContainers(@NotNull GherkinFile featureFile) {
        if (featureFile == null) {
            CucumberCreateStepFixBase.$$$reportNull$$$0(3);
        }
        Set<CucumberStepDefinitionCreationContext> result = CucumberStepHelper.getStepDefinitionContainers(featureFile);
        result.removeIf(e -> CucumberStepHelper.getExtensionMap().get(e.getFrameworkType()) == null);
        return result;
    }

    private boolean createStepDefinitionFile(GherkinStep step, @NotNull CucumberStepDefinitionCreationContext context) {
        if (context == null) {
            CucumberCreateStepFixBase.$$$reportNull$$$0(4);
        }
        PsiFile featureFile = step.getContainingFile();
        assert (featureFile != null);
        CreateStepDefinitionFileModel model = CucumberCreateStepFixBase.askUserForFilePath(step);
        if (model == null) {
            return false;
        }
        String filePath = FileUtil.toSystemDependentName((String)model.getFilePath());
        BDDFrameworkType frameworkType = model.getSelectedFileType();
        context.setFrameworkType(frameworkType);
        Project project = step.getProject();
        if (LocalFileSystem.getInstance().findFileByPath(filePath) == null) {
            String parentDirPath = model.getStepDefinitionFolderPath();
            WriteCommandAction.runWriteCommandAction((Project)project, (String)CucumberBundle.message("create.step.definition", new Object[0]), null, () -> CommandProcessor.getInstance().executeCommand(project, () -> {
                try {
                    VirtualFile parentDir = VfsUtil.createDirectories((String)parentDirPath);
                    PsiDirectory parentPsiDir = PsiManager.getInstance((Project)project).findDirectory(parentDir);
                    assert (parentPsiDir != null);
                    PsiFile newFile = CucumberStepHelper.createStepDefinitionFile(parentPsiDir, model.getFileName(), frameworkType);
                    this.createStepDefinition(step, new CucumberStepDefinitionCreationContext(newFile, frameworkType));
                    context.setPsiFile(newFile);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }, CucumberBundle.message("cucumber.quick.fix.create.step.command.name.create", new Object[0]), null), (PsiFile[])new PsiFile[0]);
            return true;
        }
        Messages.showErrorDialog((Project)project, (String)CucumberBundle.message("cucumber.quick.fix.create.step.error.already.exist.msg", filePath), (String)CucumberBundle.message("cucumber.quick.fix.create.step.file.name.title", new Object[0]));
        return false;
    }

    protected boolean createFileOrStepDefinition(GherkinStep step, @NotNull CucumberStepDefinitionCreationContext context) {
        if (context == null) {
            CucumberCreateStepFixBase.$$$reportNull$$$0(5);
        }
        if (context.getFrameworkType() == null) {
            return this.createStepDefinitionFile(step, context);
        }
        this.createStepDefinition(step, context);
        return true;
    }

    protected boolean shouldRunTemplateOnStepDefinition() {
        return true;
    }

    @Nullable
    private static CreateStepDefinitionFileModel askUserForFilePath(@NotNull GherkinStep step) {
        if (step == null) {
            CucumberCreateStepFixBase.$$$reportNull$$$0(6);
        }
        InputValidator validator = new InputValidator(){

            public boolean checkInput(String filePath) {
                return !StringUtil.isEmpty((String)filePath);
            }

            public boolean canClose(String fileName) {
                return true;
            }
        };
        HashMap<BDDFrameworkType, String> supportedFileTypesAndDefaultFileNames = new HashMap<BDDFrameworkType, String>();
        HashMap<BDDFrameworkType, String> fileTypeToDefaultDirectoryMap = new HashMap<BDDFrameworkType, String>();
        for (CucumberJvmExtensionPoint e : CucumberJvmExtensionPoint.EP_NAME.getExtensionList()) {
            if (e instanceof OptionalStepDefinitionExtensionPoint && !((OptionalStepDefinitionExtensionPoint)e).participateInStepDefinitionCreation(step)) continue;
            supportedFileTypesAndDefaultFileNames.put(e.getStepFileType(), e.getStepDefinitionCreator().getDefaultStepFileName(step));
            fileTypeToDefaultDirectoryMap.put(e.getStepFileType(), e.getStepDefinitionCreator().getDefaultStepDefinitionFolderPath(step));
        }
        CreateStepDefinitionFileModel model = new CreateStepDefinitionFileModel(step.getContainingFile(), supportedFileTypesAndDefaultFileNames, fileTypeToDefaultDirectoryMap);
        CreateStepDefinitionFileDialog createStepDefinitionFileDialog = new CreateStepDefinitionFileDialog(step.getProject(), model, validator);
        if (createStepDefinitionFileDialog.showAndGet()) {
            return model;
        }
        return null;
    }

    private void createStepDefinition(GherkinStep step, @NotNull CucumberStepDefinitionCreationContext context) {
        if (context == null) {
            CucumberCreateStepFixBase.$$$reportNull$$$0(7);
        }
        StepDefinitionCreator stepDefCreator = CucumberStepHelper.getExtensionMap().get(context.getFrameworkType()).getStepDefinitionCreator();
        PsiFile file = context.getPsiFile();
        if (file != null) {
            WriteCommandAction.runWriteCommandAction((Project)step.getProject(), null, null, () -> stepDefCreator.createStepDefinition(step, file, this.shouldRunTemplateOnStepDefinition()), (PsiFile[])new PsiFile[]{file});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/CucumberCreateStepFixBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureFile";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/CucumberCreateStepFixBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStepDefinitionContainers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinitionFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFileOrStepDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "askUserForFilePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

