/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.GherkinInspection;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinExamplesBlock;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;

public final class GherkinBrokenTableInspection
extends GherkinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            GherkinBrokenTableInspection.$$$reportNull$$$0(0);
        }
        return new GherkinElementVisitor(){

            @Override
            public void visitScenarioOutline(GherkinScenarioOutline outline) {
                List<GherkinExamplesBlock> examples = outline.getExamplesBlocks();
                for (GherkinExamplesBlock block : examples) {
                    if (block.getTable() == null) continue;
                    GherkinBrokenTableInspection.checkTable(block.getTable(), holder);
                }
            }

            @Override
            public void visitStep(GherkinStep step) {
                GherkinTable table = (GherkinTable)PsiTreeUtil.getChildOfType((PsiElement)step, GherkinTable.class);
                if (table != null) {
                    GherkinBrokenTableInspection.checkTable(table, holder);
                }
            }
        };
    }

    private static void checkTable(@NotNull GherkinTable table, @NotNull ProblemsHolder holder) {
        if (table == null) {
            GherkinBrokenTableInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            GherkinBrokenTableInspection.$$$reportNull$$$0(2);
        }
        GherkinTableRow header = table.getHeaderRow();
        for (GherkinTableRow row : table.getDataRows()) {
            if (header == null) {
                header = row;
            }
            if (row.getPsiCells().size() == header.getPsiCells().size()) continue;
            holder.registerProblem((PsiElement)row, CucumberBundle.message("inspection.gherkin.table.is.broken.row.error.message", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NotNull
    public String getShortName() {
        return "GherkinBrokenTableInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/GherkinBrokenTableInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

