/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.io.IdeUtilIoBundle;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.framework.FrameworkCurrentInputData;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.parsing.OptionPart;
import com.jetbrains.php.framework.parsing.ParamPart;
import com.jetbrains.php.framework.parsing.UserInputPart;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import java.awt.Component;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FrameworkUtils {
    @NonNls
    public static final String NOTIFICATION_GROUP_ID = "Command Line Tool";
    @NonNls
    private static final Logger LOG = Logger.getInstance(FrameworkUtils.class);
    private static final long EXECUTION_TIMEOUT = 60000L;
    public static final String PROJECT_DIR_VARIABLE_SYMBOL = FrameworkUtils.getMacroDesignation((Macro)new ProjectFileDirMacro());

    private FrameworkUtils() {
    }

    public static boolean isCommandTextValid(String text, FrameworkCommand command) {
        String basicText = command.getAliasedBasicText();
        if (!basicText.equals(text + " ") && !text.startsWith(basicText)) {
            return false;
        }
        String parametersString = text.substring(Math.min(command.getAliasedBasicText().length(), text.length()));
        int numberOfArgs = FrameworkUtils.getParameterNumber(parametersString);
        return numberOfArgs >= command.getMinAllowedParametersNumber() && (numberOfArgs <= command.getParameters().size() || command.hasInfiniteParameters());
    }

    public static int getParameterNumber(String parametersString) {
        int numberOfArgs = 0;
        boolean quoteStarted = false;
        boolean doubleQuoteStarted = false;
        boolean previousSpace = true;
        for (char ch : parametersString.toCharArray()) {
            if (' ' == ch) {
                if (!(previousSpace || quoteStarted || doubleQuoteStarted)) {
                    ++numberOfArgs;
                }
                previousSpace = true;
                continue;
            }
            if ('-' == ch && previousSpace) {
                --numberOfArgs;
            }
            previousSpace = false;
            if ('\'' == ch) {
                quoteStarted = !quoteStarted;
                continue;
            }
            if ('\"' != ch) continue;
            doubleQuoteStarted = !doubleQuoteStarted;
        }
        if (!previousSpace) {
            ++numberOfArgs;
        }
        return numberOfArgs;
    }

    public static boolean isTextValid(String enteredText, FrameworkCommand chosenElement) {
        return chosenElement.getParameters().isEmpty() || FrameworkUtils.isCommandTextValid(enteredText, chosenElement);
    }

    @NlsContexts.NotificationContent
    public static String getErrorMessage(String invalidText, FrameworkCommand chosenElement) {
        int maxAllowed;
        int minAllowed = chosenElement.getMinAllowedParametersNumber();
        int n = maxAllowed = chosenElement.hasInfiniteParameters() ? Integer.MAX_VALUE : chosenElement.getParameters().size();
        if (minAllowed == maxAllowed) {
            return FrameworkBundle.message("framework.command.autocompletion.model.expected.0.parameter.s", minAllowed, minAllowed);
        }
        if (!chosenElement.hasInfiniteParameters()) {
            return FrameworkBundle.message("framework.command.autocompletion.model.expected.from.0.to.1.parameters", minAllowed, maxAllowed);
        }
        return FrameworkBundle.message("framework.command.autocompletion.model.expected.at.least.0.parameters", minAllowed);
    }

    public static boolean containsMacro(FrameworkCommand command) {
        return FrameworkUtils.lastMacroParameterIndex(command) > -1;
    }

    @Nullable
    public static Project getProject(@Nullable Component component) {
        if (component == null) {
            return null;
        }
        DataContext context = DataManager.getInstance().getDataContext(component);
        return (Project)CommonDataKeys.PROJECT.getData(context);
    }

    private static boolean mayBeMacroName(String savedDefaultValue) {
        return savedDefaultValue != null && savedDefaultValue.contains("$") && savedDefaultValue.length() > 2;
    }

    public static int lastMacroParameterIndex(@NotNull FrameworkCommand command) {
        if (command == null) {
            FrameworkUtils.$$$reportNull$$$0(0);
        }
        int param = 0;
        int result = -1;
        for (FrameworkCommand.Parameter parameter : command.getParameters()) {
            String defaultValue = parameter.getDefaultValue();
            if (FrameworkUtils.mayBeMacroName(defaultValue)) {
                for (Macro macro : MacroManager.getInstance().getMacros()) {
                    if (!defaultValue.contains(FrameworkUtils.getMacroDesignation(macro))) continue;
                    result = param;
                }
            }
            ++param;
        }
        return result;
    }

    public static String getMacroDesignation(@NotNull Macro macro) {
        if (macro == null) {
            FrameworkUtils.$$$reportNull$$$0(1);
        }
        return "$" + macro.getName() + "$";
    }

    public static ScriptRunnerUtil.ScriptOutput executeCommandWithFullOutput(@NonNls String[] command, @Nullable String workingDirectory, @Nullable Project project, boolean parseStdOut, boolean parseSrtErr) throws ExecutionException {
        return FrameworkUtils.executeCommandWithFullOutput(command, workingDirectory, project, parseStdOut, parseSrtErr, false, false);
    }

    public static ScriptRunnerUtil.ScriptOutput executeCommandWithFullOutput(@NonNls String[] command, @Nullable String workingDirectory, @Nullable Project project, boolean parseStdOut, boolean parseSrtErr, boolean parseSystem, boolean parseUnknown) throws ExecutionException {
        PhpInterpreter interpreter;
        Condition scriptOutputType = key -> {
            if (ProcessOutputTypes.STDOUT.equals(key)) {
                return parseStdOut;
            }
            if (ProcessOutputTypes.STDERR.equals(key)) {
                return parseSrtErr;
            }
            if (ProcessOutputTypes.SYSTEM.equals(key)) {
                return parseSystem;
            }
            return parseUnknown;
        };
        if ("EXECUTABLE".equals(command[0])) {
            String exeCommand = command[1];
            command = Arrays.copyOfRange(command, 2, command.length);
            if (workingDirectory == null) {
                workingDirectory = project.getBasePath();
            }
            return ScriptRunnerUtil.executeScriptInConsoleWithFullOutput((String)exeCommand, null, (String)workingDirectory, (long)60000L, (Condition)scriptOutputType, (String[])command);
        }
        String phpInterpreter = command[0];
        PhpInterpreter phpInterpreter2 = interpreter = "PROJECT_DEFAULT_INTERPRETER".equals(phpInterpreter) ? PhpProjectConfigurationFacade.getInstance((Project)project).getInterpreter() : PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterById(phpInterpreter);
        if (interpreter != null && interpreter.isRemote()) {
            PhpRemoteInterpreterManager instance = PhpRemoteInterpreterManager.getInstance();
            if (instance == null) {
                throw new ExecutionException(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
            }
            PhpCommandSettings phpCommand = new PhpCommandSettingsBuilder(project, interpreter).build();
            PhpSdkFileTransfer transfer = PhpSdkFileTransfer.getSdkFileTransfer((PhpSdkAdditionalData)interpreter.getPhpSdkAdditionalData());
            for (String param : Arrays.copyOfRange(command, 1, command.length)) {
                phpCommand.addPathArgument(param);
            }
            transfer.updateCommand(phpCommand);
            try {
                ScriptRunnerUtil.ScriptOutput output = new ScriptRunnerUtil.ScriptOutput(scriptOutputType);
                ProcessHandler processHandler = PhpRemoteInterpreterManager.getInstance().getRemoteProcessHandler(project, interpreter.getPhpSdkAdditionalData(), phpCommand.createGeneralCommandLine(), true, new PathMappingSettings.PathMapping[0]);
                processHandler.addProcessListener((ProcessListener)output);
                processHandler.startNotify();
                if (!processHandler.waitFor(1800000L)) {
                    LOG.warn("Process did not complete in 60s");
                    throw new ExecutionException(IdeUtilIoBundle.message((String)"script.execution.timeout", (Object[])new Object[]{String.valueOf(60L)}));
                }
                LOG.debug("script output: ", new Object[]{output.myFilteredOutput});
                return output;
            }
            catch (ExecutionException | InterruptedException e) {
                LOG.warn(e);
            }
        }
        command = Arrays.copyOfRange(command, 1, command.length);
        if (workingDirectory == null) {
            workingDirectory = project.getBasePath();
        }
        return ScriptRunnerUtil.executeScriptInConsoleWithFullOutput((String)(interpreter != null ? interpreter.getPathToPhpExecutable() : phpInterpreter), null, (String)workingDirectory, (long)60000L, (Condition)scriptOutputType, (String[])command);
    }

    @Nullable
    public static String resolveMacros(String commandWithMacros, DataContext dataContext) {
        try {
            return MacroManager.getInstance().expandMacrosInString(commandWithMacros, false, dataContext);
        }
        catch (Macro.ExecutionCancelledException e) {
            return commandWithMacros;
        }
    }

    public static String getCurrentFormattedDate() {
        return DateFormat.getDateTimeInstance(3, 3).format(new Date());
    }

    @Nullable
    public static String getFrameworkName(String frameworkId) {
        if (frameworkId == null) {
            return null;
        }
        for (FrameworkDescriptionProvider provider : (FrameworkDescriptionProvider[])FrameworkDescriptionProvider.EP.getExtensions()) {
            if (!frameworkId.equals(provider.getFrameworkId())) continue;
            return provider.getFrameworkName();
        }
        return null;
    }

    @Nullable
    public static String getFrameworkId(String frameworkName) {
        if (frameworkName == null) {
            return null;
        }
        for (FrameworkDescriptionProvider provider : (FrameworkDescriptionProvider[])FrameworkDescriptionProvider.EP.getExtensions()) {
            if (!frameworkName.equals(provider.getFrameworkName())) continue;
            return provider.getFrameworkId();
        }
        return null;
    }

    @Nullable
    public static FrameworkDescriptionProvider getMatchingProvider(FrameworkConfigurationDescription framework) {
        String frameworkId = framework.getFramework().getFrameworkId();
        if (!StringUtil.isEmpty((String)frameworkId)) {
            for (FrameworkDescriptionProvider provider : (FrameworkDescriptionProvider[])FrameworkDescriptionProvider.EP.getExtensions()) {
                if (!frameworkId.equals(provider.getFrameworkId())) continue;
                return provider;
            }
        }
        return null;
    }

    public static void checkProgress(@NotNull ProgressIndicator pi) throws RunCanceledByUserException {
        if (pi == null) {
            FrameworkUtils.$$$reportNull$$$0(2);
        }
        if (pi.isCanceled()) {
            throw new RunCanceledByUserException();
        }
    }

    public static List<UserInputPart> parseCurrentInput(String userInput, FrameworkCommand matchingCommand) {
        userInput = StringUtil.notNullize((String)userInput);
        @NonNls String parameterString = userInput.substring(matchingCommand.getAliasedBasicText().length());
        List parts = StringUtil.splitHonorQuotes((String)parameterString, (char)' ');
        ArrayList<UserInputPart> result = new ArrayList<UserInputPart>(parts.size());
        UserInputPart optionPart = OptionPart.cutOption(parts, matchingCommand.getOptionsBeforeParams());
        while (optionPart != null) {
            result.add(optionPart);
            optionPart = OptionPart.cutOption(parts, matchingCommand.getOptionsBeforeParams());
        }
        int i = 0;
        optionPart = ParamPart.cutParam(parts, i);
        while (optionPart != null) {
            result.add(optionPart);
            optionPart = ParamPart.cutParam(parts, ++i);
        }
        if (parts.isEmpty() && result.size() == 0) {
            result.add(OptionPart.EMPTY);
        } else if (parameterString.endsWith(" ")) {
            if (result.isEmpty()) {
                result.add(OptionPart.EMPTY);
            } else {
                UserInputPart part = (UserInputPart)result.get(result.size() - 1);
                if (part instanceof OptionPart) {
                    result.add(OptionPart.EMPTY);
                } else if (part instanceof ParamPart) {
                    result.add(new ParamPart("", ((ParamPart)part).getNumber() + 1));
                }
            }
        }
        LOG.assertTrue(!result.isEmpty(), (Object)("Empty parse of '" + userInput + "'"));
        return result;
    }

    @NotNull
    public static String getParamsDescription(FrameworkCommand command, boolean enableHtml, int currentParameter) {
        @NonNls StringBuilder sb = new StringBuilder();
        int i = 0;
        if (enableHtml) {
            sb.append("<html><body>");
        }
        List<FrameworkCommand.Parameter> parameters = command.getParameters();
        for (FrameworkCommand.Parameter parameter : parameters.subList(currentParameter, parameters.size())) {
            if (enableHtml && i == currentParameter) {
                sb.append("<b>");
            }
            sb.append(" ").append(parameter.getName());
            if (parameter.hasDefaultValue()) {
                sb.append("[=").append(parameter.getDefaultValue()).append("]");
            }
            if (enableHtml && i == currentParameter) {
                sb.append("</b>");
            }
            ++i;
        }
        if (command.hasInfiniteParameters()) {
            if (currentParameter > command.getParameters().size() - 1) {
                sb.append(" <b>...</b>");
            } else {
                sb.append(" ...");
            }
        }
        if (enableHtml) {
            sb.append("</body></html>");
        }
        String string = sb.toString();
        if (string == null) {
            FrameworkUtils.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static String getCommandWithMacrosToExecute(String userText, FrameworkCommand command) {
        if (!command.canBeUsedWithoutParameters() || FrameworkUtils.isCommandTextValid((String)userText, command)) {
            userText = ((String)userText).startsWith(command.getAliasedBasicText()) ? command.getInvocationBasicText() + ((String)userText).substring(command.getAliasedBasicText().length()) : command.getInvocationBasicText();
            if (!FrameworkUtils.containsMacro(command)) {
                return userText;
            }
            int providedParams = FrameworkUtils.getParameterNumber(((String)userText).substring(command.getInvocationBasicText().length()));
            StringBuilder sb = new StringBuilder(((String)userText).trim());
            List<FrameworkCommand.Parameter> parameters = command.getParameters();
            for (int i = providedParams; i <= FrameworkUtils.lastMacroParameterIndex(command); ++i) {
                sb.append(" ").append(parameters.get(i).getDefaultValue());
            }
            return sb.toString();
        }
        String result = command.getInvocationBasicText();
        if (((String)userText).startsWith(command.getAliasedBasicText())) {
            StringBuilder sb = new StringBuilder();
            sb.append(result);
            String optionsString = ((String)userText).substring(command.getAliasedBasicText().length());
            List probableOptions = StringUtil.splitHonorQuotes((String)optionsString, (char)' ');
            for (String probableOption : probableOptions) {
                if (!probableOption.startsWith("-")) continue;
                sb.append(" ").append(probableOption);
            }
            return sb.toString();
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macro";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/FrameworkUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/FrameworkUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamsDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "lastMacroParameterIndex";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMacroDesignation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkProgress";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static class UserInputAnalyzer {
        public final boolean isExecutable;
        public final @NlsContexts.NotificationContent String myErrorMessage;
        public final String myCommandToExecute;
        public final FrameworkCommand myCommand;

        public UserInputAnalyzer(String userText, DataContext dataContext, Project project) {
            String tempCommandToExecute;
            FrameworkDataService dataService = FrameworkDataService.getInstance(project);
            this.myCommand = FrameworkCurrentInputData.countInputData(userText, dataService.getCommands()).findCommand(true, false);
            if (userText.isEmpty()) {
                this.isExecutable = false;
                this.myErrorMessage = null;
                this.myCommandToExecute = null;
                return;
            }
            if (this.myCommand != null && !FrameworkUtils.isTextValid(userText, this.myCommand)) {
                this.isExecutable = false;
                this.myErrorMessage = FrameworkUtils.getErrorMessage(userText, this.myCommand);
            } else {
                this.isExecutable = true;
                this.myErrorMessage = null;
            }
            if (this.myCommand == null) {
                tempCommandToExecute = userText;
                for (Map.Entry<String, String> aliasEntry : dataService.getAliasesAndInvokeTexts().entrySet()) {
                    String alias = aliasEntry.getKey();
                    if (!userText.startsWith(alias) || userText.length() != alias.length() && userText.charAt(alias.length()) != ' ') continue;
                    tempCommandToExecute = userText.replaceFirst(alias, Matcher.quoteReplacement(aliasEntry.getValue()));
                    break;
                }
            } else {
                tempCommandToExecute = FrameworkUtils.getCommandWithMacrosToExecute(userText, this.myCommand);
            }
            this.myCommandToExecute = FrameworkUtils.resolveMacros(tempCommandToExecute, dataContext);
        }
    }
}

