/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.completion;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class FrameworkPathCompletionUtil {
    public static void addPathCompletionVariants(@NotNull String text, @NotNull VirtualFile vFile, @NotNull List<String> result) {
        VirtualFile currentFile;
        String chosenPath;
        String providedPath;
        if (text == null) {
            FrameworkPathCompletionUtil.$$$reportNull$$$0(0);
        }
        if (vFile == null) {
            FrameworkPathCompletionUtil.$$$reportNull$$$0(1);
        }
        if (result == null) {
            FrameworkPathCompletionUtil.$$$reportNull$$$0(2);
        }
        if ((providedPath = FrameworkPathCompletionUtil.getProvidedPartOfPath(chosenPath = StringUtil.trimStart((String)FrameworkPathCompletionUtil.getPathPrefix(text), (String)"\""))).isEmpty() && SystemInfo.isWindows && FrameworkPathCompletionUtil.isWindowsRootString(chosenPath)) {
            String resultingString = chosenPath + "/";
            VirtualFile root = LocalFileSystem.getInstance().findFileByPath(resultingString);
            if (root != null) {
                result.add(chosenPath + FrameworkPathCompletionUtil.getQuotedPath(resultingString));
                return;
            }
        }
        if ((currentFile = FileUtil.isAbsolute((String)(providedPath = FileUtil.toSystemIndependentName((String)providedPath))) ? LocalFileSystem.getInstance().findFileByPath(providedPath) : vFile.findFileByRelativePath(providedPath)) == null || !currentFile.isDirectory()) {
            return;
        }
        VirtualFile[] children = currentFile.getChildren();
        String prefixForCompletion = FrameworkPathCompletionUtil.getPrefixForCompletion(chosenPath);
        String pathPrefix = FrameworkPathCompletionUtil.getPathPrefix(text);
        String patternPrefix = StringUtil.substringBeforeLast((String)text, (String)pathPrefix);
        String pathPrefixPart = StringUtil.substringBeforeLast((String)pathPrefix, (String)prefixForCompletion);
        for (VirtualFile child : children) {
            String name = child.getName();
            if (!name.contains(prefixForCompletion)) continue;
            result.add(patternPrefix + FrameworkPathCompletionUtil.getQuotedPath(pathPrefixPart + name));
        }
    }

    @NotNull
    private static String getQuotedPath(@NotNull String path) {
        if (path == null) {
            FrameworkPathCompletionUtil.$$$reportNull$$$0(3);
        }
        if (path.contains(" ") && !path.startsWith("\"")) {
            String string = "\"" + path + "\"";
            if (string == null) {
                FrameworkPathCompletionUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            FrameworkPathCompletionUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean isWindowsRootString(String path) {
        return path.length() == 2 && OSAgnosticPathUtil.startsWithWindowsDrive((String)path);
    }

    private static String getProvidedPartOfPath(String chosenPath) {
        int indexOfSeparator = Math.max(chosenPath.lastIndexOf("/"), chosenPath.lastIndexOf("\\"));
        return chosenPath.substring(0, indexOfSeparator + 1);
    }

    @NotNull
    private static String getPathPrefix(@NotNull String inputText) {
        if (inputText == null) {
            FrameworkPathCompletionUtil.$$$reportNull$$$0(6);
        }
        if (inputText.endsWith(" ")) {
            return "";
        }
        List parts = StringUtil.splitHonorQuotes((String)inputText, (char)' ');
        if (parts.isEmpty()) {
            return "";
        }
        String string = (String)parts.get(parts.size() - 1);
        if (string == null) {
            FrameworkPathCompletionUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static String getPrefixForCompletion(String chosenPath) {
        int indexOfSeparator = Math.max(chosenPath.lastIndexOf("/"), chosenPath.lastIndexOf("\\"));
        if (indexOfSeparator == -1 && chosenPath.length() > 1 && chosenPath.lastIndexOf("=") == chosenPath.length() - 1) {
            indexOfSeparator = chosenPath.lastIndexOf("=");
        }
        if (indexOfSeparator != -1) {
            return chosenPath.substring(indexOfSeparator + 1);
        }
        return chosenPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/completion/FrameworkPathCompletionUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/completion/FrameworkPathCompletionUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuotedPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addPathCompletionVariants";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQuotedPath";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPathPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

