/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.laravel;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.composer.configData.PackageComposerConfigClient;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.laravel.LaravelComponentDescriptionProvider;
import com.jetbrains.php.framework.generators.symfony.SymfonyVersion;
import com.jetbrains.php.framework.generators.symfonycomponent.ComponentData;
import com.jetbrains.php.framework.generators.symfonycomponent.SymfonyComponentUtils;
import com.jetbrains.php.framework.ui.CommandLineOpenSettingsProvider;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LaravelCommandLineComposerConfig
extends PackageComposerConfigClient {
    @NonNls
    private static final String PACKAGE = "laravel/framework";
    public static final String ARTISAN = "artisan";

    private LaravelCommandLineComposerConfig() {
        super(PACKAGE, PACKAGE);
    }

    public void updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter, @Nullable VirtualFile config) {
        FrameworkDataService instance;
        VirtualFile projectDir;
        VirtualFile artisan;
        if (project == null) {
            LaravelCommandLineComposerConfig.$$$reportNull$$$0(0);
        }
        VirtualFile virtualFile = artisan = (projectDir = ProjectUtil.guessProjectDir((Project)project)) != null ? projectDir.findChild(ARTISAN) : null;
        if (artisan != null && !ContainerUtil.exists((instance = FrameworkDataService.getInstance(project)).getCommands(), i -> i.getFrameworkDescription().getFrameworkId().equals("com.laravel.component"))) {
            String[] path;
            if (SystemInfo.isWindows) {
                PhpInterpreter phpInterpreter = (PhpInterpreter)ContainerUtil.find((Iterable)PhpInterpretersManagerImpl.getInstance((Project)project).getInterpreters(), i -> !i.isRemote());
                if (phpInterpreter == null) {
                    return;
                }
                path = new String[]{phpInterpreter.getId(), artisan.getPath()};
            } else {
                path = new String[]{artisan.getPath()};
            }
            FrameworkDescription description = SymfonyComponentUtils.getFrameworkDescription(path, ARTISAN, FrameworkBundle.message("framework.laravel.component.name", new Object[0]), "com.laravel.component", SymfonyVersion.VERSION_3);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    List<FrameworkCommand> commands = new LaravelComponentDescriptionProvider().getFrameworkCommands(new ComponentData(path, ARTISAN, SymfonyVersion.VERSION_3), project, (ProgressIndicator)new ProgressIndicatorBase());
                    List<FrameworkDataService.FrameworkFileData> data = instance.cloneData();
                    data.add(new FrameworkDataService.FrameworkFileData(new FrameworkConfigurationDescription(description, commands), null, artisan.getPath(), true));
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> instance.loadChanged(data));
                    this.notify(project, FrameworkBundle.message("laravel.command.line.tool.updated", new Object[0]), CommandLineOpenSettingsProvider.LARAVEL_COMMAND_LINE_OPEN_SETTINGS_PROVIDER);
                }
                catch (FrameworkDescriptionProvider.FrameworkExecutionException | FrameworkDescriptionProvider.FrameworkParseException exception) {
                    // empty catch block
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/framework/generators/laravel/LaravelCommandLineComposerConfig", "updateSettings"));
    }
}

