/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.zendtool.first;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.zendtool.first.Zend1Command;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class Zend1HelpParser {
    private Zend1HelpParser() {
    }

    static void fillWithDefaultValueAndHelp(List<? extends Zend1Command> commands, String path, @Nullable Project project, FrameworkDescription zendFramework, ProgressIndicator pi) throws ExecutionException {
        String[] mainHelp = FrameworkUtils.executeCommandWithFullOutput(new String[]{path, "--help"}, null, project, true, true, false, !SystemInfo.isWindows).getOutputToParseArray();
        FrameworkUtils.checkProgress(pi);
        ArrayList<Zend1Command> unhandledCommands = new ArrayList<Zend1Command>(commands);
        Zend1HelpParser.readLinesIntoCommands(mainHelp, unhandledCommands);
        while (!unhandledCommands.isEmpty()) {
            FrameworkUtils.checkProgress(pi);
            Zend1Command command = (Zend1Command)unhandledCommands.get(0);
            String[] helpCommandText = Zend1HelpParser.getHelpCommand(command, path);
            String[] specialtyHelp = FrameworkUtils.executeCommandWithFullOutput(helpCommandText, null, project, true, true, false, !SystemInfo.isWindows).getOutputToParseArray();
            Zend1HelpParser.readLinesIntoCommands(specialtyHelp, unhandledCommands);
            if (!unhandledCommands.contains(command)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            for (String s : helpCommandText) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(s);
            }
            throw new ExecutionException(FrameworkBundle.message("framework.zend.help.parser.failed.to.find.help.for.0.in.1.output", command.getBasicText(), stringBuilder.toString()));
        }
    }

    private static String[] getHelpCommand(Zend1Command command, String path) {
        if (command.getSpecialty() == null) {
            return new String[]{path, command.getBasicText(), "?"};
        }
        return new String[]{path, command.getAction(), command.getProvider() + ".?"};
    }

    private static void readLinesIntoCommands(String[] mainHelp, List<Zend1Command> unhandledCommands) {
        block0: for (String helpLine : mainHelp) {
            if (!(helpLine = helpLine.trim()).startsWith("zf ")) continue;
            helpLine = helpLine.substring(3);
            Iterator<Zend1Command> iterator = unhandledCommands.iterator();
            while (iterator.hasNext()) {
                Zend1Command command = iterator.next();
                if (!helpLine.startsWith(command.getBasicText())) continue;
                Zend1HelpParser.readParameterDefaultValues(helpLine, command);
                command.setHelp(helpLine);
                iterator.remove();
                continue block0;
            }
        }
    }

    private static void readParameterDefaultValues(String helpLine, Zend1Command command) {
        for (FrameworkCommand.Parameter parameter : command.getParameters()) {
            int parameterIndex = helpLine.indexOf(parameter.getName());
            int firstBracketIndex = parameterIndex + parameter.getName().length();
            if (firstBracketIndex >= helpLine.length() || '[' != helpLine.charAt(firstBracketIndex)) continue;
            String defaultValue = helpLine.substring(firstBracketIndex + 2, helpLine.indexOf(93, firstBracketIndex));
            parameter.setDefaultValue(defaultValue);
        }
    }
}

