/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.ui;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ValidatingTableEditor;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.custom.CustomUtils;
import com.jetbrains.php.framework.runAnything.FrameworkRunAnythingProvider;
import com.jetbrains.php.framework.ui.FailedToParseDialog;
import com.jetbrains.php.framework.ui.FrameworkChooseProviderDialog;
import com.jetbrains.php.framework.ui.FrameworkEditDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkCommandsForm {
    private static final Logger LOG = Logger.getInstance(FrameworkCommandsForm.class);
    private static final Icon EDIT_ACTION_ICON = AllIcons.Actions.Edit;
    private static final Icon SHOW_IN_EDITOR_ICON = AllIcons.Actions.EditSource;
    private static final Integer CREATE_WITH_PROJECT_VISIBILITY = 0;
    private static final Integer CREATE_WITH_GLOBAL_VISIBILITY = 1;
    private static final Integer DO_NOT_CREATE = 2;
    @NonNls
    private static final String SHOW_PREDEFINED_FRAMEWORK_COLUMN = "clt.show.predefined.framework.column";
    private static final boolean SHOW_PREDEFINED_FRAMEWORK_COLUMN_DEFAULT_VALUE = true;
    private final Project myProject;
    private JPanel myMainPanel;
    private JPanel myTableEditorPanel;
    private JBCheckBox myFrameworkTypeColumnCheckbox;
    private final ValidatingTableEditor<FrameworkDataService.FrameworkFileData> myTableEditor;
    private final List<FrameworkConfigurationDescription> myFrameworksToOpenInEditor;

    public FrameworkCommandsForm(Project project) {
        this.$$$setupUI$$$();
        this.myFrameworksToOpenInEditor = new ArrayList<FrameworkConfigurationDescription>();
        this.myProject = project;
        this.myTableEditor = new FrameworkValidatingTableEditor(this.myProject, new AnAction[]{new EditActionButton(), new ReloadCommandsActionButton(), new ShowInEditorActionButton()});
        this.myTableEditorPanel.add(this.myTableEditor.getContentPane(), "Center");
        FrameworkDataService dataService = FrameworkDataService.getInstance(project);
        List<FrameworkDataService.FrameworkFileData> data = dataService.cloneData();
        this.myTableEditor.setModel(this.getColumnInfos(), data);
        this.myTableEditor.setColumnReorderingAllowed(false);
        this.myFrameworkTypeColumnCheckbox.setSelected(PropertiesComponent.getInstance().getBoolean(SHOW_PREDEFINED_FRAMEWORK_COLUMN, true));
        this.myFrameworkTypeColumnCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = FrameworkCommandsForm.this.myFrameworkTypeColumnCheckbox.isSelected();
                PropertiesComponent.getInstance().setValue(FrameworkCommandsForm.SHOW_PREDEFINED_FRAMEWORK_COLUMN, selected, true);
                FrameworkCommandsForm.this.myTableEditor.setModel(FrameworkCommandsForm.this.getColumnInfos(), FrameworkCommandsForm.this.myTableEditor.getItems());
            }
        });
    }

    private ColumnInfo<FrameworkDataService.FrameworkFileData, Object>[] getColumnInfos() {
        boolean showAll = PropertiesComponent.getInstance().getBoolean(SHOW_PREDEFINED_FRAMEWORK_COLUMN, true);
        if (showAll) {
            return new ColumnInfo[]{new EnabledColumnInfo(), new AliasColumnInfo(), new InterpreterColumnInfo(), new InvocationColumnInfo(), new PredefinedFrameworkColumnInfo()};
        }
        return new ColumnInfo[]{new EnabledColumnInfo(), new AliasColumnInfo(), new InterpreterColumnInfo(), new InvocationColumnInfo()};
    }

    @Nullable
    private <UserData> FrameworkConfigurationDescription loadCommands(FrameworkDescriptionProvider<UserData> provider, Project project) {
        UserData path;
        try {
            path = provider.getFrameworkUserData(project);
        }
        catch (RunCanceledByUserException e) {
            return null;
        }
        if (provider == CustomUtils.DESCRIPTION_PROVIDER) {
            try {
                EmptyProgressIndicator pi = new EmptyProgressIndicator();
                pi.start();
                FrameworkConfigurationDescription framework = provider.getFrameworkData(path, project, (ProgressIndicator)pi);
                this.myFrameworksToOpenInEditor.add(framework);
                return framework;
            }
            catch (RunCanceledByUserException e) {
                return null;
            }
            catch (FrameworkDescriptionProvider.FrameworkExecutionException e) {
                LOG.error("CustomUtils.DESCRIPTION_PROVIDER mustn't throw ExecutionException in getFrameworkData(CustomFrameworkData path).");
                return null;
            }
            catch (FrameworkDescriptionProvider.FrameworkParseException e) {
                LOG.error("CustomUtils.DESCRIPTION_PROVIDER mustn't throw FrameworkDescriptionProvider.FrameworkParseException in getFrameworkData(CustomFrameworkData path).");
                return null;
            }
        }
        return this.loadCommands(provider, project, path);
    }

    @Nullable
    private <UserData> FrameworkConfigurationDescription loadCommands(FrameworkDescriptionProvider<UserData> provider, final @Nullable Project project, @Nullable UserData path) {
        CommandsLoader<UserData> loader = new CommandsLoader<UserData>(provider, path, project);
        boolean success = ProgressManager.getInstance().runProcessWithProgressSynchronously(loader, FrameworkBundle.message("framework.settings.loading.framework.commands", provider.getFrameworkName()), true, null);
        if (!success) {
            return null;
        }
        if (loader.myErrorMessage != null) {
            Messages.showErrorDialog((Project)project, (String)FrameworkBundle.message("framework.settings.failed.to.load.commands", loader.myErrorMessage), (String)FrameworkBundle.message("framework.commands.form.messages.title.command.line.tools", new Object[0]));
            return null;
        }
        if (loader.myParseException != null) {
            final class ParseExceptionDialogWrapper
            extends DialogWrapper {
                private JPanel myMainPanel;

                private ParseExceptionDialogWrapper(FrameworkDescriptionProvider.FrameworkParseException exception) {
                    super(true);
                    this.initialize(exception);
                }

                private ParseExceptionDialogWrapper(@NotNull FrameworkDescriptionProvider.FrameworkParseException exception, Project componentForConstruction) {
                    if (componentForConstruction == null) {
                        ParseExceptionDialogWrapper.$$$reportNull$$$0(0);
                    }
                    super(componentForConstruction, true);
                    this.initialize(exception);
                }

                private void initialize(final FrameworkDescriptionProvider.FrameworkParseException exception) {
                    this.setTitle(FrameworkBundle.message("framework.commands.form.error.message.title.add.framework", new Object[0]));
                    this.myMainPanel = new JPanel();
                    this.myMainPanel.add(new JLabel(FrameworkBundle.message("framework.commands.form.failed.to.parse.command.output", new Object[0])));
                    HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(FrameworkBundle.message("framework.commands.form.details", new Object[0]));
                    this.myMainPanel.add((Component)hyperlinkLabel);
                    hyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

                        @Override
                        public void hyperlinkUpdate(HyperlinkEvent e) {
                            FailedToParseDialog failedToParseDialog = new FailedToParseDialog(exception, project);
                            failedToParseDialog.show();
                        }
                    });
                    this.init();
                }

                protected JComponent createCenterPanel() {
                    return this.myMainPanel;
                }

                protected Action @NotNull [] createActions() {
                    Action[] actionArray = new Action[]{this.getOKAction()};
                    if (actionArray == null) {
                        ParseExceptionDialogWrapper.$$$reportNull$$$0(1);
                    }
                    return actionArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "componentForConstruction";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$1ParseExceptionDialogWrapper";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$1ParseExceptionDialogWrapper";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createActions";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "<init>";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            }
            ParseExceptionDialogWrapper dialogWrapper = project == null ? new ParseExceptionDialogWrapper(loader.myParseException) : new ParseExceptionDialogWrapper(loader.myParseException, project);
            dialogWrapper.show();
            return null;
        }
        FrameworkConfigurationDescription framework = loader.myFramework;
        if (framework != null) {
            int size = framework.getCommands().size();
            String message = FrameworkBundle.message("framework.settings.found.0.1.commands", size, size == 1 ? 0 : 1);
            FrameworkCommandsForm.showMessageBalloon(message, this.getContentPane());
        }
        return framework;
    }

    @Nullable
    private static String validateFrameworkDescription(FrameworkConfigurationDescription frameworkDescription) {
        if (StringUtil.isEmpty((String)frameworkDescription.getAlias())) {
            return FrameworkBundle.message("framework.settings.alias.should.be.provided", new Object[0]);
        }
        if (StringUtil.isEmpty((String)frameworkDescription.getInvokeText())) {
            return FrameworkBundle.message("framework.settings.tool.path.should.be.provided", new Object[0]);
        }
        return null;
    }

    public JComponent getContentPane() {
        return this.myMainPanel;
    }

    public boolean isModified(FrameworkDataService config) {
        return FrameworkCommandsForm.isModified(this.myTableEditor.getItems(), config.cloneData());
    }

    public static boolean isModified(List<? extends FrameworkDataService.FrameworkFileData> items, List<? extends FrameworkDataService.FrameworkFileData> oldItems) {
        if (items.size() != oldItems.size()) {
            return true;
        }
        int currentInvalidItemsSize = 0;
        for (FrameworkDataService.FrameworkFileData frameworkFileData : items) {
            if (frameworkFileData.getFramework() != null) continue;
            ++currentInvalidItemsSize;
        }
        int oldInvalidItemsSize = 0;
        for (FrameworkDataService.FrameworkFileData frameworkFileData : oldItems) {
            if (frameworkFileData.getFramework() != null) continue;
            ++oldInvalidItemsSize;
        }
        if (currentInvalidItemsSize != oldInvalidItemsSize) {
            return true;
        }
        for (FrameworkDataService.FrameworkFileData frameworkFileData : items) {
            if (frameworkFileData.getFramework() == null) continue;
            boolean found = false;
            for (FrameworkDataService.FrameworkFileData frameworkFileData2 : oldItems) {
                if (frameworkFileData2.getFramework() == null || !frameworkFileData.getFramework().getName().equals(frameworkFileData2.getFramework().getName())) continue;
                found = true;
                if (frameworkFileData.getFramework().equals(frameworkFileData2.getFramework()) && frameworkFileData.isProjectVisibility() == frameworkFileData2.isProjectVisibility()) continue;
                return true;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    public void apply(FrameworkDataService config) {
        List items = this.myTableEditor.getItems();
        for (FrameworkDataService.FrameworkFileData item : items) {
            if (item.getFramework() == null || FrameworkCommandsForm.validateFrameworkDescription(item.getFramework()) == null) continue;
            item.getFramework().setEnabled(false);
        }
        config.loadChanged(items);
        this.updateFrameworksToOpen(items);
        if (this.myFrameworksToOpenInEditor.isEmpty()) {
            return;
        }
        FrameworkDataService service = FrameworkDataService.getInstance(this.myProject);
        ArrayList<VirtualFile> fileToOpen = new ArrayList<VirtualFile>(this.myFrameworksToOpenInEditor.size());
        for (FrameworkConfigurationDescription frameworkConfigurationDescription : this.myFrameworksToOpenInEditor) {
            FrameworkDataService.FrameworkFileData currentData = null;
            for (FrameworkDataService.FrameworkFileData item : items) {
                if (!frameworkConfigurationDescription.equals(item.getFramework())) continue;
                currentData = item;
                break;
            }
            if (currentData == null) continue;
            VirtualFile description = service.getFile(currentData);
            if (description == null) {
                LOG.error("Failed to write created framework tools configuration for " + frameworkConfigurationDescription.getName());
                continue;
            }
            fileToOpen.add(description);
        }
        Project project = FrameworkUtils.getProject(this.getContentPane());
        if (project != null) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            for (VirtualFile virtualFile : fileToOpen) {
                fileEditorManager.openFile(virtualFile, false);
            }
        }
        this.myFrameworksToOpenInEditor.clear();
    }

    private void updateFrameworksToOpen(List<FrameworkDataService.FrameworkFileData> items) {
        Iterator<FrameworkConfigurationDescription> iterator = this.myFrameworksToOpenInEditor.iterator();
        while (iterator.hasNext()) {
            boolean found = false;
            String name = iterator.next().getName();
            for (FrameworkDataService.FrameworkFileData item : items) {
                if (item.getFramework() == null || !name.equals(item.getFramework().getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            iterator.remove();
        }
    }

    public void reset(FrameworkDataService config) {
        List<FrameworkDataService.FrameworkFileData> data = config.cloneData();
        this.myTableEditor.setModel(this.getColumnInfos(), data);
        this.myFrameworksToOpenInEditor.clear();
    }

    private static boolean isEnabled(FrameworkDataService.FrameworkFileData data) {
        return data.getFramework() != null && data.getFramework().isEnabled();
    }

    private static TableCellRenderer getRendererForString(FrameworkDataService.FrameworkFileData data) {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setEnabled(FrameworkCommandsForm.isEnabled(data));
        return renderer;
    }

    private static void showMessageBalloon(@Nls String message, JComponent component) {
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.INFO, null).setShowCallout(false).setFadeoutTime(3000L).setHideOnAction(true).setHideOnClickOutside(true).setHideOnFrameResize(true).setHideOnKeyOutside(true).setBlockClicksThroughBalloon(false).createBalloon().showInCenterOf(component);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTableEditorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFrameworkTypeColumnCheckbox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkCommandsForm.class).getString("framework.show.framework.type"));
        jPanel.add((Component)jBCheckBox, "South");
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private final class FrameworkValidatingTableEditor
    extends ValidatingTableEditor<FrameworkDataService.FrameworkFileData> {
        private final Project myProject;

        private FrameworkValidatingTableEditor(Project project, AnAction ... buttons) {
            if (project == null) {
                FrameworkValidatingTableEditor.$$$reportNull$$$0(0);
            }
            super(buttons);
            this.myProject = project;
            this.setShowGrid(false);
        }

        protected FrameworkDataService.FrameworkFileData cloneOf(FrameworkDataService.FrameworkFileData frameworkDescription) {
            return new FrameworkDataService.FrameworkFileData(frameworkDescription.getFramework().cloneFramework(), frameworkDescription.getErrorMessage(), frameworkDescription.getFileName(), frameworkDescription.isProjectVisibility());
        }

        @Nullable
        protected FrameworkDataService.FrameworkFileData createItem() {
            Pair<FrameworkConfigurationDescription, Boolean> pair = this.createNewFramework(this.myProject);
            if (pair != null) {
                Object name;
                HashSet<String> names = new HashSet<String>();
                for (FrameworkDataService.FrameworkFileData data : this.getItems()) {
                    names.add(FrameworkDataService.getFrameworkNameFromFileName(data.getFileName()));
                }
                Object basicName = ((FrameworkConfigurationDescription)pair.getFirst()).getFramework().getName();
                if (StringUtil.isEmpty((String)basicName)) {
                    basicName = FrameworkBundle.message("framework.custom.part.of.filename", new Object[0]);
                }
                if (names.contains(basicName = (String)basicName + "_" + ((FrameworkConfigurationDescription)pair.getFirst()).getAlias())) {
                    basicName = (String)basicName + "_";
                    int i = 1;
                    while (names.contains((String)basicName + i)) {
                        ++i;
                    }
                    name = (String)basicName + i;
                } else {
                    name = basicName;
                }
                ((FrameworkConfigurationDescription)pair.getFirst()).setName((String)name);
                return new FrameworkDataService.FrameworkFileData((FrameworkConfigurationDescription)pair.getFirst(), null, FrameworkDataService.getFileName((String)name), (Boolean)pair.getSecond());
            }
            return null;
        }

        @Nullable
        private Pair<FrameworkConfigurationDescription, Boolean> createNewFramework(@NotNull Project project) {
            if (project == null) {
                FrameworkValidatingTableEditor.$$$reportNull$$$0(1);
            }
            ArrayList<FrameworkDescriptionProvider<CustomUtils.CustomFrameworkData>> providersToAdd = new ArrayList<FrameworkDescriptionProvider<CustomUtils.CustomFrameworkData>>(((FrameworkDescriptionProvider[])FrameworkDescriptionProvider.EP.getExtensions()).length);
            Collections.addAll(providersToAdd, (FrameworkDescriptionProvider[])FrameworkDescriptionProvider.EP.getExtensions());
            providersToAdd.sort(Comparator.comparing(FrameworkDescriptionProvider::getFrameworkName));
            providersToAdd.add(CustomUtils.DESCRIPTION_PROVIDER);
            if (providersToAdd.size() == 1) {
                FrameworkDescriptionProvider provider = (FrameworkDescriptionProvider)providersToAdd.get(0);
                int load = Messages.showCheckboxMessageDialog((String)FrameworkBundle.message("framework.settings.add.0", StringUtil.decapitalize((String)provider.getFrameworkName())), (String)FrameworkBundle.message("framework.commands.form.messages.title.command.line.tools", new Object[0]), (String[])new String[]{CommonBundle.getOkButtonText()}, (String)FrameworkBundle.message("framework.commands.form.make.tool.globally.visible", new Object[0]), (boolean)false, (int)-1, (int)-1, (Icon)Messages.getQuestionIcon(), (t, v) -> {
                    if (t == 0) {
                        if (v.isSelected()) {
                            return CREATE_WITH_GLOBAL_VISIBILITY;
                        }
                        return CREATE_WITH_PROJECT_VISIBILITY;
                    }
                    return DO_NOT_CREATE;
                });
                if (load == DO_NOT_CREATE) {
                    return null;
                }
                FrameworkConfigurationDescription framework = FrameworkCommandsForm.this.loadCommands(provider, project);
                return framework == null ? null : Pair.create((Object)framework, (Object)(load == CREATE_WITH_PROJECT_VISIBILITY ? 1 : 0));
            }
            FrameworkChooseProviderDialog chooseProviderDialog = new FrameworkChooseProviderDialog(project, providersToAdd);
            boolean ok = chooseProviderDialog.showAndGet();
            if (ok) {
                FrameworkDescriptionProvider provider = chooseProviderDialog.getSelectedProvider();
                assert (provider != null);
                FrameworkConfigurationDescription framework = FrameworkCommandsForm.this.loadCommands(provider, project);
                return framework == null ? null : Pair.create((Object)framework, (Object)chooseProviderDialog.isProjectVisibility());
            }
            return null;
        }

        protected String validate(FrameworkDataService.FrameworkFileData frameworkDescription) {
            if (frameworkDescription.getFramework() != null) {
                return FrameworkCommandsForm.validateFrameworkDescription(frameworkDescription.getFramework());
            }
            return FrameworkBundle.message("framework.commands.form.invalid.description", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$FrameworkValidatingTableEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createNewFramework";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class EditActionButton
    extends DumbAwareAction {
        private EditActionButton() {
            super(FrameworkBundle.messagePointer("framework.edit", new Object[0]), EDIT_ACTION_ICON);
        }

        public void update(@NotNull AnActionEvent e) {
            boolean enabled;
            if (e == null) {
                EditActionButton.$$$reportNull$$$0(0);
            }
            if (enabled = e.getPresentation().isEnabled()) {
                List selectedItems = FrameworkCommandsForm.this.myTableEditor.getSelectedItems();
                boolean bl = enabled = selectedItems != null && selectedItems.size() == 1;
                if (enabled) {
                    enabled = ((FrameworkDataService.FrameworkFileData)selectedItems.get(0)).getFramework() != null;
                }
            }
            e.getPresentation().setEnabled(enabled);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                EditActionButton.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List selectedItems;
            if (e == null) {
                EditActionButton.$$$reportNull$$$0(2);
            }
            if ((selectedItems = FrameworkCommandsForm.this.myTableEditor.getSelectedItems()) == null || selectedItems.isEmpty()) {
                FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("framework.commands.form.no.frameworks.selected", new Object[0]), FrameworkCommandsForm.this.myTableEditorPanel);
                return;
            }
            if (selectedItems.size() > 1) {
                FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("framework.too.many.tools.selected", new Object[0]), FrameworkCommandsForm.this.myTableEditorPanel);
                return;
            }
            FrameworkDataService.FrameworkFileData data = (FrameworkDataService.FrameworkFileData)selectedItems.get(0);
            if (data == null) {
                FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("framework.tool.description.file.is.invalid", new Object[0]), FrameworkCommandsForm.this.myTableEditorPanel);
                return;
            }
            new FrameworkEditDialog(FrameworkCommandsForm.this.getContentPane(), data).showAndGet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$EditActionButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$EditActionButton";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private final class ReloadCommandsActionButton
    extends DumbAwareAction {
        private ReloadCommandsActionButton() {
            super(FrameworkBundle.messagePointer("reload.command.list.from.executable", new Object[0]), AllIcons.Actions.Refresh);
        }

        public void update(@NotNull AnActionEvent e) {
            boolean enabled;
            if (e == null) {
                ReloadCommandsActionButton.$$$reportNull$$$0(0);
            }
            if (enabled = e.getPresentation().isEnabled()) {
                List selectedItems = FrameworkCommandsForm.this.myTableEditor.getSelectedItems();
                if (selectedItems == null || selectedItems.isEmpty()) {
                    enabled = false;
                } else {
                    for (FrameworkDataService.FrameworkFileData item : selectedItems) {
                        if (item.getFramework() != null && FrameworkUtils.getMatchingProvider(item.getFramework()) != null) continue;
                        enabled = false;
                        break;
                    }
                }
            }
            e.getPresentation().setEnabled(enabled);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ReloadCommandsActionButton.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ReloadCommandsActionButton.$$$reportNull$$$0(2);
            }
            if ((project = e.getProject()) != null && !TrustedProjects.isTrusted((Project)project)) {
                FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("untrusted.project.refresh.forbidden", new Object[0]), FrameworkCommandsForm.this.myTableEditorPanel);
                return;
            }
            List selectedItems = FrameworkCommandsForm.this.myTableEditor.getSelectedItems();
            if (selectedItems == null || selectedItems.isEmpty()) {
                FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("framework.commands.form.no.frameworks.selected", new Object[0]), FrameworkCommandsForm.this.myTableEditorPanel);
                return;
            }
            HashMap<FrameworkDataService.FrameworkFileData, FrameworkDescriptionProvider> filesAndProviders = new HashMap<FrameworkDataService.FrameworkFileData, FrameworkDescriptionProvider>();
            for (FrameworkDataService.FrameworkFileData fileData : selectedItems) {
                FrameworkConfigurationDescription description = fileData.getFramework();
                if (description == null) {
                    FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("there.are.invalid.frameworks.among.selected", new Object[0]), FrameworkCommandsForm.this.myTableEditorPanel);
                    return;
                }
                FrameworkDescriptionProvider provider = FrameworkUtils.getMatchingProvider(description);
                if (provider == null) {
                    FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("framework.with.alias.0.can.t.be.reloaded", description.getAlias()), FrameworkCommandsForm.this.myTableEditorPanel);
                    return;
                }
                filesAndProviders.put(fileData, provider);
            }
            List oldItems = FrameworkCommandsForm.this.myTableEditor.getItems();
            ArrayList<FrameworkDataService.FrameworkFileData> freshItems = new ArrayList<FrameworkDataService.FrameworkFileData>(oldItems.size());
            for (FrameworkDataService.FrameworkFileData data : oldItems) {
                FrameworkDescriptionProvider provider = (FrameworkDescriptionProvider)filesAndProviders.get(data);
                if (provider == null) {
                    freshItems.add(data);
                    continue;
                }
                this.recreateFileData(freshItems, data, provider);
            }
            FrameworkCommandsForm.this.myTableEditor.setModel(FrameworkCommandsForm.this.getColumnInfos(), freshItems);
        }

        private <UserData> void recreateFileData(List<FrameworkDataService.FrameworkFileData> freshItems, FrameworkDataService.FrameworkFileData data, FrameworkDescriptionProvider<UserData> provider) {
            FrameworkConfigurationDescription oldDescription = data.getFramework();
            UserData path = provider.parseUserData(oldDescription);
            FrameworkConfigurationDescription freshDescription = FrameworkCommandsForm.this.loadCommands(provider, FrameworkCommandsForm.this.myProject, path);
            if (freshDescription == null) {
                freshItems.add(data);
            } else {
                freshDescription.setName(oldDescription.getName());
                freshDescription.setAlias(oldDescription.getAlias());
                freshDescription.setEnabled(oldDescription.isEnabled());
                freshItems.add(new FrameworkDataService.FrameworkFileData(freshDescription, null, FrameworkDataService.getFileName(freshDescription.getName()), data.isProjectVisibility()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$ReloadCommandsActionButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$ReloadCommandsActionButton";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private final class ShowInEditorActionButton
    extends DumbAwareAction {
        private ShowInEditorActionButton() {
            super(FrameworkBundle.messagePointer("framework.commands.form.show.in.editor", new Object[0]), SHOW_IN_EDITOR_ICON);
        }

        public void update(@NotNull AnActionEvent e) {
            boolean enabled;
            if (e == null) {
                ShowInEditorActionButton.$$$reportNull$$$0(0);
            }
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            boolean bl = enabled = e.getPresentation().isEnabled() && project != null && !project.isDefault();
            if (enabled) {
                List selectedItems = FrameworkCommandsForm.this.myTableEditor.getSelectedItems();
                enabled = selectedItems != null && !selectedItems.isEmpty();
            }
            e.getPresentation().setEnabled(enabled);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowInEditorActionButton.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ShowInEditorActionButton.$$$reportNull$$$0(2);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null || project.isDefault()) {
                return;
            }
            List selectedItems = FrameworkCommandsForm.this.myTableEditor.getSelectedItems();
            if (selectedItems == null || selectedItems.isEmpty()) {
                FrameworkCommandsForm.showMessageBalloon(FrameworkBundle.message("framework.commands.form.no.frameworks.selected", new Object[0]), FrameworkCommandsForm.this.myTableEditorPanel);
                return;
            }
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            ArrayList<String> unopenedFiles = new ArrayList<String>();
            StringBuilder openedMessage = new StringBuilder();
            boolean first = true;
            FrameworkDataService service = FrameworkDataService.getInstance(FrameworkCommandsForm.this.myProject);
            for (FrameworkDataService.FrameworkFileData selectedItem : selectedItems) {
                VirtualFile fileToOpen = service.getFile(selectedItem);
                if (fileToOpen == null) {
                    unopenedFiles.add(selectedItem.getFileName());
                    continue;
                }
                if (first) {
                    openedMessage.append(FrameworkBundle.message("framework.opened", new Object[0]));
                } else {
                    openedMessage.append(",");
                }
                if (selectedItem.getFramework() != null) {
                    openedMessage.append(" ").append(selectedItem.getFramework().getName());
                }
                fileEditorManager.openFile(fileToOpen, false);
                first = false;
            }
            if (!unopenedFiles.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                boolean isFirst = true;
                for (String unopenedFile : unopenedFiles) {
                    if (!isFirst) {
                        sb.append(", ");
                    }
                    isFirst = false;
                    sb.append(unopenedFile);
                }
                openedMessage.append("\n").append(FrameworkBundle.message("framework.commands.form.0.not.created.yet.", sb.append(" ").toString()));
            }
            if (openedMessage.length() != 0) {
                @NlsSafe String message = openedMessage.toString();
                FrameworkCommandsForm.showMessageBalloon(message, FrameworkCommandsForm.this.myTableEditorPanel);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$ShowInEditorActionButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkCommandsForm$ShowInEditorActionButton";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class EnabledColumnInfo
    extends ColumnInfo<FrameworkDataService.FrameworkFileData, Boolean> {
        private final int PREFERRED_WIDTH;

        private EnabledColumnInfo() {
            super(FrameworkBundle.message("framework.settings.table.enabled.header", new Object[0]));
            JLabel label = new JLabel(FrameworkBundle.message("framework.settings.table.enabled.header", new Object[0]));
            this.PREFERRED_WIDTH = label.getPreferredSize().width + 20;
        }

        public Boolean valueOf(FrameworkDataService.FrameworkFileData frameworkDescription) {
            return FrameworkCommandsForm.isEnabled(frameworkDescription);
        }

        public boolean isCellEditable(FrameworkDataService.FrameworkFileData frameworkDescription) {
            return frameworkDescription.getFramework() != null;
        }

        public void setValue(FrameworkDataService.FrameworkFileData frameworkDescription, Boolean value) {
            frameworkDescription.getFramework().setEnabled(value);
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        public int getWidth(JTable table) {
            return this.PREFERRED_WIDTH;
        }
    }

    private static final class AliasColumnInfo
    extends ColumnInfo<FrameworkDataService.FrameworkFileData, String>
    implements ValidatingTableEditor.RowHeightProvider {
        private final int PREFERRED_HEIGHT;

        private AliasColumnInfo() {
            super(FrameworkBundle.message("framework.settings.table.alias.header", new Object[0]));
            JTextField field = new JTextField("text");
            this.PREFERRED_HEIGHT = field.getPreferredSize().height;
        }

        public String valueOf(FrameworkDataService.FrameworkFileData frameworkDescription) {
            if (frameworkDescription.getFramework() == null) {
                return "";
            }
            return frameworkDescription.getFramework().getAlias();
        }

        public int getRowHeight() {
            return this.PREFERRED_HEIGHT;
        }

        @Nullable
        public TableCellRenderer getRenderer(FrameworkDataService.FrameworkFileData data) {
            return FrameworkCommandsForm.getRendererForString(data);
        }
    }

    private final class InterpreterColumnInfo
    extends ColumnInfo<FrameworkDataService.FrameworkFileData, String> {
        private InterpreterColumnInfo() {
            super(FrameworkBundle.message("framework.settings.table.interpreter.header", new Object[0]));
        }

        public String valueOf(FrameworkDataService.FrameworkFileData frameworkDescription) {
            FrameworkConfigurationDescription description = frameworkDescription.getFramework();
            if (description == null) {
                return frameworkDescription.getErrorMessage();
            }
            String commandToExecute = description.getInvokeText();
            if (StringUtil.isEmpty((String)commandToExecute) || "EXECUTABLE".equals(StringUtil.split((String)commandToExecute, (String)" ").get(0))) {
                return "";
            }
            if ("PROJECT_DEFAULT_INTERPRETER".equals(StringUtil.split((String)commandToExecute, (String)" ").get(0))) {
                return FrameworkBundle.message("framework.settings.table.interpreter.default", new Object[0]);
            }
            String interpreterName = StringUtil.trim((String)((String)StringUtil.split((String)commandToExecute, (String)(commandToExecute.contains("\"") ? "\"" : " ")).get(0)));
            PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance((Project)FrameworkCommandsForm.this.myProject).findInterpreterById(interpreterName);
            if (interpreter != null) {
                return interpreter.getName();
            }
            try {
                UUID.fromString(interpreterName);
                return FrameworkBundle.message("framework.settings.table.interpreter.unknown", new Object[0]);
            }
            catch (IllegalArgumentException iae) {
                List split = StringUtil.split((String)commandToExecute, (String)(!commandToExecute.contains("\"") ? " " : "\""));
                return split.size() > 1 ? (String)split.get(0) : "";
            }
        }

        public TableCellRenderer getRenderer(final FrameworkDataService.FrameworkFileData frameworkFileData) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    String cellValue = (String)value;
                    if (frameworkFileData.getFramework() != null) {
                        this.setText(cellValue);
                    } else {
                        JPanel result = new JPanel(new FlowLayout());
                        JLabel mainLabel = new JLabel(FrameworkBundle.message("framework.commands.form.invalid.description", new Object[0]));
                        HyperlinkLabel linkLabel = new HyperlinkLabel(FrameworkBundle.message("framework.commands.form.more", new Object[0]));
                        result.add(mainLabel);
                        result.add((Component)linkLabel);
                        this.add(result);
                    }
                    this.setEnabled(FrameworkCommandsForm.isEnabled(frameworkFileData));
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            };
        }
    }

    private final class InvocationColumnInfo
    extends ColumnInfo<FrameworkDataService.FrameworkFileData, String> {
        private InvocationColumnInfo() {
            super(FrameworkBundle.message("framework.settings.table.tool.path.header", new Object[0]));
        }

        public String valueOf(FrameworkDataService.FrameworkFileData frameworkDescription) {
            FrameworkConfigurationDescription description = frameworkDescription.getFramework();
            if (description == null) {
                return frameworkDescription.getErrorMessage();
            }
            String commandToExecute = description.getInvokeText();
            if (StringUtil.isEmpty((String)commandToExecute)) {
                return commandToExecute;
            }
            if ("EXECUTABLE".equals(StringUtil.split((String)commandToExecute, (String)" ").get(0))) {
                return StringUtil.substringAfter((String)commandToExecute, (String)"EXECUTABLE ");
            }
            String interpreterName = (String)StringUtil.split((String)commandToExecute, (String)(commandToExecute.contains("\"") ? "\"" : " ")).get(0);
            if ("PROJECT_DEFAULT_INTERPRETER".equals(interpreterName)) {
                return FrameworkRunAnythingProvider.getOptionString(commandToExecute, interpreterName);
            }
            PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance((Project)FrameworkCommandsForm.this.myProject).findInterpreterById(interpreterName);
            if (interpreter != null) {
                return FrameworkRunAnythingProvider.getOptionString(commandToExecute, interpreterName);
            }
            try {
                UUID.fromString(interpreterName);
                return FrameworkRunAnythingProvider.getOptionString(commandToExecute, interpreterName);
            }
            catch (IllegalArgumentException iae) {
                ArrayList split = new ArrayList(StringUtil.split((String)commandToExecute, (String)(!commandToExecute.contains("\"") ? " " : "\"")));
                split.remove(" ");
                return split.size() > 1 ? (String)split.get(1) : (String)split.get(0);
            }
        }

        public TableCellRenderer getRenderer(final FrameworkDataService.FrameworkFileData frameworkFileData) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    String cellValue = (String)value;
                    if (frameworkFileData.getFramework() != null) {
                        this.setText(cellValue);
                    } else {
                        JPanel result = new JPanel(new FlowLayout());
                        JLabel mainLabel = new JLabel(FrameworkBundle.message("framework.commands.form.invalid.description", new Object[0]));
                        HyperlinkLabel linkLabel = new HyperlinkLabel(FrameworkBundle.message("framework.commands.form.more", new Object[0]));
                        result.add(mainLabel);
                        result.add((Component)linkLabel);
                        this.add(result);
                    }
                    this.setEnabled(FrameworkCommandsForm.isEnabled(frameworkFileData));
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            };
        }
    }

    private static final class PredefinedFrameworkColumnInfo
    extends ColumnInfo<FrameworkDataService.FrameworkFileData, String> {
        private PredefinedFrameworkColumnInfo() {
            super(FrameworkBundle.message("predefined.framework", new Object[0]));
        }

        public String valueOf(FrameworkDataService.FrameworkFileData frameworkDescription) {
            if (frameworkDescription.getFramework() == null) {
                return "";
            }
            FrameworkDescriptionProvider provider = FrameworkUtils.getMatchingProvider(frameworkDescription.getFramework());
            return provider == null ? "" : provider.getFrameworkName();
        }

        @Nullable
        public TableCellRenderer getRenderer(FrameworkDataService.FrameworkFileData data) {
            return FrameworkCommandsForm.getRendererForString(data);
        }
    }

    private static final class CommandsLoader<UserData>
    implements Runnable {
        private final FrameworkDescriptionProvider<UserData> myProvider;
        private final UserData myPath;
        private final Project myProject;
        private FrameworkConfigurationDescription myFramework;
        private String myErrorMessage;
        private FrameworkDescriptionProvider.FrameworkParseException myParseException;

        private CommandsLoader(FrameworkDescriptionProvider<UserData> provider, @Nullable UserData path, @Nullable Project project) {
            this.myProvider = provider;
            this.myPath = path;
            this.myProject = project;
        }

        @Override
        public void run() {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            progressIndicator.setIndeterminate(true);
            try {
                this.myFramework = this.myProvider.getFrameworkData(this.myPath, this.myProject, progressIndicator);
            }
            catch (RunCanceledByUserException runCanceledByUserException) {
            }
            catch (FrameworkDescriptionProvider.FrameworkExecutionException e) {
                this.myErrorMessage = e.getExecutionException().getMessage();
            }
            catch (FrameworkDescriptionProvider.FrameworkParseException e) {
                this.myParseException = e;
            }
        }
    }
}

