/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.bridge.theme;

import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.foundation.shape.CornerSize;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpKt;
import androidx.compose.ui.unit.DpSize;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.bridge.BridgeUtilsKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeKt;
import org.jetbrains.jewel.ui.component.styling.ComboBoxColors;
import org.jetbrains.jewel.ui.component.styling.ComboBoxIcons;
import org.jetbrains.jewel.ui.component.styling.ComboBoxMetrics;
import org.jetbrains.jewel.ui.component.styling.ComboBoxStyle;
import org.jetbrains.jewel.ui.icon.IconKey;
import org.jetbrains.jewel.ui.icon.IntelliJIconKey;
import org.jetbrains.jewel.ui.icons.AllIconsKeys;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u00a8\u0006\u0002"}, d2={"readDefaultComboBoxStyle", "Lorg/jetbrains/jewel/ui/component/styling/ComboBoxStyle;", "intellij.platform.jewel.ideLafBridge"})
@SourceDebugExtension(value={"SMAP\nIntUiBridgeComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntUiBridgeComboBox.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeComboBoxKt\n+ 2 Dp.kt\nandroidx/compose/ui/unit/Dp\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,63:1\n51#2:64\n149#3:65\n*S KotlinDebug\n*F\n+ 1 IntUiBridgeComboBox.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeComboBoxKt\n*L\n53#1:64\n56#1:65\n*E\n"})
public final class IntUiBridgeComboBoxKt {
    @NotNull
    public static final ComboBoxStyle readDefaultComboBoxStyle() {
        long normalBackground = BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.background");
        long nonEditableBackground = BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.nonEditableBackground");
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.foreground");
        long normalBorder = BridgeUtilsKt.retrieveColorOrUnspecified("Component.borderColor");
        long focusedBorder = BridgeUtilsKt.retrieveColorOrUnspecified("Component.focusedBorderColor");
        ComboBoxColors colors = new ComboBoxColors(normalBackground, nonEditableBackground, BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.disabledBackground"), normalBackground, normalBackground, normalBackground, normalContent, BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.disabledForeground"), normalContent, normalContent, normalContent, normalBorder, BridgeUtilsKt.retrieveColorOrUnspecified("Component.disabledBorderColor"), focusedBorder, focusedBorder, normalBorder, null);
        Dimension dimension = JBUI.CurrentTheme.ComboBox.minimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"minimumSize(...)");
        long minimumSize = BridgeUtilsKt.toDpSize(dimension);
        JBValue jBValue = JBUI.CurrentTheme.Component.ARROW_AREA_WIDTH;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"ARROW_AREA_WIDTH");
        float arrowWidth = BridgeUtilsKt.getDp(jBValue);
        long l = DpKt.DpSize-YgX7TsA((float)arrowWidth, (float)DpSize.getHeight-D9Ej5fM((long)minimumSize));
        float arg0$iv = DpSize.getWidth-D9Ej5fM((long)minimumSize);
        boolean bl = false;
        long l2 = DpKt.DpSize-YgX7TsA((float)Dp.constructor-impl((float)(arg0$iv + arrowWidth)), (float)DpSize.getHeight-D9Ej5fM((long)minimumSize));
        CornerSize cornerSize = IntUiBridgeKt.getComponentArc();
        PaddingValues paddingValues = BridgeUtilsKt.retrieveInsetsAsPaddingValues$default("ComboBox.padding", null, 2, null);
        int $this$dp$iv = 6;
        boolean $i$f$getDp = false;
        PaddingValues paddingValues2 = PaddingKt.PaddingValues-YgX7TsA$default((float)0.0f, (float)Dp.constructor-impl((float)$this$dp$iv), (int)1, null);
        JBValue jBValue2 = DarculaUIUtil.LW;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue2, (String)"LW");
        ComboBoxMetrics comboBoxMetrics = new ComboBoxMetrics(l, l2, cornerSize, paddingValues, paddingValues2, BridgeUtilsKt.getDp(jBValue2), Dp.Companion.getUnspecified-D9Ej5fM(), null);
        IntelliJIconKey intelliJIconKey = AllIconsKeys.General.ChevronDown;
        Intrinsics.checkNotNullExpressionValue((Object)intelliJIconKey, (String)"ChevronDown");
        return new ComboBoxStyle(colors, comboBoxMetrics, new ComboBoxIcons((IconKey)intelliJIconKey));
    }
}

