/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.mq.references;

import com.intellij.ide.presentation.Presentation;
import com.intellij.microservices.mq.MQDestination;
import com.intellij.microservices.mq.MQModelKt;
import com.intellij.microservices.mq.MQResolverManager;
import com.intellij.microservices.mq.MQTargetInfo;
import com.intellij.microservices.mq.MQType;
import com.intellij.microservices.mq.references.MQReferenceContext;
import com.intellij.microservices.mq.references.MQReferencePresentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomRenameableTarget;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=MQReferencePresentationProvider.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0001\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\rJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u000f\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0013\u0010\u001e\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/microservices/mq/references/MQReferenceUnifiedPomTarget;", "Lcom/intellij/pom/PomRenameableTarget;", "", "referenceContext", "Lcom/intellij/microservices/mq/references/MQReferenceContext;", "targetName", "", "project", "Lcom/intellij/openapi/project/Project;", "MQReferenceUnifiedPomTarget", "(Lcom/intellij/microservices/mq/references/MQReferenceContext;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "mqId", "Lcom/intellij/microservices/mq/MQDestination;", "(Lcom/intellij/microservices/mq/MQDestination;Lcom/intellij/openapi/project/Project;)V", "resolverManager", "Lcom/intellij/microservices/mq/MQResolverManager;", "allVariants", "Lkotlin/sequences/Sequence;", "Lcom/intellij/microservices/mq/MQTargetInfo;", "getAllVariants", "()Lkotlin/sequences/Sequence;", "setName", "newName", "getName", "getSingleMQType", "Lcom/intellij/microservices/mq/MQType;", "getSingleMQType$intellij_microservices", "isValid", "", "isWritable", "equals", "other", "hashCode", "", "toString", "intellij.microservices"})
public final class MQReferenceUnifiedPomTarget
implements PomRenameableTarget<Object> {
    @NotNull
    private final MQReferenceContext referenceContext;
    @NotNull
    private final String targetName;
    @NotNull
    private final MQResolverManager resolverManager;

    public MQReferenceUnifiedPomTarget(@NotNull MQReferenceContext referenceContext, @NotNull String targetName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)referenceContext, (String)"referenceContext");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.referenceContext = referenceContext;
        this.targetName = targetName;
        this.resolverManager = MQResolverManager.Companion.getInstance(project);
    }

    public MQReferenceUnifiedPomTarget(@NotNull MQDestination mqId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)mqId, (String)"mqId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(new MQReferenceContext(mqId.getType()), mqId.getName(), project);
    }

    @NotNull
    public final Sequence<MQTargetInfo> getAllVariants() {
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.referenceContext.getTypes()), arg_0 -> MQReferenceUnifiedPomTarget.W(this, arg_0));
    }

    @Nullable
    public Object setName(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return null;
    }

    @NotNull
    public String getName() {
        return this.targetName;
    }

    @Nullable
    public final MQType getSingleMQType$intellij_microservices() {
        if (this.referenceContext.getTypes().size() != 1) {
            return null;
        }
        return (MQType)CollectionsKt.firstOrNull(this.referenceContext.getTypes());
    }

    public boolean isValid() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.microservices.mq.references.MQReferenceUnifiedPomTarget");
        MQReferenceUnifiedPomTarget cfr_ignored_0 = (MQReferenceUnifiedPomTarget)other;
        if (!Intrinsics.areEqual((Object)this.targetName, (Object)((MQReferenceUnifiedPomTarget)other).targetName)) {
            return false;
        }
        List<MQType> list = this.referenceContext.getTypes();
        List<MQType> list2 = ((MQReferenceUnifiedPomTarget)other).referenceContext.getTypes();
        if (list.isEmpty() || list2.isEmpty()) {
            return true;
        }
        for (MQType mQType : list) {
            for (MQType mQType2 : list2) {
                if (!MQModelKt.areMQTypesCompatible(mQType, mQType2)) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.targetName.hashCode();
    }

    @NotNull
    public String toString() {
        return "MQReferenceUnifiedPomTarget('" + this.referenceContext.getTypes() + "')";
    }

    private static final Sequence W(MQReferenceUnifiedPomTarget mQReferenceUnifiedPomTarget, MQType mQType) {
        Intrinsics.checkNotNullParameter((Object)mQType, (String)"type");
        return mQReferenceUnifiedPomTarget.resolverManager.getVariants(mQType);
    }
}

