/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.rector;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.actions.ComposerRequirePackageAction;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.rector.RectorBundle;
import com.jetbrains.php.rector.run.RectorRunConfiguration;
import com.jetbrains.php.rector.run.RectorRunConfigurationOptions;
import com.jetbrains.php.run.PhpRunConfiguration;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class RectorExecutor {
    private static final String RECTOR_PACKAGE = "rector/rector";
    private static final String RECTOR_EXE = "rector";
    private final String myWorkingDir;

    public RectorExecutor(String workingDir) {
        this.myWorkingDir = workingDir;
    }

    public ProcessHandler createDryRunRectorHandler(Project project, RectorRunConfiguration configuration, RectorRunConfigurationOptions options) throws ExecutionException {
        String additionalArgs = options.getAdditionalOptions();
        String rectorConfig = options.getRectorConfigPath();
        PhpCommandSettings command = this.createCommandSettings(project, options);
        GeneralCommandLine commandLine = command.createGeneralCommandLine();
        PhpCommandLinePathProcessor pathProcessor = command.getPathProcessor();
        String pathToProcess = StringUtil.join((Collection)ContainerUtil.map(options.getPathsToProcess(), p -> pathProcessor.process(p)), (String)" ");
        if (StringUtil.isNotEmpty((String)pathToProcess)) {
            commandLine.withParameters(new String[]{"process", pathToProcess});
        }
        if (StringUtil.isNotEmpty((String)rectorConfig)) {
            commandLine.withParameters(new String[]{"--config", pathProcessor.process(rectorConfig)});
        }
        commandLine.withParameters(new String[]{"--output-format=json", "--dry-run"}).withCharset(EncodingManager.getInstance().getDefaultCharset());
        if (StringUtil.isNotEmpty((String)additionalArgs)) {
            commandLine.addParameters(additionalArgs.split(" "));
        }
        return configuration.createProcessHandler(project, command, false, commandLine);
    }

    public ProcessHandler createInitRectorHandler(Project project) throws ExecutionException {
        PhpCommandSettings command = this.createCommandSettings(project, null);
        GeneralCommandLine commandLine = command.createGeneralCommandLine();
        commandLine.withParameters(new String[]{"init"}).withCharset(EncodingManager.getInstance().getDefaultCharset());
        return PhpRunConfiguration.createProcessHandler((Project)project, (PhpCommandSettings)command, (boolean)false, (boolean)false, (GeneralCommandLine)commandLine);
    }

    @NotNull
    private PhpCommandSettings createCommandSettings(Project project, @Nullable RectorRunConfigurationOptions options) throws ExecutionException {
        String rectorConfig = null;
        if (options != null) {
            rectorConfig = options.getRectorConfigPath();
        }
        String rectorBin = RectorExecutor.getRectorExecutablePath(project, rectorConfig);
        PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance((Project)project).getInterpreter();
        if (interpreter == null) {
            throw new ExecutionException(PhpCommandSettingsBuilder.getInterpreterNotFoundError());
        }
        PhpCommandSettings command = new PhpCommandSettingsBuilder(project, interpreter).build();
        command.setScript(rectorBin, true);
        command.setWorkingDir(this.myWorkingDir);
        PhpCommandSettings phpCommandSettings = command;
        if (phpCommandSettings == null) {
            RectorExecutor.$$$reportNull$$$0(0);
        }
        return phpCommandSettings;
    }

    @VisibleForTesting
    @NotNull
    public static String getRectorExecutablePath(Project project, @Nullable String rectorConfigPath) throws ExecutionException {
        String path = RectorExecutor.findRectorExecutablePath(project, rectorConfigPath);
        if (!new File(path).exists()) {
            RectorExecutor.sendExecutableNotFoundNotification(project, path);
            throw new ExecutionException(RectorBundle.message("rector.executable.not.found", new Object[0]));
        }
        String string = path;
        if (string == null) {
            RectorExecutor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    public static String findRectorExecutablePath(Project project, @Nullable String rectorConfigPath) {
        String string = ComposerConfigUtils.findVendorExecutablePath((Project)project, (String)rectorConfigPath, (String)RECTOR_EXE);
        if (string == null) {
            RectorExecutor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void sendExecutableNotFoundNotification(@NotNull Project project, String path) {
        if (project == null) {
            RectorExecutor.$$$reportNull$$$0(3);
        }
        final Notification errorNotification = new Notification("RectorRunError", RectorBundle.message("notification.rector.run.error", new Object[0]), RectorBundle.message("rector.executable.not.found.message", path), NotificationType.ERROR);
        DumbAwareAction installAction = new DumbAwareAction(RectorBundle.message("rector.executable.not.found.install.quick.fix", path)){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ComposerRequirePackageAction requireAction = new ComposerRequirePackageAction(RectorExecutor.RECTOR_PACKAGE, true);
                requireAction.actionPerformed(e);
                errorNotification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/rector/RectorExecutor$1", "actionPerformed"));
            }
        };
        errorNotification.addAction((AnAction)installAction);
        Notifications.Bus.notify((Notification)errorNotification, (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/rector/RectorExecutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRectorExecutablePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findRectorExecutablePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/rector/RectorExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sendExecutableNotFoundNotification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

