/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.rector.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.rector.RectorChangesListener;
import com.jetbrains.php.rector.RectorDataKeys;
import com.jetbrains.php.rector.statistics.RectorUsagesCollector;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RectorApplyAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RectorApplyAction.$$$reportNull$$$0(0);
        }
        List allChanges = (List)e.getData(RectorDataKeys.RECTOR_CHANGES);
        List includedChanges = (List)e.getData(RectorDataKeys.RECTOR_INCLUDED_CHANGES);
        e.getPresentation().setVisible(allChanges != null && !allChanges.isEmpty());
        e.getPresentation().setEnabled(includedChanges != null && !includedChanges.isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RectorApplyAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        List patchChanges = (List)e.getData(RectorDataKeys.RECTOR_INCLUDED_CHANGES);
        if (patchChanges == null) {
            return;
        }
        List changes = (List)e.getData(RectorDataKeys.RECTOR_CHANGES);
        if (changes == null) {
            return;
        }
        List patches = ContainerUtil.map((Collection)patchChanges, c -> c.getPatchInProgress().getPatch());
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir == null) {
            return;
        }
        PatchApplier patchApplier = new PatchApplier(project, projectDir, patches, null, null);
        ApplyPatchStatus applyStatus = patchApplier.execute(true, false);
        assert (applyStatus != ApplyPatchStatus.ABORT && applyStatus != ApplyPatchStatus.FAILURE);
        List notSelectedChanges = ContainerUtil.filter((Collection)changes, c -> !patchChanges.contains(c));
        RectorUsagesCollector.CHANGES_APPLIED.log((Object)(notSelectedChanges.isEmpty() ? RectorUsagesCollector.RectorChangesAppliedType.ALL : RectorUsagesCollector.RectorChangesAppliedType.PARTIAL));
        ((RectorChangesListener)project.getMessageBus().syncPublisher(RectorChangesListener.TOPIC)).setRectorChanges(notSelectedChanges);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            RectorApplyAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/rector/actions/RectorApplyAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/rector/actions/RectorApplyAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

