/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.rector.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.OutputListener;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.json.ComposerJsonNewFileAction;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.rector.RectorBundle;
import com.jetbrains.php.rector.RectorConfigFilesIndex;
import com.jetbrains.php.rector.RectorExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class RectorConfigNewFileAction
extends DumbAwareAction {
    public static final int RECTOR_INIT_TIMEOUT = 10000;
    public static final String RECTOR_CONFIG_FILE_NAME = "rector.php";

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiDirectory psiDir;
        Project project;
        if (e == null) {
            RectorConfigNewFileAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) != null && (psiDir = ComposerJsonNewFileAction.getPsiDirectory((AnActionEvent)e)) != null && psiDir.isValid()) {
            RectorExecutor rectorExecutor = new RectorExecutor(psiDir.getVirtualFile().getPath());
            RectorConfigNewFileAction.createFile(project, psiDir, rectorExecutor);
        }
    }

    @VisibleForTesting
    public static void createFile(final Project project, final PsiDirectory psiDir, final RectorExecutor rectorExecutor) {
        ProgressManager.getInstance().run((Task)new Task.Modal(project, RectorBundle.message("rector.new.config.file.progress.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    ProcessHandler processHandler = rectorExecutor.createInitRectorHandler(project);
                    OutputListener listener = new OutputListener(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            super.processTerminated(event);
                            String stderr = this.getOutput().getStderr();
                            if (event.getExitCode() != 0) {
                                RectorConfigNewFileAction.createFileFallback(project, psiDir, stderr);
                                return;
                            }
                            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{psiDir.getVirtualFile()});
                            VirtualFile configFile = psiDir.getVirtualFile().findChild(RectorConfigNewFileAction.RECTOR_CONFIG_FILE_NAME);
                            if (configFile == null) {
                                RectorConfigNewFileAction.createFileFallback(project, psiDir, stderr);
                                return;
                            }
                            ApplicationManager.getApplication().invokeLater(() -> FileEditorManager.getInstance((Project)project).openFile(configFile, true));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/rector/actions/RectorConfigNewFileAction$1$1", "processTerminated"));
                        }
                    };
                    processHandler.addProcessListener((ProcessListener)listener);
                    processHandler.startNotify();
                    if (!processHandler.waitFor(10000L)) {
                        RectorConfigNewFileAction.createFileFallback(project, psiDir, RectorBundle.message("rector.new.config.file.init.timeout", new Object[0]));
                        processHandler.removeProcessListener((ProcessListener)listener);
                        processHandler.destroyProcess();
                    }
                }
                catch (ExecutionException e) {
                    RectorConfigNewFileAction.createFileFallback(project, psiDir, e.getMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/rector/actions/RectorConfigNewFileAction$1", "run"));
            }
        });
    }

    private static void createFileFallback(Project project, PsiDirectory psiDir, String reason) {
        ApplicationManager.getApplication().invokeLater(() -> {
            FileTemplate template = FileTemplateManager.getInstance((Project)project).getInternalTemplate(RECTOR_CONFIG_FILE_NAME);
            PsiFile psiFile = CreateFileFromTemplateAction.createFileFromTemplate((String)RECTOR_CONFIG_FILE_NAME, (FileTemplate)template, (PsiDirectory)psiDir, null, (boolean)true);
            String message = reason.isEmpty() ? RectorBundle.message("rector.new.config.file.created.from.fallback.notification.content", new Object[0]) : RectorBundle.message("rector.new.config.file.created.from.fallback.notification.with.cause.content", reason);
            PhpDebugUtil.showWarningBalloon((Project)project, (String)RectorBundle.message("rector.new.config.file.created.from.fallback.notification.title", new Object[0]), (String)message, null);
            if (psiFile != null) {
                VirtualFile configFile = psiFile.getVirtualFile();
                FileEditorManager.getInstance((Project)project).openFile(configFile, true);
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile virtualDir;
        PsiDirectory psiDir;
        Project project;
        if (e == null) {
            RectorConfigNewFileAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) != null && (psiDir = ComposerJsonNewFileAction.getPsiDirectory((AnActionEvent)e)) != null && psiDir.isValid() && (virtualDir = psiDir.getVirtualFile()).isValid() && virtualDir.isDirectory() && (DumbService.isDumb((Project)project) || !ContainerUtil.exists(RectorConfigFilesIndex.getRectorConfigFiles(project), f -> virtualDir.equals(f.getParent())))) {
            e.getPresentation().setEnabledAndVisible(true);
            return;
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RectorConfigNewFileAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/rector/actions/RectorConfigNewFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/rector/actions/RectorConfigNewFileAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

