/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.rector.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.insert.PhpClassStaticInsertHandler;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.rector.completion.RectorClassConstantLookupElement;
import com.jetbrains.php.rector.run.RectorRunLineMarkerContributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RectorCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final String RECTOR_RULE_FQN = "\\Rector\\Core\\Rector\\AbstractRector";
    private static final String RECTOR_SET_LIST_FQN = "\\Rector\\Set\\Contract\\SetListInterface";
    private static final PsiElementPattern.Capture<PsiElement> ARRAY_VALUE_IN_METHOD_REFERENCE = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(ConstantReference.class)).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement((IElementType)PhpElementTypes.ARRAY_VALUE).withSuperParent(3, MethodReference.class));
    private static final RectorRulesCompletionProvider RECTOR_RULES_COMPLETION_PROVIDER = new RectorRulesCompletionProvider();

    public RectorCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(ConstantReference.class)).withSuperParent(2, ParameterList.class)).withSuperParent(3, MethodReference.class), RECTOR_RULES_COMPLETION_PROVIDER);
        this.extend(CompletionType.BASIC, (ElementPattern)ARRAY_VALUE_IN_METHOD_REFERENCE, RECTOR_RULES_COMPLETION_PROVIDER);
    }

    private static class RectorRulesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private RectorRulesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            MethodReference methodReference;
            PsiElement element;
            if (parameters == null) {
                RectorRulesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                RectorRulesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                RectorRulesCompletionProvider.$$$reportNull$$$0(2);
            }
            if (!RectorRulesCompletionProvider.isAvailable(element = parameters.getPosition().getOriginalElement(), methodReference = (MethodReference)PhpPsiUtil.getParentOfClass((PsiElement)element, MethodReference.class))) {
                return;
            }
            boolean isSetList = PhpLangUtil.equalsMethodNames((CharSequence)"sets", (CharSequence)methodReference.getName());
            PhpExpression classReference = methodReference.getClassReference();
            if (classReference == null) {
                return;
            }
            if (!PhpType.intersectsGlobal((Project)element.getProject(), (PhpType)RectorRunLineMarkerContributor.RECTOR_NEW_CONTAINER_CONFIG_TYPE, (PhpType)classReference.getType())) {
                return;
            }
            if (!PhpPsiUtil.isOfType((PsiElement)element.getPrevSibling(), (IElementType)PhpTokenTypes.SCOPE_RESOLUTION)) {
                PhpIndex.getInstance((Project)element.getProject()).processAllSubclasses(isSetList ? RectorCompletionContributor.RECTOR_SET_LIST_FQN : RectorCompletionContributor.RECTOR_RULE_FQN, c -> {
                    if (!c.isAbstract()) {
                        result.addElement((LookupElement)(isSetList ? RectorRulesCompletionProvider.getSetListLookupElement((PhpNamedElement)c) : new RectorClassConstantLookupElement((PhpClass)c)));
                    }
                    return true;
                });
            }
        }

        private static boolean isAvailable(@NotNull PsiElement element, @Nullable MethodReference methodReference) {
            if (element == null) {
                RectorRulesCompletionProvider.$$$reportNull$$$0(3);
            }
            if (methodReference == null) {
                return false;
            }
            String methodName = methodReference.getName();
            boolean isArrayValue = PhpPsiUtil.isOfType((PsiElement)element.getParent().getParent(), (IElementType)PhpElementTypes.ARRAY_VALUE);
            return PhpLangUtil.equalsMethodNames((CharSequence)"rule", (CharSequence)methodName) || PhpLangUtil.equalsMethodNames((CharSequence)"sets", (CharSequence)methodName) && isArrayValue || PhpLangUtil.equalsMethodNames((CharSequence)"rules", (CharSequence)methodName) && isArrayValue || PhpLangUtil.equalsMethodNames((CharSequence)"ruleWithConfiguration", (CharSequence)methodName) && PhpCodeInsightUtil.getParameterIndex((PsiElement)element.getParent()) == 0;
        }

        @NotNull
        private static LookupElement getSetListLookupElement(@NotNull PhpNamedElement clazz) {
            if (clazz == null) {
                RectorRulesCompletionProvider.$$$reportNull$$$0(4);
            }
            PhpLookupElement lookupElement = new PhpLookupElement(clazz);
            lookupElement.handler = PhpClassStaticInsertHandler.getInstance();
            PhpLookupElement phpLookupElement = lookupElement;
            if (phpLookupElement == null) {
                RectorRulesCompletionProvider.$$$reportNull$$$0(5);
            }
            return phpLookupElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/rector/completion/RectorCompletionContributor$RectorRulesCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/rector/completion/RectorCompletionContributor$RectorRulesCompletionProvider";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSetListLookupElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getSetListLookupElement";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

