/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.rector.run;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.MatchPatchPaths;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.rector.RectorBundle;
import com.jetbrains.php.rector.RectorChangesListener;
import com.jetbrains.php.rector.RectorExecutor;
import com.jetbrains.php.rector.RectorFileDiffInfo;
import com.jetbrains.php.rector.run.RectorConfigurationSettingsEditor;
import com.jetbrains.php.rector.run.RectorExecutionConsoleWrapper;
import com.jetbrains.php.rector.run.RectorRunConfigurationOptions;
import com.jetbrains.php.rector.statistics.RectorUsagesCollector;
import com.jetbrains.php.rector.ui.RectorConsoleProgress;
import com.jetbrains.php.run.PhpRunConfiguration;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class RectorRunConfiguration
extends PhpRunConfiguration<RectorRunConfigurationOptions> {
    private static final Logger LOG = Logger.getInstance(RectorRunConfiguration.class);
    private static final RectorFileDiffInfo[] EMPTY_RECTOR_DIFF_ARRAY = new RectorFileDiffInfo[0];
    @NonNls
    private static final String UNIFIED_DIFF_BEFORE_PREFIX = "--- ";
    @NonNls
    private static final String UNIFIED_DIFF_AFTER_PREFIX = "+++ ";

    protected RectorRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @Nullable String name) {
        if (project == null) {
            RectorRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            RectorRunConfiguration.$$$reportNull$$$0(1);
        }
        super(project, factory, name);
    }

    @NotNull
    protected RectorRunConfigurationOptions createSettings() {
        RectorRunConfigurationOptions rectorRunConfigurationOptions = this.getOptions();
        if (rectorRunConfigurationOptions == null) {
            RectorRunConfiguration.$$$reportNull$$$0(2);
        }
        return rectorRunConfigurationOptions;
    }

    @NotNull
    protected RectorRunConfigurationOptions getOptions() {
        RectorRunConfigurationOptions rectorRunConfigurationOptions = (RectorRunConfigurationOptions)super.getOptions();
        if (rectorRunConfigurationOptions == null) {
            RectorRunConfiguration.$$$reportNull$$$0(3);
        }
        return rectorRunConfigurationOptions;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new RectorConfigurationSettingsEditor(this.getProject(), this.getOptions());
    }

    @Nullable
    public String suggestedName() {
        List<String> paths = this.getOptions().getPathsToProcess();
        if (!paths.isEmpty()) {
            String firstPath = paths.get(0);
            if (paths.size() > 1) {
                return RectorBundle.message("rector.run.multiple.paths", PathUtil.getFileName((String)firstPath), paths.size() - 1);
            }
            return PathUtil.getFileName((String)firstPath);
        }
        return null;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, final @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            RectorRunConfiguration.$$$reportNull$$$0(4);
        }
        if (environment == null) {
            RectorRunConfiguration.$$$reportNull$$$0(5);
        }
        return new RunProfileState(){

            @NotNull
            public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
                if (runner == null) {
                    1.$$$reportNull$$$0(0);
                }
                final Project project = environment.getProject();
                VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
                assert (projectDir != null);
                RectorExecutor rectorExecutor = new RectorExecutor(projectDir.getPath());
                ProcessHandler processHandler = rectorExecutor.createDryRunRectorHandler(project, RectorRunConfiguration.this, RectorRunConfiguration.this.getOptions());
                processHandler.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                    public void startNotified(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.startNotified(event);
                        LOG.debug("start notified");
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        ProcessOutput output = this.getOutput();
                        LOG.debug("process terminated with exit code = " + event.getExitCode());
                        if (!output.getStderr().isEmpty()) {
                            LOG.debug("stderr = " + output.getStderr());
                        }
                        if (output.isCancelled()) {
                            RectorUsagesCollector.EXECUTION_FINISHED.log((Object)RectorUsagesCollector.RectorFinishedType.CANCELLED);
                        } else {
                            try {
                                LOG.debug("stdout = " + output.getStdout());
                                List<AbstractFilePatchInProgress.PatchChange> changes = RectorRunConfiguration.parseChanges(project, output);
                                LOG.debug("publish rector changes");
                                ((RectorChangesListener)project.getMessageBus().syncPublisher(RectorChangesListener.TOPIC)).setRectorChanges(changes);
                                if (RectorRunConfiguration.isProcessTerminatedByUser(event.getExitCode())) {
                                    RectorUsagesCollector.EXECUTION_FINISHED.log((Object)RectorUsagesCollector.RectorFinishedType.CANCELLED);
                                } else {
                                    RectorUsagesCollector.EXECUTION_FINISHED.log((Object)RectorUsagesCollector.RectorFinishedType.SUCCEED);
                                }
                            }
                            catch (JsonProcessingException | PatchSyntaxException e) {
                                LOG.debug(e);
                                String stderr = output.getStderr();
                                RectorRunConfiguration.sendErrorNotification(project, (String)(stderr.isEmpty() ? e.getMessage() : stderr + "; " + e.getMessage()));
                                RectorUsagesCollector.EXECUTION_FINISHED.log((Object)RectorUsagesCollector.RectorFinishedType.FAILED);
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "event";
                        objectArray2[1] = "com/jetbrains/php/rector/run/RectorRunConfiguration$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "startNotified";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                if (ApplicationManagerEx.isInIntegrationTest()) {
                    LOG.debug("subscribe to rector changes update");
                    project.getMessageBus().connect().subscribe(RectorChangesListener.TOPIC, changes -> RectorRunConfiguration.writeRectorChangesToFile(project, projectDir.toNioPath(), changes));
                    return new DefaultExecutionResult(processHandler);
                }
                ConsoleViewImpl console = new ConsoleViewImpl(project, false);
                console.attachToProcess(processHandler);
                RectorConsoleProgress.install((ConsoleView)console, processHandler);
                return new DefaultExecutionResult((ExecutionConsole)new RectorExecutionConsoleWrapper(project, (ConsoleView)console), processHandler);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/jetbrains/php/rector/run/RectorRunConfiguration$1", "execute"));
            }
        };
    }

    private static boolean isProcessTerminatedByUser(int exitCode) {
        Platform platform = Platform.current();
        return platform == Platform.WINDOWS ? exitCode == -1073741510 : exitCode == 137 || exitCode == 130;
    }

    private static void writeRectorChangesToFile(Project project, Path basePath, List<AbstractFilePatchInProgress.PatchChange> changes) {
        try (BufferedWriter writer = Files.newBufferedWriter(basePath.resolve("rector_changes_dump.patch"), new OpenOption[0]);){
            List patches = ContainerUtil.map(changes, c -> c.getPatchInProgress().getPatch());
            LOG.debug("dumping patches");
            UnifiedDiffWriter.write((Project)project, (Path)basePath, (Collection)patches, (Writer)writer, (String)"\n", null, null);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @VisibleForTesting
    @NotNull
    public static List<AbstractFilePatchInProgress.PatchChange> parseChanges(Project project, ProcessOutput output) throws JsonProcessingException, PatchSyntaxException {
        RectorFileDiffInfo[] fileDiffs = RectorRunConfiguration.getFileDiffs(output);
        List<FilePatch> patches = RectorRunConfiguration.parseFilePatches(fileDiffs);
        return RectorRunConfiguration.getChanges(project, patches);
    }

    @NotNull
    private static List<AbstractFilePatchInProgress.PatchChange> getChanges(Project project, List<FilePatch> patches) {
        List matchedPatches = new MatchPatchPaths(project).execute(patches, true);
        List list = ContainerUtil.map((Collection)matchedPatches, AbstractFilePatchInProgress::getChange);
        if (list == null) {
            RectorRunConfiguration.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static List<FilePatch> parseFilePatches(RectorFileDiffInfo[] fileDiffs) throws PatchSyntaxException {
        if (fileDiffs.length == 0) {
            return Collections.emptyList();
        }
        List rawPatches = ContainerUtil.map((Object[])fileDiffs, RectorRunConfiguration::toIntellijCompatiblePatch);
        PatchReader patchReader = new PatchReader((CharSequence)String.join((CharSequence)"", rawPatches));
        patchReader.parseAllPatches();
        return patchReader.getAllPatches();
    }

    private static RectorFileDiffInfo[] getFileDiffs(ProcessOutput output) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(output.getStdout());
        if (node.has("file_diffs")) {
            return (RectorFileDiffInfo[])mapper.treeToValue((TreeNode)node.path("file_diffs"), RectorFileDiffInfo[].class);
        }
        return EMPTY_RECTOR_DIFF_ARRAY;
    }

    @NotNull
    private static String toIntellijCompatiblePatch(@NotNull RectorFileDiffInfo diffInfo) {
        if (diffInfo == null) {
            RectorRunConfiguration.$$$reportNull$$$0(7);
        }
        String originalDiff = diffInfo.diff;
        String patchedDiff = originalDiff.replace("--- Original", "--- a/" + diffInfo.file);
        String string = patchedDiff = patchedDiff.replace("+++ New", "+++ b/" + diffInfo.file);
        if (string == null) {
            RectorRunConfiguration.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static void sendErrorNotification(@NotNull Project project, @NlsContexts.NotificationContent String message) {
        if (project == null) {
            RectorRunConfiguration.$$$reportNull$$$0(9);
        }
        Notification errorNotification = new Notification("RectorRunError", RectorBundle.message("notification.rector.run.error", new Object[0]), message, NotificationType.ERROR);
        Notifications.Bus.notify((Notification)errorNotification, (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/rector/run/RectorRunConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/rector/run/RectorRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toIntellijCompatiblePatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toIntellijCompatiblePatch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sendErrorNotification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 8 -> new IllegalStateException(string);
        };
    }
}

