/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.rector.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.rector.RectorConfigFilesIndex;
import com.jetbrains.php.rector.run.RectorRunConfiguration;
import com.jetbrains.php.rector.run.RectorRunConfigurationType;
import com.jetbrains.php.rector.run.RectorRunLineMarkerContributor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RectorRunConfigurationProducer
extends LazyRunConfigurationProducer<RectorRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = RectorRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            RectorRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull RectorRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement element;
        if (configuration == null) {
            RectorRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            RectorRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            RectorRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((element = context.getPsiLocation()) instanceof PsiDirectory || element instanceof PhpFile) {
            Collection<VirtualFile> selectedVirtualFiles = RectorRunConfigurationProducer.getSelectedVirtualFiles(context);
            List pathsToProcess = ContainerUtil.map(selectedVirtualFiles, VirtualFile::getPath);
            if (pathsToProcess.isEmpty()) {
                return false;
            }
            VirtualFile nearestRectorConfig = RectorRunConfigurationProducer.getNearestRectorConfig(context.getProject(), VfsUtil.getCommonAncestor(selectedVirtualFiles));
            if (nearestRectorConfig == null) {
                return false;
            }
            configuration.getOptions().setRectorConfigPath(nearestRectorConfig.getPath());
            configuration.getOptions().setPathsToProcess(pathsToProcess);
            configuration.setGeneratedName();
            return true;
        }
        if (RectorRunLineMarkerContributor.isFromRectorConfigFile(element)) {
            PhpFile rectorConfigFile = (PhpFile)element.getContainingFile();
            configuration.getOptions().setRectorConfigPath(rectorConfigFile.getVirtualFile().getPath());
            if (RectorRunConfigurationProducer.hasConfiguredPaths(rectorConfigFile)) {
                configuration.getOptions().setPathsToProcess(Collections.emptyList());
            } else {
                List sourceRootPaths = ContainerUtil.map((Object[])ProjectRootManager.getInstance((Project)context.getProject()).getContentSourceRoots(), VirtualFile::getPath);
                if (!sourceRootPaths.isEmpty()) {
                    configuration.getOptions().setPathsToProcess(sourceRootPaths);
                    configuration.setGeneratedName();
                    return true;
                }
                VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)element.getProject());
                if (projectDir != null) {
                    configuration.getOptions().setPathsToProcess(Collections.singletonList(projectDir.getPath()));
                    configuration.setGeneratedName();
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile getNearestRectorConfig(@NotNull Project project, @Nullable VirtualFile commonAncestor) {
        if (project == null) {
            RectorRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (commonAncestor == null) {
            return null;
        }
        Collection<VirtualFile> rectorConfigFiles = RectorConfigFilesIndex.getRectorConfigFiles(project);
        if (rectorConfigFiles.isEmpty()) {
            return null;
        }
        Map containingDirToConfig = ((StreamEx)StreamEx.of(rectorConfigFiles).sortedBy(VirtualFile::getPath)).mapToEntry(VirtualFile::getParent, Function.identity()).distinctKeys().toMap();
        for (VirtualFile candidateDir = commonAncestor; candidateDir != null; candidateDir = candidateDir.getParent()) {
            VirtualFile candidateConfig = (VirtualFile)containingDirToConfig.get(candidateDir);
            if (candidateConfig == null) continue;
            return candidateConfig;
        }
        return null;
    }

    @NotNull
    private static Collection<VirtualFile> getSelectedVirtualFiles(@NotNull ConfigurationContext context) {
        Object[] data;
        if (context == null) {
            RectorRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        List list = (data = (PsiElement[])PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.getData(context.getDataContext())) == null ? Collections.emptyList() : StreamEx.of((Object[])data).select(PsiFileSystemItem.class).map(PsiFileSystemItem::getVirtualFile).toList();
        if (list == null) {
            RectorRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        return list;
    }

    public boolean isConfigurationFromContext(@NotNull RectorRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            RectorRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (context == null) {
            RectorRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        PsiElement element = context.getPsiLocation();
        List<String> pathsFromSettings = configuration.getOptions().getPathsToProcess();
        String rectorConfigPath = configuration.getOptions().getRectorConfigPath();
        if (element instanceof PsiDirectory || element instanceof PhpFile) {
            Collection<VirtualFile> selectedVirtualFiles = RectorRunConfigurationProducer.getSelectedVirtualFiles(context);
            List selectedPaths = ContainerUtil.map(selectedVirtualFiles, VirtualFile::getPath);
            VirtualFile nearestRectorConfig = RectorRunConfigurationProducer.getNearestRectorConfig(context.getProject(), VfsUtil.getCommonAncestor(selectedVirtualFiles));
            return nearestRectorConfig != null && FileUtil.comparePaths((String)nearestRectorConfig.getPath(), (String)rectorConfigPath) == 0 && RectorRunConfigurationProducer.areSamePaths(pathsFromSettings, selectedPaths);
        }
        if (RectorRunLineMarkerContributor.isFromRectorConfigFile(element)) {
            PhpFile rectorConfigFile = (PhpFile)element.getContainingFile();
            if (rectorConfigPath != null && FileUtil.comparePaths((String)rectorConfigFile.getVirtualFile().getPath(), (String)FileUtil.toSystemIndependentName((String)rectorConfigPath)) != 0) {
                return false;
            }
            if (pathsFromSettings.isEmpty() && RectorRunConfigurationProducer.hasConfiguredPaths(rectorConfigFile)) {
                return true;
            }
            if (!pathsFromSettings.isEmpty()) {
                List sourceRootPaths = ContainerUtil.map((Object[])ProjectRootManager.getInstance((Project)context.getProject()).getContentSourceRoots(), VirtualFile::getPath);
                if (!sourceRootPaths.isEmpty() && RectorRunConfigurationProducer.areSamePaths(sourceRootPaths, pathsFromSettings)) {
                    return true;
                }
                VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)element.getProject());
                if (projectDir != null) {
                    return FileUtil.comparePaths((String)projectDir.getPath(), (String)((String)ContainerUtil.getOnlyItem(pathsFromSettings))) == 0;
                }
            }
        }
        return false;
    }

    private static boolean areSamePaths(@NotNull List<String> pathsFromSettings, @NotNull List<String> pathsToProcess) {
        if (pathsFromSettings == null) {
            RectorRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (pathsToProcess == null) {
            RectorRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        return pathsFromSettings.size() == pathsToProcess.size() && ContainerUtil.all(pathsToProcess, p1 -> ContainerUtil.exists((Iterable)pathsFromSettings, p2 -> FileUtil.comparePaths((String)p1, (String)p2) == 0));
    }

    private static boolean hasConfiguredPaths(@NotNull PhpFile rectorConfig) {
        if (rectorConfig == null) {
            RectorRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        return !PsiTreeUtil.processElements((PsiElement)rectorConfig, MethodReference.class, methodReference -> {
            PsiElement firstParameter;
            String methodName = methodReference.getName();
            PhpExpression reference = methodReference.getClassReference();
            if ("paths".equalsIgnoreCase(methodName) && reference != null && RectorRunLineMarkerContributor.isRectorConfigurationType(rectorConfig.getProject(), reference.getType())) {
                return false;
            }
            return !"set".equalsIgnoreCase(methodName) || !((firstParameter = methodReference.getParameter(0)) instanceof ClassConstantReference) || !"PATHS".equals(((ClassConstantReference)firstParameter).getName());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/rector/run/RectorRunConfigurationProducer";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsFromSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsToProcess";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectorConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/rector/run/RectorRunConfigurationProducer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVirtualFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNearestRectorConfig";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedVirtualFiles";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "areSamePaths";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasConfiguredPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

