/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.rector.run;

import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.rector.RectorBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RectorRunLineMarkerContributor
extends RunLineMarkerContributor {
    private static final String RECTOR_CONTAINER_CONFIGURATOR_FQN = "\\Symfony\\Component\\DependencyInjection\\Loader\\Configurator\\ContainerConfigurator";
    private static final String RECTOR_NEW_CONTAINER_CONFIG_FQN = "\\Rector\\Config\\RectorConfig";
    public static final PhpType RECTOR_NEW_CONTAINER_CONFIG_TYPE = PhpType.from((String[])new String[]{"\\Rector\\Config\\RectorConfig"});
    private static final PhpType RECTOR_CONTAINER_CONFIGURATOR_TYPE = PhpType.from((String[])new String[]{"\\Symfony\\Component\\DependencyInjection\\Loader\\Configurator\\ContainerConfigurator", "\\Rector\\Config\\RectorConfig"});

    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        if (element == null) {
            RectorRunLineMarkerContributor.$$$reportNull$$$0(0);
        }
        if (!(element instanceof LeafPsiElement)) {
            return null;
        }
        if (PhpPsiUtil.isOfType((PsiElement)element, (IElementType)PhpTokenTypes.kwRETURN) && RectorRunLineMarkerContributor.isRectorConfigurationType(element.getProject(), RectorRunLineMarkerContributor.getPossibleRectorConfigurationType(element.getParent()))) {
            return new RunLineMarkerContributor.Info(AllIcons.RunConfigurations.TestState.Run, e -> RectorBundle.message("rector.run.line.marker.name", new Object[0]), ExecutorAction.getActions());
        }
        return null;
    }

    public static boolean isFromRectorConfigFile(@Nullable PsiElement element) {
        PhpReturn returnStatement;
        if (element == null) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        return file instanceof PhpFile && (returnStatement = (PhpReturn)PhpPsiUtil.getChildOfClass((PsiElement)((PhpFile)file).getFirstPsiChild(), PhpReturn.class)) != null && RectorRunLineMarkerContributor.isRectorConfigurationType(element.getProject(), RectorRunLineMarkerContributor.getPossibleRectorConfigurationType((PsiElement)returnStatement));
    }

    @NotNull
    public static PhpType getPossibleRectorConfigurationType(@Nullable PsiElement element) {
        Parameter[] parameters;
        PhpPsiElement onlyChild;
        PhpReturn returnStatement = (PhpReturn)ObjectUtils.tryCast((Object)element, PhpReturn.class);
        if (returnStatement == null || !(returnStatement.getParent().getParent() instanceof PhpFile)) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                RectorRunLineMarkerContributor.$$$reportNull$$$0(1);
            }
            return phpType;
        }
        PhpExpression expression = (PhpExpression)ObjectUtils.tryCast((Object)returnStatement.getArgument(), PhpExpression.class);
        if (expression != null && expression.getChildren().length == 1 && (onlyChild = expression.getFirstPsiChild()) instanceof Function && ((Function)onlyChild).isClosure() && (parameters = ((Function)onlyChild).getParameters()).length == 1) {
            PhpType phpType = parameters[0].getType();
            if (phpType == null) {
                RectorRunLineMarkerContributor.$$$reportNull$$$0(2);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            RectorRunLineMarkerContributor.$$$reportNull$$$0(3);
        }
        return phpType;
    }

    public static boolean isRectorConfigurationType(@NotNull Project project, @NotNull PhpType type) {
        if (project == null) {
            RectorRunLineMarkerContributor.$$$reportNull$$$0(4);
        }
        if (type == null) {
            RectorRunLineMarkerContributor.$$$reportNull$$$0(5);
        }
        return !type.isEmpty() && RECTOR_CONTAINER_CONFIGURATOR_TYPE.isConvertibleFromGlobal(project, type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/rector/run/RectorRunLineMarkerContributor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/rector/run/RectorRunLineMarkerContributor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleRectorConfigurationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRectorConfigurationType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

