/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.rector.ui;

import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesTreeEditorDiffPreview;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDiffPreviewHandler;
import com.intellij.openapi.vcs.changes.ui.DefaultChangesTreeDiffPreviewHandler;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerChangesTreeTracker;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerEditorDiffPreview;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.php.rector.RectorBundle;
import com.jetbrains.php.rector.RectorDataKeys;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RectorChangesTree
extends ChangesTree {
    private List<? extends Change> myChanges;
    private ChangesTreeEditorDiffPreview myDiffPreview;

    public RectorChangesTree(@NotNull Project project, @NotNull List<? extends Change> changes, boolean showCheckboxes, boolean highlightProblems) {
        if (project == null) {
            RectorChangesTree.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            RectorChangesTree.$$$reportNull$$$0(1);
        }
        super(project, showCheckboxes, highlightProblems);
        this.setKeepTreeState(true);
        this.myChanges = changes;
        this.getEmptyText().setText(RectorBundle.message("status.text.no.changes.suggested.by.rector", new Object[0]));
    }

    public void rebuildTree() {
        boolean wasEmpty = this.getAllPatchChanges().isEmpty();
        this.updateTreeModel(this.buildTreeModel());
        if (!this.getAllPatchChanges().isEmpty() && wasEmpty) {
            this.expandDefaults();
        }
        if (this.getSelectionCount() == 0) {
            TreeUtil.selectFirstNode((JTree)((Object)this));
        }
    }

    @NotNull
    private List<AbstractFilePatchInProgress.PatchChange> getAllPatchChanges() {
        List list = VcsTreeModelData.all((JTree)((Object)this)).userObjects(AbstractFilePatchInProgress.PatchChange.class);
        if (list == null) {
            RectorChangesTree.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            RectorChangesTree.$$$reportNull$$$0(3);
        }
        super.uiDataSnapshot(sink);
        sink.set(RectorDataKeys.RECTOR_INCLUDED_CHANGES, (Object)VcsTreeModelData.included((ChangesTree)this).userObjects(AbstractFilePatchInProgress.PatchChange.class));
        sink.set(RectorDataKeys.RECTOR_CHANGES, this.getAllPatchChanges());
    }

    public void setChanges(List<? extends Change> changes) {
        this.myChanges = changes;
        this.rebuildTree();
    }

    @NotNull
    private DefaultTreeModel buildTreeModel() {
        if (this.myChanges.isEmpty()) {
            DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildEmpty();
            if (defaultTreeModel == null) {
                RectorChangesTree.$$$reportNull$$$0(4);
            }
            return defaultTreeModel;
        }
        TreeModelBuilder builder = new TreeModelBuilder(this.myProject, this.getGrouping());
        builder.insertChanges(this.myChanges, builder.myRoot);
        DefaultTreeModel defaultTreeModel = builder.build();
        if (defaultTreeModel == null) {
            RectorChangesTree.$$$reportNull$$$0(5);
        }
        return defaultTreeModel;
    }

    public void installDiffPreview(@NotNull Disposable disposable) {
        if (disposable == null) {
            RectorChangesTree.$$$reportNull$$$0(6);
        }
        this.myDiffPreview = new MyDiffPreview(this.myProject, this);
        Disposer.register((Disposable)disposable, (Disposable)this.myDiffPreview);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/rector/ui/RectorChangesTree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/rector/ui/RectorChangesTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPatchChanges";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installDiffPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static class MyDiffPreview
    extends TreeHandlerEditorDiffPreview {
        private final Project myProject;

        private MyDiffPreview(@NotNull Project project, @NotNull RectorChangesTree tree) {
            if (project == null) {
                MyDiffPreview.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                MyDiffPreview.$$$reportNull$$$0(1);
            }
            super((ChangesTree)tree, (ChangesTreeDiffPreviewHandler)DefaultChangesTreeDiffPreviewHandler.INSTANCE);
            this.myProject = project;
        }

        @NotNull
        protected DiffEditorViewer createViewer() {
            TreeHandlerDiffRequestProcessor processor = new TreeHandlerDiffRequestProcessor("Run", this.getTree(), this.getHandler());
            processor.putContextUserData(DiffUserDataKeys.FORCE_READ_ONLY, (Object)true);
            new TreeHandlerChangesTreeTracker(this.getTree(), (DiffEditorViewer)processor, this.getHandler(), true).track();
            TreeHandlerDiffRequestProcessor treeHandlerDiffRequestProcessor = processor;
            if (treeHandlerDiffRequestProcessor == null) {
                MyDiffPreview.$$$reportNull$$$0(2);
            }
            return treeHandlerDiffRequestProcessor;
        }

        public String getEditorTabName(@Nullable ChangeViewDiffRequestProcessor.Wrapper wrapper) {
            return wrapper != null ? wrapper.getPresentableName() : null;
        }

        public void returnFocusToTree() {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Run");
            if (toolWindow != null) {
                toolWindow.activate(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/rector/ui/RectorChangesTree$MyDiffPreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/rector/ui/RectorChangesTree$MyDiffPreview";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createViewer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

