/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.sql;

import com.intellij.database.remote.jdba.sql.TextPointer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TextWalker
implements Cloneable {
    @NotNull
    private final String myText;
    private final int myLength;
    private int myOffset;
    private int myRow;
    private int myPos;
    private char myChar;

    TextWalker(@NotNull String text) {
        if (text == null) {
            TextWalker.$$$reportNull$$$0(0);
        }
        this.myOffset = 0;
        this.myRow = 1;
        this.myPos = 1;
        this.myText = text;
        this.myLength = this.myText.length();
        this.myChar = this.myLength > 0 ? this.myText.charAt(0) : (char)'\u0000';
    }

    @NotNull
    public TextPointer getPointer() {
        return new TextPointer(this.myOffset, this.myRow, this.myPos);
    }

    public void setPointer(@NotNull TextPointer pointer) {
        if (pointer == null) {
            TextWalker.$$$reportNull$$$0(1);
        }
        this.myOffset = pointer.offset;
        this.myRow = pointer.row;
        this.myPos = pointer.pos;
        this.myChar = this.myLength > 0 ? this.myText.charAt(0) : (char)'\u0000';
    }

    public void next() {
        if (this.myOffset >= this.myLength) {
            throw new IllegalStateException("End of Text");
        }
        if (this.myChar == '\n') {
            ++this.myRow;
            this.myPos = 1;
        } else {
            ++this.myPos;
        }
        ++this.myOffset;
        this.myChar = this.myOffset < this.myLength ? this.myText.charAt(this.myOffset) : (char)'\u0000';
    }

    public String popRow() {
        int offset1 = this.myOffset;
        int row1 = this.myRow;
        while (row1 == this.myRow && !this.isEOT()) {
            this.next();
        }
        return this.myText.substring(offset1, this.myOffset);
    }

    @Nullable
    public Matcher skipToPattern(@NotNull Pattern pattern) {
        Matcher m;
        boolean found;
        if (pattern == null) {
            TextWalker.$$$reportNull$$$0(2);
        }
        if (found = (m = pattern.matcher(this.myText)).find(this.myOffset)) {
            int goal = m.start();
            while (this.myOffset < goal) {
                this.next();
            }
            return m;
        }
        while (this.myOffset < this.myLength) {
            this.next();
        }
        return null;
    }

    public void skipToOffset(int newOffset) {
        if (newOffset < this.myOffset) {
            throw new IllegalArgumentException("Attempted to skip back");
        }
        if (newOffset > this.myLength) {
            throw new IllegalArgumentException("Attempted to skip out of the end of text");
        }
        int distance = newOffset - this.myOffset;
        for (int i = 1; i <= distance; ++i) {
            this.next();
        }
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            TextWalker.$$$reportNull$$$0(3);
        }
        return string;
    }

    public int getLength() {
        return this.myLength;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getRow() {
        return this.myRow;
    }

    public int getPos() {
        return this.myPos;
    }

    public char getChar() {
        return this.myChar;
    }

    public char getNextChar() {
        int k = this.myOffset + 1;
        return k < this.myLength ? this.myText.charAt(k) : (char)'\u0000';
    }

    public boolean isEOT() {
        return this.myOffset >= this.myLength;
    }

    public TextWalker clone() {
        TextWalker clone = new TextWalker(this.myText);
        clone.myOffset = this.myOffset;
        clone.myRow = this.myRow;
        clone.myPos = this.myPos;
        clone.myChar = this.myChar;
        return clone;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/sql/TextWalker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/sql/TextWalker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPointer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "skipToPattern";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

