/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgGPlumJdbcHelperBase;
import java.sql.Connection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class YBJdbcHelper
extends PgGPlumJdbcHelperBase {
    private static final Pattern YB_VERSION_PATTERN = Pattern.compile("-YB-(\\d+(?:\\.\\d+)*)");

    public YBJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("YUGABYTE", version, connection);
    }

    public YBJdbcHelper() {
        this(null, null);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return new YBJdbcHelper(version, connection);
    }

    @Override
    public boolean supportsLimitMaxRows() {
        return false;
    }

    @Override
    @Nullable
    public Boolean supportsSavepoints() {
        return false;
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return YBJdbcHelper.extractVersion(version);
    }

    @NotNull
    static YBJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        String version = YBJdbcHelper.extractVersion(productVer);
        return new YBJdbcHelper(version, delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, YB_VERSION_PATTERN);
    }
}

