/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeception;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.codeception.CodeceptionSettingsManager;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import icons.CodeceptionIcons;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeceptionCestTestCreateInfo
implements PhpTestCreateInfo {
    public static final String TEST_SUFFIX = "Cest";
    public static final String DEFAULT_TEST_DIRECTORY_SUFFIX = "functional";
    public static final CodeceptionCestTestCreateInfo INSTANCE = new CodeceptionCestTestCreateInfo();
    public static final String CODECEPTION_CEST_METHOD_TEMPLATE_NAME = "Codeception Functional Test Method";

    @NotNull
    @NlsSafe
    public String getName() {
        return "Codeception Functional";
    }

    @NotNull
    public String getTemplateName() {
        return "Codeception Functional Test";
    }

    @Nullable
    public Icon getIcon() {
        return CodeceptionIcons.Codeception;
    }

    @NotNull
    @NlsSafe
    public String getDefaultTestName(@NotNull String targetClassName) {
        if (targetClassName == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(0);
        }
        String string = targetClassName + TEST_SUFFIX;
        if (string == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getTestNamespace(@NotNull Project project, @NotNull VirtualFile directory, @NotNull String namespace, @NotNull String fromNamespace, @NotNull String path) {
        if (project == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(3);
        }
        if (namespace == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(4);
        }
        if (fromNamespace == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(5);
        }
        if (path == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(6);
        }
        return CodeceptionCestTestCreateInfo.suggestTestNamespace(project, directory, DEFAULT_TEST_DIRECTORY_SUFFIX);
    }

    @Nullable
    public String getTestDirectory(@NotNull Project project, @NotNull SourceFolder sourceFolder, @NotNull String toNamespace, @NotNull String fromNamespace) {
        if (project == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(7);
        }
        if (sourceFolder == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(8);
        }
        if (toNamespace == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(9);
        }
        if (fromNamespace == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(10);
        }
        return CodeceptionCestTestCreateInfo.getTestDirectory(project, sourceFolder.getFile(), DEFAULT_TEST_DIRECTORY_SUFFIX);
    }

    public boolean isConfiguredFolder(@NotNull Project project, @Nullable VirtualFile directory) {
        if (project == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(11);
        }
        return directory != null && CodeceptionSettingsManager.getInstance(project).hasMatchedConfigurations(directory.getPath());
    }

    @Nullable
    static String getTestDirectory(@NotNull Project project, @Nullable VirtualFile file, @NotNull String directorySuffix) {
        if (project == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(12);
        }
        if (directorySuffix == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(13);
        }
        if (file == null || !CodeceptionSettingsManager.getInstance(project).hasMatchedConfigurations(file.getPath())) {
            return null;
        }
        String path = CodeceptionCestTestCreateInfo.getConfigurationFullPath(project, file);
        return StringUtil.isEmpty((String)path) ? project.getBasePath() : path + "/" + directorySuffix;
    }

    @NotNull
    static String suggestTestNamespace(@NotNull Project project, @NotNull VirtualFile file, @NotNull String directorySuffix) {
        if (project == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(14);
        }
        if (file == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(15);
        }
        if (directorySuffix == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(16);
        }
        String string = (String)ObjectUtils.notNull((Object)CodeceptionCestTestCreateInfo.getConfigurationNamespace(project, file, directorySuffix), (Object)"");
        if (string == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    private static String getConfigurationFullPath(@NotNull Project project, @NotNull VirtualFile file) {
        CodeceptionSettingsManager.Configuration configuration;
        if (project == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(18);
        }
        if (file == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(19);
        }
        return (configuration = CodeceptionSettingsManager.getInstance(project).getMatchedConfiguration(file.getPath())) != null ? configuration.getPath() : null;
    }

    @Nullable
    private static String getConfigurationNamespace(@NotNull Project project, @NotNull VirtualFile file, @NotNull String directorySuffix) {
        CodeceptionSettingsManager.Configuration configuration;
        if (project == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(20);
        }
        if (file == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(21);
        }
        if (directorySuffix == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(22);
        }
        return (configuration = CodeceptionSettingsManager.getInstance(project).getMatchedConfiguration(file.getPath())) != null ? (String)ObjectUtils.chooseNotNull((Object)configuration.getSuiteNamespace(directorySuffix), (Object)configuration.getNamespace()) : null;
    }

    @NotNull
    public String getTestMethodText(@NotNull Project project, @NotNull String classFqn, @NotNull String methodName) {
        if (project == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(23);
        }
        if (classFqn == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(24);
        }
        if (methodName == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(25);
        }
        String string = PhpCodeUtil.getCodeTemplate((String)CODECEPTION_CEST_METHOD_TEMPLATE_NAME, (Properties)this.getDefaultProperties(methodName, classFqn), (Project)project);
        if (string == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(26);
        }
        return string;
    }

    public boolean canCreateTestFor(@NotNull PhpClass clazz) {
        if (clazz == null) {
            CodeceptionCestTestCreateInfo.$$$reportNull$$$0(27);
        }
        return !StringUtil.endsWith((CharSequence)clazz.getName(), (CharSequence)TEST_SUFFIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 17, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassName";
                break;
            }
            case 1: 
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeception/CodeceptionCestTestCreateInfo";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNamespace";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNamespace";
                break;
            }
            case 13: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directorySuffix";
                break;
            }
            case 15: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeception/CodeceptionCestTestCreateInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTestName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestTestNamespace";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethodText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTestName";
                break;
            }
            case 1: 
            case 17: 
            case 26: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamespace";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTestDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isConfiguredFolder";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "suggestTestNamespace";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationFullPath";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationNamespace";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodText";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canCreateTestFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 17, 26 -> new IllegalStateException(string);
        };
    }
}

