/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeception;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.phpunit.PhpUnitDirectoriesManager;
import com.jetbrains.php.phpunit.codeGeneration.PhpNewTestDialog;
import com.jetbrains.php.roots.PhpPsrNamespaceRootDetector;
import com.jetbrains.php.roots.PhpSourceRootTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="Codeception", storages={@Storage(value="codeception.xml")})
public final class CodeceptionSettingsManager
implements PersistentStateComponent<State> {
    @NotNull
    private final Project myProject;
    @NotNull
    private State myState;
    @NotNull
    private List<Configuration> myDefaultConfigurations;

    public CodeceptionSettingsManager(@NotNull Project project) {
        if (project == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myProject = project;
        this.myDefaultConfigurations = Collections.singletonList(new Configuration(StringUtil.notNullize((String)project.getBasePath())));
    }

    @NotNull
    public static CodeceptionSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(1);
        }
        CodeceptionSettingsManager codeceptionSettingsManager = (CodeceptionSettingsManager)project.getService(CodeceptionSettingsManager.class);
        if (codeceptionSettingsManager == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(2);
        }
        return codeceptionSettingsManager;
    }

    @NotNull
    public List<Configuration> getConfigurations() {
        List<Configuration> list = !this.myState.getConfigurations().isEmpty() ? this.myState.getConfigurations() : this.myDefaultConfigurations;
        if (list == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<Configuration> getExistedConfigurations() {
        List<Configuration> list = !this.myState.getConfigurations().isEmpty() ? this.myState.getConfigurations() : ContainerUtil.emptyList();
        if (list == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<Configuration> getDefaultConfigurations() {
        List<Configuration> list = this.myDefaultConfigurations;
        if (list == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    @TestOnly
    public void setDefaultConfigurations(@NotNull List<Configuration> configurations) {
        if (configurations == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(6);
        }
        this.myDefaultConfigurations = configurations;
    }

    public boolean hasMatchedConfigurations(@NotNull String path) {
        if (path == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(7);
        }
        return this.getMatchedConfiguration(path) != null;
    }

    @Nullable
    public Configuration getMatchedConfiguration(@NotNull String path) {
        if (path == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(8);
        }
        return (Configuration)ContainerUtil.find(this.getConfigurations(), configuration -> configuration.matches(path));
    }

    public void setConfigurations(@NotNull List<Configuration> configurations) {
        if (configurations == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(9);
        }
        this.myState.setConfigurations(configurations);
    }

    public void updateConfigurations(@NotNull List<Configuration> configurations) {
        if (configurations == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(10);
        }
        List<Configuration> uniqConfigurations = configurations.stream().distinct().toList();
        this.setConfigurations(uniqConfigurations);
        PhpPsrNamespaceRootDetector.addSourceRoots((Project)this.myProject, CodeceptionSettingsManager.getTestRoots(this.myProject, uniqConfigurations));
    }

    @NotNull
    private static List<PhpSourceRootTemplate> getTestRoots(@NotNull Project project, @NotNull List<Configuration> configurations) {
        if (project == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(11);
        }
        if (configurations == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(12);
        }
        ArrayList<PhpSourceRootTemplate> roots = new ArrayList<PhpSourceRootTemplate>();
        Set filePaths = PhpNewTestDialog.getExistedSourceRootPaths((Project)project);
        for (Configuration configuration : configurations) {
            if (PhpUnitDirectoriesManager.hasDirectoryPath((Collection)filePaths, (String)configuration.getPath())) continue;
            roots.add(PhpSourceRootTemplate.psr4((String)configuration.getPath(), (String)"", (boolean)true));
        }
        ArrayList<PhpSourceRootTemplate> arrayList = roots;
        if (arrayList == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(14);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            CodeceptionSettingsManager.$$$reportNull$$$0(15);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeception/CodeceptionSettingsManager";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeception/CodeceptionSettingsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistedConfigurations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigurations";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultConfigurations";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasMatchedConfigurations";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMatchedConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurations";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateConfigurations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTestRoots";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 13, 14 -> new IllegalStateException(string);
        };
    }

    static class State {
        @NotNull
        private List<Configuration> myConfigurations = new ArrayList<Configuration>();

        State() {
        }

        @NotNull
        public List<Configuration> getConfigurations() {
            List<Configuration> list = this.myConfigurations;
            if (list == null) {
                State.$$$reportNull$$$0(0);
            }
            return list;
        }

        public void setConfigurations(@NotNull List<Configuration> configurations) {
            if (configurations == null) {
                State.$$$reportNull$$$0(1);
            }
            this.myConfigurations = configurations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.myConfigurations.equals(state.myConfigurations);
        }

        public int hashCode() {
            return Objects.hash(this.myConfigurations);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/codeception/CodeceptionSettingsManager$State";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurations";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/codeception/CodeceptionSettingsManager$State";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setConfigurations";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class Configuration {
        @NotNull
        static final String DEFAULT_DIRECTORY = "tests";
        @NotNull
        private String myPath;
        @NotNull
        private String myNamespace;
        @NotNull
        public final Map<String, String> mySuiteNamespaces;

        Configuration() {
            this("");
        }

        @ApiStatus.Internal
        public Configuration(@NotNull String configurationDirectory) {
            if (configurationDirectory == null) {
                Configuration.$$$reportNull$$$0(0);
            }
            this.mySuiteNamespaces = new HashMap<String, String>();
            this.myPath = Configuration.concatPaths(configurationDirectory, DEFAULT_DIRECTORY);
            this.myNamespace = "";
        }

        public void setPath(@Nullable String path) {
            this.myPath = StringUtil.isEmpty((String)path) ? DEFAULT_DIRECTORY : FileUtil.toCanonicalPath((String)path);
        }

        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                Configuration.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void setNamespace(@Nullable String namespace) {
            this.myNamespace = (String)ObjectUtils.notNull((Object)namespace, (Object)"");
        }

        @NotNull
        public String getNamespace() {
            String string = this.myNamespace;
            if (string == null) {
                Configuration.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void setSuiteNamespace(@NotNull String suite, @NotNull String namespace) {
            if (suite == null) {
                Configuration.$$$reportNull$$$0(3);
            }
            if (namespace == null) {
                Configuration.$$$reportNull$$$0(4);
            }
            this.mySuiteNamespaces.put(suite, namespace);
        }

        @Nullable
        public String getSuiteNamespace(@NotNull String suite) {
            if (suite == null) {
                Configuration.$$$reportNull$$$0(5);
            }
            return this.mySuiteNamespaces.get(suite);
        }

        public boolean matches(@NotNull String path) {
            if (path == null) {
                Configuration.$$$reportNull$$$0(6);
            }
            return FileUtil.pathsEqual((String)this.myPath, (String)path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Configuration that = (Configuration)o;
            return this.myPath.equals(that.myPath) && this.myNamespace.equals(that.myNamespace) && this.mySuiteNamespaces.equals(that.mySuiteNamespaces);
        }

        public int hashCode() {
            return Objects.hash(this.myPath, this.myNamespace, this.mySuiteNamespaces);
        }

        @NotNull
        static String concatPaths(@Nullable String path, @NotNull String directoryName) {
            if (directoryName == null) {
                Configuration.$$$reportNull$$$0(7);
            }
            if (StringUtil.isEmpty((String)path)) {
                String string = directoryName;
                if (string == null) {
                    Configuration.$$$reportNull$$$0(8);
                }
                return string;
            }
            Object object = directoryName.isEmpty() ? path : path + "/" + directoryName;
            if (object == null) {
                Configuration.$$$reportNull$$$0(9);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationDirectory";
                    break;
                }
                case 1: 
                case 2: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/codeception/CodeceptionSettingsManager$Configuration";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suite";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directoryName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/codeception/CodeceptionSettingsManager$Configuration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespace";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "concatPaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 8: 
                case 9: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setSuiteNamespace";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuiteNamespace";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "concatPaths";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 8, 9 -> new IllegalStateException(string);
            };
        }
    }
}

