/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.docker.compose;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class PhpDockerComposePrefixProcessor
implements Consumer<List<Pair<String, Key>>> {
    private static final String DELIMITER = "  | ";
    @NotNull
    private final BiConsumer<? super String, ? super Key> myConsumer;
    @NotNull
    private final String myComposeServiceName;

    public PhpDockerComposePrefixProcessor(@NotNull String composeServiceName, @NotNull BiConsumer<? super String, ? super Key> consumer) {
        if (composeServiceName == null) {
            PhpDockerComposePrefixProcessor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PhpDockerComposePrefixProcessor.$$$reportNull$$$0(1);
        }
        this.myComposeServiceName = composeServiceName;
        this.myConsumer = consumer;
    }

    @Override
    public void accept(List<Pair<String, Key>> chunks) {
        if (chunks.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        boolean startsWithServiceName = false;
        int delimiterIndex = -1;
        Iterator<Pair<String, Key>> iterator = chunks.iterator();
        Pair<String, Key> currentChunk = null;
        while (iterator.hasNext()) {
            currentChunk = iterator.next();
            sb.append((String)currentChunk.getFirst());
            if (sb.length() < this.myComposeServiceName.length()) continue;
            boolean bl = startsWithServiceName = startsWithServiceName || StringUtil.startsWith((CharSequence)sb, (CharSequence)this.myComposeServiceName);
            if (startsWithServiceName && (delimiterIndex = sb.indexOf(DELIMITER, this.myComposeServiceName.length())) < 0) continue;
        }
        if (delimiterIndex < 0) {
            for (Pair<String, Key> chunk : chunks) {
                this.myConsumer.accept((String)chunk.getFirst(), (Key)chunk.getSecond());
            }
            return;
        }
        this.processChunksWithoutPrefix(iterator, sb.substring(delimiterIndex + DELIMITER.length()), (Key)currentChunk.getSecond());
    }

    private void processChunksWithoutPrefix(Iterator<Pair<String, Key>> remainingChunks, String chunksWithoutPrefixText, Key chunksWithoutPrefixAttribute) {
        if (!chunksWithoutPrefixText.isEmpty()) {
            this.myConsumer.accept(chunksWithoutPrefixText, (Key)chunksWithoutPrefixAttribute);
        }
        while (remainingChunks.hasNext()) {
            Pair<String, Key> chunk = remainingChunks.next();
            this.myConsumer.accept((String)chunk.getFirst(), (Key)chunk.getSecond());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "composeServiceName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/remote/docker/compose/PhpDockerComposePrefixProcessor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

