/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.docker.compose;

import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.RestartPolicy;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.compose.cli.DockerComposeCliCmd;
import com.intellij.docker.compose.cli.DockerComposeCliSubCmd;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeExecCmd;
import com.intellij.docker.compose.cli.DockerComposeUpCmd;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeFileConfigurationProvider;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceExecCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceUpCmd;
import com.intellij.docker.remote.DockerComposeContainerUtil;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.compose.process.DockerComposeProcessUtil;
import com.intellij.docker.remote.compose.run.configuration.DockerComposeSettings;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.remoteRunRuntime.WrappedInternalServerErrorException;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.ColoredRemoteProcessHandler;
import com.intellij.remote.RemoteProcess;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.remote.PhpRemoteProcessRunner;
import com.jetbrains.php.remote.PhpRemoteTransfer;
import com.jetbrains.php.remote.docker.PhpDockerHelpersManager;
import com.jetbrains.php.remote.docker.PhpDockerProcessUtil;
import com.jetbrains.php.remote.docker.compose.PhpDockerComposePrefixProcessor;
import com.jetbrains.php.remote.docker.compose.PhpDockerComposeStartCommand;
import com.jetbrains.php.remote.docker.compose.PhpDockerComposeTypeData;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkTypeData;
import com.jetbrains.php.run.PhpExternalExecutionException;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDockerComposeRemoteProcessRunner
extends PhpRemoteProcessRunner {
    private static final Logger LOG = Logger.getInstance(PhpDockerComposeRemoteProcessRunner.class);
    private static final PhpDockerComposeRemoteProcessRunner ourInstance = new PhpDockerComposeRemoteProcessRunner();
    private final Set<String> myContainersWithHelpers = new HashSet<String>();

    @NotNull
    public static PhpRemoteProcessRunner getInstance() {
        PhpDockerComposeRemoteProcessRunner phpDockerComposeRemoteProcessRunner = ourInstance;
        if (phpDockerComposeRemoteProcessRunner == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(0);
        }
        return phpDockerComposeRemoteProcessRunner;
    }

    @NotNull
    public ProcessOutput getProcessOutput(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, @NotNull String title, @Nullable JComponent component) throws ExecutionException, InterruptedException {
        ProcessOutput processOutput;
        DockerComposeCredentialsHolder docker;
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(1);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(3);
        }
        if (title == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(4);
        }
        if ((docker = PhpDockerProcessUtil.tryGetDockerCredentials(sdkData)) == null) {
            throw new IllegalArgumentException();
        }
        try {
            KillableColoredProcessHandler processHandler;
            RemoteDockerRuntime dockerRuntime = PhpDockerProcessUtil.createDockerRuntime(docker, project);
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            PhpRemoteSdkTypeData data = sdkData.getTypeData();
            ComposeServiceRunCmd cmd = data != null && ((PhpDockerComposeTypeData)data).getCommand().equals((Object)PhpDockerComposeStartCommand.EXEC) ? serviceClient.execServiceCmd() : serviceClient.runServiceCmd();
            PhpDockerComposeRemoteProcessRunner.fillSettings(commandLine, docker, cmd, true);
            cmd.withSharedVolume(PhpDockerHelpersManager.getHelpersContainerSharedVolume(dockerRuntime));
            if (cmd instanceof ComposeServiceRunCmd) {
                processHandler = ((ComposeServiceRunCmd)cmd.withRestartPolicy((RestartPolicy)RestartPolicy.noRestart())).withRemove(true).execute();
            } else {
                DockerAgentContainer container = DockerComposeContainerUtil.findContainerByServiceName((Project)project, (RemoteDockerRuntime)dockerRuntime, (DockerComposeCredentialsHolder)docker, (boolean)true);
                if (container == null) {
                    throw new PhpExternalExecutionException(PhpBundle.message((String)"docker.compose.failed.to.start.container", (Object[])new Object[0]));
                }
                String remotePath = sdkData.getHelpersPath();
                PhpDockerComposeRemoteProcessRunner.copyHelpers(container, remotePath);
                processHandler = ((ComposeServiceExecCmd)((ComposeServiceExecCmd)((ComposeServiceExecCmd)cmd).withCommand((String[])commandLine.getCommandLineList(commandLine.getExePath()).toArray(String[]::new))).withSubcommandOptions(Collections.singletonList("-T"))).execute();
            }
            processOutput = new CapturingProcessRunner((BaseProcessHandler)processHandler).runProcess();
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        catch (UndeclaredThrowableException e) {
            throw (UndeclaredThrowableException)DockerUtil.propagateRuntimeExceptionCause((RuntimeException)e, InterruptedException.class);
        }
        if (processOutput == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(5);
        }
        return processOutput;
    }

    @Nullable
    public String getAdditionalCommandTitle(@NotNull GeneralCommandLine commandLine) {
        DockerComposeSettings data;
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(6);
        }
        if ((data = (DockerComposeSettings)commandLine.getUserData(DockerComposeSettings.KEY)) == null) {
            return null;
        }
        return data.getCommandLine();
    }

    private static void copyScratches(DockerAgentContainer container, String remotePath) {
        container.copyArchiveToContainer(PathUtil.getParentPath((String)remotePath), ScratchFileService.getInstance().getRootPath((RootType)ScratchRootType.getInstance()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyHelpers(DockerAgentContainer container, String remotePath) throws IOException {
        File tempDirectory = FileUtil.createTempDirectory((String)"phpstorm-helpers-docker-compose", (String)"", (boolean)false);
        try {
            File newHelpersDir = new File(tempDirectory.getPath() + "/" + PathUtil.getFileName((String)remotePath));
            FileUtil.copyDir((File)new File(PhpRemoteTransfer.getHelpersRoot().getPath()), (File)newHelpersDir);
            container.copyArchiveToContainer(PathUtil.getParentPath((String)remotePath), newHelpersDir.getPath());
        }
        finally {
            FileUtil.delete((File)tempDirectory);
        }
    }

    public static void fillSettings(@NotNull GeneralCommandLine commandLine, @NotNull DockerComposeCredentialsHolder docker, @NotNull AbstractServiceCmd<?> service, boolean overwriteEntrypoint) {
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(7);
        }
        if (docker == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(8);
        }
        if (service == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(9);
        }
        service.withConfigurationPath(docker.getComposeFilePaths());
        service.withServiceName(docker.getComposeServiceName());
        File workingDir = commandLine.getWorkDirectory();
        if (workingDir != null) {
            service.withWorkingDir(DockerUtil.toUnixPath((String)workingDir.getPath()));
        }
        ArrayList<String> params = new ArrayList<String>();
        if (overwriteEntrypoint) {
            service.withEntrypoint(new String[]{commandLine.getExePath()});
        } else {
            params.add(commandLine.getExePath());
        }
        params.addAll(commandLine.getParametersList().getList());
        service.withCommand(ArrayUtil.toStringArray(params));
        HashMap<String, String> newEnvs = new HashMap<String, String>();
        newEnvs.put("JETBRAINS_REMOTE_RUN", "1");
        newEnvs.putAll(commandLine.getEnvironment());
        service.withEnvironment(newEnvs);
        service.withEnvs((Map)DockerComposeContainerUtil.getEnvs((DockerComposeCredentialsHolder)docker));
    }

    @NotNull
    public Process getRemoteProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(10);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(11);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(12);
        }
        if (additionalMappings == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(13);
        }
        PhpDockerComposeStartCommand command = PhpDockerComposeRemoteProcessRunner.getDockerComposeCommand(sdkData);
        return this.startRemoteProcess(project, sdkData, commandLine, true, command, false, additionalMappings);
    }

    @NotNull
    public static PhpDockerComposeStartCommand getDockerComposeCommand(@NotNull PhpRemoteSdkAdditionalData sdkData) {
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(14);
        }
        if (Registry.is((String)"php.use.docker.compose.up")) {
            PhpDockerComposeStartCommand phpDockerComposeStartCommand = PhpDockerComposeStartCommand.UP;
            if (phpDockerComposeStartCommand == null) {
                PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(15);
            }
            return phpDockerComposeStartCommand;
        }
        PhpRemoteSdkTypeData typeData = sdkData.getTypeData();
        PhpDockerComposeStartCommand phpDockerComposeStartCommand = typeData instanceof PhpDockerComposeTypeData ? ((PhpDockerComposeTypeData)typeData).getCommand() : PhpDockerComposeStartCommand.RUN;
        if (phpDockerComposeStartCommand == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(16);
        }
        return phpDockerComposeStartCommand;
    }

    public boolean canRunBackgroundProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData) {
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(17);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(18);
        }
        return false;
    }

    @NotNull
    public Process getRemoteBackgroundProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(19);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(20);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(21);
        }
        if (additionalMappings == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(22);
        }
        return this.startRemoteProcess(project, sdkData, commandLine, false, PhpDockerComposeRemoteProcessRunner.getDockerComposeCommand(sdkData), true, additionalMappings);
    }

    @NotNull
    private Process startRemoteProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData sdkData, @NotNull GeneralCommandLine commandLine, boolean withHelpers, @NotNull PhpDockerComposeStartCommand command, boolean preventSavingAllDocuments, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        Process process;
        DockerComposeCredentialsHolder docker;
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(23);
        }
        if (sdkData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(24);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(25);
        }
        if (command == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(26);
        }
        if (additionalMappings == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(27);
        }
        if ((docker = PhpDockerProcessUtil.tryGetDockerCredentials(sdkData)) == null) {
            throw new IllegalArgumentException();
        }
        try {
            RemoteDockerRuntime runtime = PhpDockerProcessUtil.createDockerRuntime(docker, project);
            AbstractServiceCmd<?> cmd = this.buildDockerComposeCommand(project, runtime, docker, commandLine, sdkData, withHelpers, command, preventSavingAllDocuments, additionalMappings);
            KillableColoredProcessHandler processHandler = cmd.execute();
            LOG.debug("Executing: " + processHandler.getCommandLine());
            process = processHandler.getProcess();
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        if (process == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(28);
        }
        return process;
    }

    @NotNull
    private AbstractServiceCmd<?> buildDockerComposeCommand(@NotNull Project project, @NotNull RemoteDockerRuntime dockerRuntime, @NotNull DockerComposeCredentialsHolder docker, @NotNull GeneralCommandLine commandLine, PhpRemoteSdkAdditionalData sdkData, boolean withHelpers, @NotNull PhpDockerComposeStartCommand command, boolean preventSavingAllDocuments, // Could not load outer class - annotation placement on inner may be incorrect
    PathMappingSettings.PathMapping @NotNull [] additionalMappings) throws IOException, ServerRuntimeException, ExecutionException {
        DockerComposeCliCmd composeCommandOptions;
        DockerComposeCliSubCmd runConfigCmd;
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(29);
        }
        if (dockerRuntime == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(30);
        }
        if (docker == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(31);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(32);
        }
        if (command == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(33);
        }
        if (additionalMappings == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(34);
        }
        if ((command = PhpDockerComposeRemoteProcessRunner.updateCommandTypeFromRunConfig(command, runConfigCmd = (composeCommandOptions = DockerComposeProcessUtil.getComposeCommandOptions((GeneralCommandLine)commandLine)).getSubCmd())) == PhpDockerComposeStartCommand.EXEC) {
            DockerAgentContainer container = DockerComposeContainerUtil.findContainerByServiceName((Project)project, (RemoteDockerRuntime)dockerRuntime, (DockerComposeCredentialsHolder)docker, (boolean)true);
            if (container == null) {
                throw new PhpExternalExecutionException(PhpBundle.message((String)"docker.compose.failed.to.start.container", (Object[])new Object[0]));
            }
            ComposeServiceExecCmd cmd = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime).execServiceCmd();
            Ref version = new Ref(null);
            ApplicationManager.getApplication().executeOnPooledThread(() -> ReadAction.nonBlocking(() -> version.set((Object)PhpDockerComposeRemoteProcessRunner.getComposeVersion((DockerComposeCredentialsHolder)ObjectUtils.tryCast((Object)sdkData.connectionCredentials().getCredentials(), DockerComposeCredentialsHolder.class)))).executeSynchronously());
            if (VersionComparatorUtil.compare((String)((String)version.get()), (String)"3.6") >= 0) {
                cmd.withSetupWorkingDirectory(true);
            }
            SmartList subcommand = new SmartList();
            if (commandLine.getUserData(QualityToolProcessCreator.NO_PTY) == null) {
                cmd.withPtyOptions(DockerComposeCliUtil.defaultPtyOptionsByNoPty((Boolean)SystemInfo.isWindows));
            }
            subcommand.add("-T");
            int index = DockerComposeContainerUtil.getContainerIndex((Map)container.getContainerLabels(), (int)1);
            if (index != 1) {
                subcommand.add("--index=" + index);
            }
            PhpDockerComposeRemoteProcessRunner.fillRunconfigOptions(runConfigCmd, (List<String>)subcommand);
            if (!subcommand.isEmpty()) {
                cmd.withSubcommandOptions((List)subcommand);
            }
            PhpDockerComposeRemoteProcessRunner.fillSettings(commandLine, docker, cmd, false);
            String containerId = container.getContainerId();
            String remotePath = sdkData.getHelpersPath();
            if (withHelpers && !this.myContainersWithHelpers.contains(containerId)) {
                PhpDockerComposeRemoteProcessRunner.copyHelpers(container, remotePath);
                this.myContainersWithHelpers.add(containerId);
            }
            if (sdkData.getScratchesPath() != null && Objects.equals(cmd.getWorkingDir(), sdkData.getScratchesPath()) && !PhpDockerProcessUtil.isDockerSsh(dockerRuntime)) {
                PhpDockerComposeRemoteProcessRunner.copyScratches(container, remotePath);
            }
            for (PathMappingSettings.PathMapping mapping : additionalMappings) {
                container.copyArchiveToContainer(PathUtil.getParentPath((String)remotePath), FileUtil.toSystemDependentName((String)mapping.getLocalRoot()));
            }
            if (preventSavingAllDocuments) {
                cmd.withSaveAllDocuments(false);
            }
            ComposeServiceExecCmd composeServiceExecCmd = cmd;
            if (composeServiceExecCmd == null) {
                PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(35);
            }
            return composeServiceExecCmd;
        }
        if (command == PhpDockerComposeStartCommand.RUN) {
            ComposeServiceRunCmd cmd = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime).runServiceCmd();
            PhpDockerComposeRemoteProcessRunner.configureUpOrRunService(dockerRuntime, docker, commandLine, withHelpers, additionalMappings, cmd, sdkData);
            SmartList subcommand = new SmartList();
            PhpDockerComposeRemoteProcessRunner.fillRunconfigOptions(runConfigCmd, (List<String>)subcommand);
            if (!subcommand.isEmpty()) {
                cmd.withSubcommandOptions((List)subcommand);
            }
            if (preventSavingAllDocuments) {
                cmd.withSaveAllDocuments(false);
            }
            if (commandLine.getUserData(QualityToolProcessCreator.NO_PTY) == null) {
                cmd.withPtyOptions(DockerComposeCliUtil.defaultPtyOptionsByNoPty((Boolean)SystemInfo.isWindows));
            }
            ((ComposeServiceRunCmd)cmd.withRestartPolicy((RestartPolicy)RestartPolicy.noRestart())).withNoDeps(false).withRemove(true);
            ComposeServiceRunCmd composeServiceRunCmd = cmd;
            if (composeServiceRunCmd == null) {
                PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(36);
            }
            return composeServiceRunCmd;
        }
        ComposeServiceUpCmd cmd = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime).upServicesCmd();
        PhpDockerComposeRemoteProcessRunner.configureUpOrRunService(dockerRuntime, docker, commandLine, withHelpers, additionalMappings, cmd, sdkData);
        SmartList subcommand = new SmartList();
        PhpDockerComposeRemoteProcessRunner.fillRunconfigOptions(runConfigCmd, (List<String>)subcommand);
        if (!subcommand.isEmpty()) {
            cmd.withSubcommandOptions((List)subcommand);
        }
        ComposeServiceUpCmd composeServiceUpCmd = cmd;
        if (composeServiceUpCmd == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(37);
        }
        return composeServiceUpCmd;
    }

    private static PhpDockerComposeStartCommand updateCommandTypeFromRunConfig(@NotNull PhpDockerComposeStartCommand command, DockerComposeCliSubCmd runConfigCmd) {
        if (command == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(38);
        }
        if (runConfigCmd != null) {
            command = runConfigCmd instanceof DockerComposeUpCmd ? PhpDockerComposeStartCommand.UP : (runConfigCmd instanceof DockerComposeExecCmd ? PhpDockerComposeStartCommand.EXEC : PhpDockerComposeStartCommand.RUN);
        }
        return command;
    }

    private static void fillRunconfigOptions(@Nullable DockerComposeCliSubCmd runConfigCmd, List<String> subcommand) {
        if (runConfigCmd == null) {
            return;
        }
        runConfigCmd.getOptions().forEach(i -> {
            subcommand.add((String)i.getFirst());
            if (i.getSecond() != null) {
                subcommand.add((String)i.getSecond());
            }
        });
    }

    @Nullable
    public static String getComposeVersion(@Nullable DockerComposeCredentialsHolder dockerComposeCredentialsHolder) {
        if (dockerComposeCredentialsHolder == null) {
            return null;
        }
        try {
            DockerComposeConfiguration configuration = DockerComposeFileConfigurationProvider.getInstance().getConfigFor(DockerUtils.getDockerCloudConfiguration((String)dockerComposeCredentialsHolder.getAccountName()), dockerComposeCredentialsHolder.getComposeFilePaths());
            if (configuration instanceof DockerComposeConfigurationV2) {
                return ((DockerComposeConfigurationV2)configuration).getVersion();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static void configureUpOrRunService(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull DockerComposeCredentialsHolder docker, @NotNull GeneralCommandLine commandLine, boolean withHelpers, // Could not load outer class - annotation placement on inner may be incorrect
    PathMappingSettings.PathMapping @NotNull [] additionalMappings, @NotNull AbstractServiceCmd<?> cmd, PhpRemoteSdkAdditionalData data) throws IOException, ServerRuntimeException {
        if (dockerRuntime == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(39);
        }
        if (docker == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(40);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(41);
        }
        if (cmd == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(42);
        }
        if (additionalMappings == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(43);
        }
        PhpDockerComposeRemoteProcessRunner.fillSettings(commandLine, docker, cmd, true);
        if (withHelpers) {
            cmd.withSharedVolume(PhpDockerHelpersManager.getHelpersContainerSharedVolume(dockerRuntime));
        }
        VolumesBuilder volumesBuilder = VolumesBuilder.builder();
        for (PathMappingSettings.PathMapping mapping : additionalMappings) {
            volumesBuilder.addBoundVolume(mapping.getRemoteRoot(), FileUtil.toSystemDependentName((String)mapping.getLocalRoot()));
        }
        if (data.getScratchesPath() != null && Objects.equals(cmd.getWorkingDir(), data.getScratchesPath()) && !PhpDockerProcessUtil.isDockerSsh(dockerRuntime)) {
            volumesBuilder.addBoundVolume(data.getScratchesPath(), ScratchFileService.getInstance().getRootPath((RootType)ScratchRootType.getInstance()));
        }
        cmd.withVolumes(volumesBuilder.build());
    }

    @NotNull
    public ProcessHandler createRemoteProcessHandler(@NotNull Process process, @NotNull String commandTitle, @NotNull Charset charset, @NotNull PhpRemoteSdkAdditionalData remoteData, boolean verbose) {
        if (process == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(44);
        }
        if (commandTitle == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(45);
        }
        if (charset == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(46);
        }
        if (remoteData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(47);
        }
        if (!verbose) {
            return PhpDockerComposeRemoteProcessRunner.createNotVerboseHandler(process, commandTitle, charset, remoteData);
        }
        ProcessHandler processHandler = super.createRemoteProcessHandler(process, commandTitle, charset, remoteData, true);
        if (processHandler == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(48);
        }
        return processHandler;
    }

    @NotNull
    public Process startRemoteProcessWithoutHelpers(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data, @NotNull GeneralCommandLine commandLine, boolean withPty) throws ExecutionException {
        if (project == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(49);
        }
        if (data == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(50);
        }
        if (commandLine == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(51);
        }
        PhpDockerComposeStartCommand command = PhpDockerComposeRemoteProcessRunner.getDockerComposeCommand(data);
        return this.startRemoteProcess(project, data, commandLine, false, command, false, new PathMappingSettings.PathMapping[0]);
    }

    @NotNull
    private static ProcessHandler createNotVerboseHandler(@NotNull Process process, @NotNull String commandTitle, @NotNull Charset charset, @NotNull PhpRemoteSdkAdditionalData remoteData) {
        DockerComposeCredentialsHolder credentials;
        String composeServiceName;
        if (process == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(52);
        }
        if (commandTitle == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(53);
        }
        if (charset == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(54);
        }
        if (remoteData == null) {
            PhpDockerComposeRemoteProcessRunner.$$$reportNull$$$0(55);
        }
        String string = composeServiceName = (credentials = (DockerComposeCredentialsHolder)ObjectUtils.tryCast((Object)remoteData.connectionCredentials().getCredentials(), DockerComposeCredentialsHolder.class)) != null ? credentials.getComposeServiceName() : null;
        if (process instanceof RemoteProcess) {
            return new MyColoredRemoteProcessHandler((RemoteProcess)process, commandTitle, charset, composeServiceName);
        }
        return new MyColoredKillableRemoteProcessHandler(process, commandTitle, charset, composeServiceName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 49, 50, 51, 52, 53, 54, 55 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/docker/compose/PhpDockerComposeRemoteProcessRunner";
                break;
            }
            case 1: 
            case 10: 
            case 17: 
            case 19: 
            case 23: 
            case 29: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 12: 
            case 21: 
            case 25: 
            case 32: 
            case 41: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: 
            case 31: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docker";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 13: 
            case 22: 
            case 27: 
            case 34: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalMappings";
                break;
            }
            case 26: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 30: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 44: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 45: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandTitle";
                break;
            }
            case 46: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteData";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/docker/compose/PhpDockerComposeRemoteProcessRunner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerComposeCommand";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "startRemoteProcess";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDockerComposeCommand";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalCommandTitle";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillSettings";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteProcess";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDockerComposeCommand";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canRunBackgroundProcess";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteBackgroundProcess";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcess";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "buildDockerComposeCommand";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "updateCommandTypeFromRunConfig";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "configureUpOrRunService";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteProcessHandler";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcessWithoutHelpers";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createNotVerboseHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 49, 50, 51, 52, 53, 54, 55 -> new IllegalArgumentException(string);
        };
    }

    private static class MyColoredRemoteProcessHandler
    extends ColoredRemoteProcessHandler<RemoteProcess>
    implements AnsiEscapeDecoder.ColoredChunksAcceptor {
        private final PhpDockerComposePrefixProcessor myProcessor;

        MyColoredRemoteProcessHandler(@NotNull RemoteProcess process, String commandLine, Charset charset, String composeServiceName) {
            if (process == null) {
                MyColoredRemoteProcessHandler.$$$reportNull$$$0(0);
            }
            super(process, commandLine, charset);
            this.myProcessor = new PhpDockerComposePrefixProcessor(composeServiceName, (x$0, x$1) -> super.coloredTextAvailable(x$0, x$1));
        }

        public void coloredChunksAvailable(@NotNull List<Pair<String, Key>> chunks) {
            if (chunks == null) {
                MyColoredRemoteProcessHandler.$$$reportNull$$$0(1);
            }
            this.myProcessor.accept(chunks);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunks";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/remote/docker/compose/PhpDockerComposeRemoteProcessRunner$MyColoredRemoteProcessHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coloredChunksAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyColoredKillableRemoteProcessHandler
    extends KillableColoredProcessHandler
    implements AnsiEscapeDecoder.ColoredChunksAcceptor {
        private final PhpDockerComposePrefixProcessor myProcessor;

        MyColoredKillableRemoteProcessHandler(@NotNull Process process, String commandLine, Charset charset, String composeServiceName) {
            if (process == null) {
                MyColoredKillableRemoteProcessHandler.$$$reportNull$$$0(0);
            }
            super(process, commandLine, charset);
            this.myProcessor = new PhpDockerComposePrefixProcessor(composeServiceName, (x$0, x$1) -> super.coloredTextAvailable(x$0, x$1));
        }

        public void coloredChunksAvailable(@NotNull List<Pair<String, Key>> chunks) {
            if (chunks == null) {
                MyColoredKillableRemoteProcessHandler.$$$reportNull$$$0(1);
            }
            this.myProcessor.accept(chunks);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunks";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/remote/docker/compose/PhpDockerComposeRemoteProcessRunner$MyColoredKillableRemoteProcessHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coloredChunksAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

