/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.jetbrains.lang.makefile.MakefileLangBundle;
import com.jetbrains.lang.makefile.MakefileTargetReference;
import com.jetbrains.lang.makefile.UtilsKt;
import com.jetbrains.lang.makefile.inspections.CreateRuleFix;
import com.jetbrains.lang.makefile.psi.MakefilePrerequisite;
import com.jetbrains.lang.makefile.psi.MakefileTarget;
import com.jetbrains.lang.makefile.psi.MakefileTargetLine;
import com.jetbrains.lang.makefile.psi.MakefileVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/lang/makefile/inspections/MakefileUnresolvedPrerequisiteInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.makefile"})
public final class MakefileUnresolvedPrerequisiteInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new MakefileVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitPrerequisite(MakefilePrerequisite prerequisite) {
                boolean bl;
                List<MakefileTarget> targets;
                MakefileTargetLine targetLine;
                block15: {
                    Intrinsics.checkNotNullParameter((Object)prerequisite, (String)"prerequisite");
                    Regex regex = new Regex("\\$\\((.*)\\)");
                    String string = prerequisite.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (regex.matches((CharSequence)string)) {
                        return;
                    }
                    MakefileTargetLine makefileTargetLine = UtilsKt.findTargetLine(prerequisite);
                    if (makefileTargetLine == null) {
                        return;
                    }
                    targetLine = makefileTargetLine;
                    List<MakefileTarget> list = targetLine.getTargets().getTargetList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getTargetList(...)");
                    targets = list;
                    Iterable $this$any$iv = targets;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            MakefileTarget it = (MakefileTarget)element$iv;
                            boolean bl2 = false;
                            if (!it.isPatternTarget()) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (bl && prerequisite.textContains('%')) {
                    return;
                }
                MakefileTarget makefileTarget = (MakefileTarget)CollectionsKt.firstOrNull(targets);
                boolean bl3 = makefileTarget != null ? !makefileTarget.isSpecialTarget() : false;
                if (bl3 && targetLine.getTargetPattern() == null) {
                    void $this$forEach$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    boolean bl4;
                    block16: {
                        PsiReference[] psiReferenceArray = prerequisite.getReferences();
                        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                        Object[] $this$any$iv = psiReferenceArray;
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            PsiReference it = (PsiReference)element$iv;
                            boolean bl5 = false;
                            if (!(it instanceof MakefileTargetReference && !(((MakefileTargetReference)it).multiResolve(false).length == 0))) continue;
                            bl4 = true;
                            break block16;
                        }
                        bl4 = false;
                    }
                    boolean targetReferences = bl4;
                    boolean fileReferenceResolved = false;
                    TextRange unresolvedFile = null;
                    PsiReference[] psiReferenceArray = prerequisite.getReferences();
                    Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                    Object $this$filterIsInstance$iv = psiReferenceArray;
                    boolean $i$f$filterIsInstance = false;
                    Object[] element$iv = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof FileReference)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (T element$iv2 : $this$forEach$iv) {
                        FileReference it = (FileReference)element$iv2;
                        boolean bl6 = false;
                        if (it.resolve() == null) {
                            if (targetReferences) continue;
                            TextRange textRange = unresolvedFile;
                            if (textRange == null || (textRange = textRange.union(it.getRangeInElement())) == null) {
                                TextRange textRange2 = it.getRangeInElement();
                                textRange = textRange2;
                                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getRangeInElement(...)");
                            }
                            unresolvedFile = textRange;
                            continue;
                        }
                        fileReferenceResolved = true;
                    }
                    if (!targetReferences && !fileReferenceResolved) {
                        CreateRuleFix fix = new CreateRuleFix();
                        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                        this.$holder.registerProblem((PsiElement)prerequisite, MakefileLangBundle.message("inspection.message.unresolved.prerequisite", new Object[0]), localQuickFixArray);
                    } else if (unresolvedFile != null) {
                        this.$holder.registerProblem((PsiElement)prerequisite, unresolvedFile, MakefileLangBundle.message("inspection.message.file.not.found", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }
}

