/*
 * Decompiled with CFR 0.152.
 */
package com.pestphp.pest.features.parallel;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.pestphp.pest.PestBundle;
import com.pestphp.pest.configuration.PestRerunProfile;
import com.pestphp.pest.configuration.PestRunConfiguration;
import com.pestphp.pest.features.parallel.PestParallelProgramRunnerKt;
import com.pestphp.pest.statistics.PestUsagesCollector;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\bH\u0016J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013\u00a8\u0006\u0015"}, d2={"Lcom/pestphp/pest/features/parallel/PestParallelProgramRunner;", "Lcom/intellij/execution/runners/GenericProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "<init>", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "doExecute", "Lcom/intellij/execution/ui/RunContentDescriptor;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getRunnerId", "getArguments", "", "Companion", "intellij.pest"})
public final class PestParallelProgramRunner
extends GenericProgramRunner<RunnerSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String RUNNER_ID = "PestParallelRunner";

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return Intrinsics.areEqual((Object)executorId, (Object)"PestParallelTestExecutor") && profile instanceof PestRunConfiguration;
    }

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
        ExecutionResult executionResult;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PestUsagesCollector.INSTANCE.logParallelTestExecution(project);
        if (environment.getRunProfile() instanceof PestRerunProfile) {
            v1 = state.execute(environment.getExecutor(), (ProgramRunner)this);
        } else {
            RunProfile runProfile = environment.getRunProfile();
            PestRunConfiguration pestRunConfiguration = runProfile instanceof PestRunConfiguration ? (PestRunConfiguration)runProfile : null;
            if (pestRunConfiguration == null) {
                throw new ExecutionException(PestBundle.message("PEST_PARALLEL_IS_NOT_SUPPORTED_FOR_SELECTED_RUN_PROFILE", new Object[0]));
            }
            PestRunConfiguration runConfiguration = pestRunConfiguration;
            PhpCommandSettings command = PestParallelProgramRunnerKt.createPestParallelCommand(runConfiguration);
            RunProfileState runProfileState = runConfiguration.checkAndGetState(environment, command);
            v1 = executionResult = runProfileState != null ? runProfileState.execute(environment.getExecutor(), (ProgramRunner)this) : null;
        }
        if (executionResult == null) {
            throw new ExecutionException(PhpBundle.message((String)"execution.result.is.null", (Object[])new Object[0]));
        }
        RunContentDescriptor contentDescriptor = new RunContentBuilder(executionResult, environment).showRunContent(environment.getContentToReuse());
        Intrinsics.checkNotNull((Object)contentDescriptor);
        PestParallelProgramRunnerKt.postprocessExecutionResult(contentDescriptor, environment, PestBundle.message("PARALLEL_TESTING_IS_SUPPORTED_FROM_VERSION_2", new Object[0]));
        return contentDescriptor;
    }

    @NotNull
    public String getRunnerId() {
        return RUNNER_ID;
    }

    @NotNull
    public final List<String> getArguments() {
        return PestParallelProgramRunnerKt.getPEST_PARALLEL_ARGUMENTS();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pestphp/pest/features/parallel/PestParallelProgramRunner$Companion;", "", "<init>", "()V", "RUNNER_ID", "", "intellij.pest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

