/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.actions.ChangedRangesShifter;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.Range;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.checkin.StepIntersection;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TodoCheckinHandlerWorker {
    private static final Logger LOG = Logger.getInstance(TodoCheckinHandlerWorker.class);
    private final Project myProject;
    private final Collection<? extends Change> myChanges;
    private final TodoFilter myTodoFilter;
    private final Set<TodoItem> myAddedOrEditedTodos;
    private final Set<TodoItem> myInChangedTodos;
    private final List<Pair<FilePath, String>> mySkipped;
    private static final Convertor<TodoItem, TextRange> TODO_ITEM_CONVERTOR = o -> {
        TextRange textRange = o.getTextRange();
        List additionalRanges = o.getAdditionalTextRanges();
        return new TextRange(textRange.getStartOffset(), (additionalRanges.isEmpty() ? textRange : (TextRange)additionalRanges.get(additionalRanges.size() - 1)).getEndOffset() - 1);
    };

    public TodoCheckinHandlerWorker(@NotNull Project project, @NotNull Collection<? extends Change> changes, @Nullable TodoFilter todoFilter) {
        if (project == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(1);
        }
        this.myAddedOrEditedTodos = new HashSet<TodoItem>();
        this.myInChangedTodos = new HashSet<TodoItem>();
        this.mySkipped = new SmartList();
        this.myProject = project;
        this.myChanges = changes;
        this.myTodoFilter = todoFilter;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(2);
        }
        return project;
    }

    public void execute() {
        List changes = ContainerUtil.filter(this.myChanges, it -> it.getAfterRevision() != null);
        for (int i = 0; i < changes.size(); ++i) {
            Change change = (Change)changes.get(i);
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = Objects.requireNonNull(change.getAfterRevision());
            FilePath afterFilePath = afterRevision.getFile();
            VirtualFile afterFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(afterFilePath.getPath());
            EditedFileProcessorBase fileProcessor = (EditedFileProcessorBase)ReadAction.compute(() -> {
                PsiFile afterPsiFile;
                ProgressManager.progress((String)(afterFile != null ? ProjectUtil.calcRelativeToProjectPath((VirtualFile)afterFile, (Project)this.myProject) : afterFilePath.getName()));
                if (afterFile == null || afterFile.isDirectory() || afterFile.getFileType().isBinary()) {
                    return null;
                }
                PsiFile psiFile = afterPsiFile = afterFile.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(afterFile) : null;
                if (afterPsiFile == null) {
                    this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)afterFilePath, (Object)VcsBundle.message((String)"checkin.invalid.file.s", (Object[])new Object[0])));
                    return null;
                }
                if (beforeRevision == null) {
                    List<TodoItem> newTodoItems = this.collectTodoItems(afterPsiFile, false);
                    this.myAddedOrEditedTodos.addAll(newTodoItems);
                    return null;
                }
                Document afterDocument = FileDocumentManager.getInstance().getDocument(afterFile);
                if (afterDocument == null) {
                    this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)afterFilePath, (Object)VcsBundle.message((String)"checkin.can.not.load.current.revision", (Object[])new Object[0])));
                    return null;
                }
                String afterContent = afterDocument.getText();
                List<TodoItem> afterTodoItems = this.collectTodoItems(afterPsiFile, false);
                if (afterRevision instanceof CurrentContentRevision) {
                    return new SimpleEditedFileProcessor(this.myProject, afterFilePath, beforeRevision, afterContent, afterTodoItems);
                }
                return new NonLocalEditedFileProcessor(this.myProject, afterFilePath, beforeRevision, afterRevision, afterContent, afterTodoItems);
            });
            try {
                if (fileProcessor != null) {
                    fileProcessor.process();
                }
                TodoCheckinHandlerWorker.fraction(((double)i + 1.0) / (double)changes.size());
                continue;
            }
            catch (DiffTooBigException e) {
                LOG.info("File " + afterFilePath.getPath() + " is too big and there are too many changes to build a diff");
                this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)afterFilePath, (Object)VcsBundle.message((String)"checkin.can.not.load.previous.revision", (Object[])new Object[0])));
            }
        }
    }

    private static void fraction(double value) {
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            indicator.setFraction(value);
        }
    }

    @NotNull
    private List<TodoItem> collectTodoItems(@NotNull PsiFile psiFile, boolean isLight) {
        if (psiFile == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(3);
        }
        if (!isLight) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        PsiTodoSearchHelper searchHelper = PsiTodoSearchHelper.getInstance((Project)this.myProject);
        TodoItem[] todoItems = isLight ? searchHelper.findTodoItemsLight(psiFile) : searchHelper.findTodoItems(psiFile);
        List<TodoItem> list = TodoCheckinHandlerWorker.applyFilterAndRemoveDuplicatesAndSort(todoItems, this.myTodoFilter);
        if (list == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static List<TodoItem> applyFilterAndRemoveDuplicatesAndSort(TodoItem @NotNull [] items, @Nullable TodoFilter filter) {
        if (items == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(5);
        }
        return Arrays.stream(items).filter(next -> filter == null || next.getPattern() != null && filter.contains(next.getPattern())).map(p -> {
            record ByRange(@NotNull TextRange range, @NotNull TodoItem item) {
                @NotNull
                private final TextRange range;
                @NotNull
                private final TodoItem item;

                ByRange(@NotNull TextRange range, @NotNull TodoItem item) {
                    if (range == null) {
                        ByRange.$$$reportNull$$$0(0);
                    }
                    if (item == null) {
                        ByRange.$$$reportNull$$$0(1);
                    }
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public boolean equals(Object obj) {
                    if (!(obj instanceof ByRange)) return false;
                    ByRange br = (ByRange)obj;
                    if (!this.range.equals((Object)br.range)) return false;
                    return true;
                }

                @Override
                public int hashCode() {
                    return this.range.hashCode();
                }

                @NotNull
                public TextRange range() {
                    TextRange textRange = this.range;
                    if (textRange == null) {
                        ByRange.$$$reportNull$$$0(2);
                    }
                    return textRange;
                }

                @NotNull
                public TodoItem item() {
                    TodoItem todoItem = this.item;
                    if (todoItem == null) {
                        ByRange.$$$reportNull$$$0(3);
                    }
                    return todoItem;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2, 3 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "range";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "item";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$1ByRange";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$1ByRange";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "range";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "item";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "<init>";
                            break;
                        }
                        case 2: 
                        case 3: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2, 3 -> new IllegalStateException(string);
                    };
                }
            }
            return new ByRange(p.getTextRange(), (TodoItem)p);
        }).distinct().map(br -> br.item()).sorted(TodoItem.BY_START_OFFSET).toList();
    }

    @NotNull
    public Set<TodoItem> getAddedOrEditedTodos() {
        Set<TodoItem> set = this.myAddedOrEditedTodos;
        if (set == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public Set<TodoItem> getInChangedTodos() {
        Set<TodoItem> set = this.myInChangedTodos;
        if (set == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public List<Pair<FilePath, String>> getSkipped() {
        List<Pair<FilePath, String>> list = this.mySkipped;
        if (list == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static String getTodoText(TodoItem item, String content) {
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add(TodoCheckinHandlerWorker.getTodoPartText(content, item.getTextRange()));
        item.getAdditionalTextRanges().forEach(r -> joiner.add(TodoCheckinHandlerWorker.getTodoPartText(content, r)));
        return joiner.toString();
    }

    private static String getTodoPartText(String content, TextRange textRange) {
        String fragment = textRange.substring(content);
        return StringUtil.join((String[])fragment.split("\\s"), (String)" ");
    }

    @Nullable
    private static String getRevisionContent(@NotNull ContentRevision revision) {
        if (revision == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(9);
        }
        try {
            String content = revision.getContent();
            return content != null ? StringUtil.convertLineSeparators((String)content) : null;
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @NotNull
    public Set<TodoItem> inOneList() {
        HashSet<TodoItem> set = new HashSet<TodoItem>();
        set.addAll(this.getAddedOrEditedTodos());
        set.addAll(this.getInChangedTodos());
        HashSet<TodoItem> hashSet = set;
        if (hashSet == null) {
            TodoCheckinHandlerWorker.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @NotNull
    public List<Change> getChanges() {
        return new ArrayList<Change>(this.myChanges);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTodoItems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddedOrEditedTodos";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInChangedTodos";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkipped";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "inOneList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectTodoItems";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFilterAndRemoveDuplicatesAndSort";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 7, 8, 10 -> new IllegalStateException(string);
        };
    }

    private abstract class EditedFileProcessorBase {
        @NotNull
        protected final Project myProject;
        protected String myBeforeContent;
        @NotNull
        protected final String myAfterContent;
        @NotNull
        protected final FilePath myAfterFile;
        @NotNull
        private final List<? extends TodoItem> myNewTodoItems;

        private EditedFileProcessorBase(@NotNull Project project, @NotNull FilePath afterFilePath, @NotNull String afterContent, List<? extends TodoItem> afterTodoItems) {
            if (project == null) {
                EditedFileProcessorBase.$$$reportNull$$$0(0);
            }
            if (afterFilePath == null) {
                EditedFileProcessorBase.$$$reportNull$$$0(1);
            }
            if (afterContent == null) {
                EditedFileProcessorBase.$$$reportNull$$$0(2);
            }
            if (afterTodoItems == null) {
                EditedFileProcessorBase.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myAfterFile = afterFilePath;
            this.myAfterContent = afterContent;
            this.myNewTodoItems = afterTodoItems;
        }

        protected abstract boolean loadContents();

        @NotNull
        protected abstract List<LineFragment> computeFragments();

        @NotNull
        private List<TodoItem> computeOldTodoItems() {
            PsiFile beforePsiFile = (PsiFile)ReadAction.compute(() -> PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("old" + this.myAfterFile.getName(), this.myAfterFile.getFileType(), (CharSequence)this.myBeforeContent));
            List<TodoItem> list = TodoCheckinHandlerWorker.this.collectTodoItems(beforePsiFile, true);
            if (list == null) {
                EditedFileProcessorBase.$$$reportNull$$$0(4);
            }
            return list;
        }

        public void process() throws DiffTooBigException {
            if (!this.loadContents()) {
                return;
            }
            List<LineFragment> lineFragments = this.computeFragments();
            ArrayList changedTodoItems = new ArrayList();
            StepIntersection.processIntersections(this.myNewTodoItems, lineFragments, TODO_ITEM_CONVERTOR, new RightLineFragmentConvertor(this.myAfterContent), (todoItem, lineFragment) -> changedTodoItems.add(Pair.create((Object)todoItem, (Object)lineFragment)));
            if (changedTodoItems.isEmpty()) {
                return;
            }
            List<TodoItem> oldTodoItems = this.computeOldTodoItems();
            if (oldTodoItems.isEmpty()) {
                for (Pair pair : changedTodoItems) {
                    TodoCheckinHandlerWorker.this.myAddedOrEditedTodos.add((TodoItem)pair.first);
                }
                return;
            }
            LineFragment lastLineFragment = null;
            HashSet oldTodoTexts = new HashSet();
            for (Pair pair : changedTodoItems) {
                String text;
                TodoItem todoItem2 = (TodoItem)pair.first;
                LineFragment lineFragment2 = (LineFragment)pair.second;
                if (lineFragment2 != lastLineFragment) {
                    oldTodoTexts.clear();
                    StepIntersection.processElementIntersections(lineFragment2, oldTodoItems, new LeftLineFragmentConvertor(this.myBeforeContent), TODO_ITEM_CONVERTOR, (fragment, oldTodoItem) -> oldTodoTexts.add(TodoCheckinHandlerWorker.getTodoText(oldTodoItem, this.myBeforeContent)));
                    lastLineFragment = lineFragment2;
                }
                if (!oldTodoTexts.contains(text = TodoCheckinHandlerWorker.getTodoText(todoItem2, this.myAfterContent))) {
                    TodoCheckinHandlerWorker.this.myAddedOrEditedTodos.add(todoItem2);
                    continue;
                }
                if (((TextRange)TODO_ITEM_CONVERTOR.convert((Object)todoItem2)).getEndOffset() < lineFragment2.getStartOffset2()) continue;
                TodoCheckinHandlerWorker.this.myInChangedTodos.add(todoItem2);
            }
            TodoCheckinHandlerWorker.this.myInChangedTodos.removeAll(TodoCheckinHandlerWorker.this.myAddedOrEditedTodos);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterFilePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterContent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterTodoItems";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$EditedFileProcessorBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$EditedFileProcessorBase";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeOldTodoItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private final class SimpleEditedFileProcessor
    extends EditedFileProcessorBase {
        private final ContentRevision myBeforeRevision;

        private SimpleEditedFileProcessor(@NotNull Project project, @NotNull FilePath afterFilePath, @NotNull ContentRevision beforeRevision, @NotNull String afterContent, List<? extends TodoItem> afterTodoItems) {
            if (project == null) {
                SimpleEditedFileProcessor.$$$reportNull$$$0(0);
            }
            if (afterFilePath == null) {
                SimpleEditedFileProcessor.$$$reportNull$$$0(1);
            }
            if (beforeRevision == null) {
                SimpleEditedFileProcessor.$$$reportNull$$$0(2);
            }
            if (afterContent == null) {
                SimpleEditedFileProcessor.$$$reportNull$$$0(3);
            }
            if (afterTodoItems == null) {
                SimpleEditedFileProcessor.$$$reportNull$$$0(4);
            }
            super(project, afterFilePath, afterContent, afterTodoItems);
            this.myBeforeRevision = beforeRevision;
        }

        @Override
        protected boolean loadContents() {
            this.myBeforeContent = TodoCheckinHandlerWorker.getRevisionContent(this.myBeforeRevision);
            if (this.myBeforeContent == null) {
                TodoCheckinHandlerWorker.this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)this.myAfterFile, (Object)VcsBundle.message((String)"checkin.can.not.load.previous.revision", (Object[])new Object[0])));
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        protected List<LineFragment> computeFragments() {
            ProgressIndicator indicator = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)DumbProgressIndicator.INSTANCE);
            List list = ComparisonManager.getInstance().compareLines((CharSequence)this.myBeforeContent, (CharSequence)this.myAfterContent, ComparisonPolicy.DEFAULT, indicator);
            if (list == null) {
                SimpleEditedFileProcessor.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterFilePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beforeRevision";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterContent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterTodoItems";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$SimpleEditedFileProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$SimpleEditedFileProcessor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeFragments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private final class NonLocalEditedFileProcessor
    extends EditedFileProcessorBase {
        private final ContentRevision myBeforeRevision;
        private final ContentRevision myAfterChangeRevision;
        private String myAfterChangeContent;

        private NonLocalEditedFileProcessor(@NotNull Project project, @NotNull FilePath afterFilePath, @NotNull ContentRevision beforeRevision, @NotNull ContentRevision afterChangeRevision, @NotNull String afterContent, List<? extends TodoItem> afterTodoItems) {
            if (project == null) {
                NonLocalEditedFileProcessor.$$$reportNull$$$0(0);
            }
            if (afterFilePath == null) {
                NonLocalEditedFileProcessor.$$$reportNull$$$0(1);
            }
            if (beforeRevision == null) {
                NonLocalEditedFileProcessor.$$$reportNull$$$0(2);
            }
            if (afterChangeRevision == null) {
                NonLocalEditedFileProcessor.$$$reportNull$$$0(3);
            }
            if (afterContent == null) {
                NonLocalEditedFileProcessor.$$$reportNull$$$0(4);
            }
            if (afterTodoItems == null) {
                NonLocalEditedFileProcessor.$$$reportNull$$$0(5);
            }
            super(project, afterFilePath, afterContent, afterTodoItems);
            this.myBeforeRevision = beforeRevision;
            this.myAfterChangeRevision = afterChangeRevision;
        }

        @Override
        protected boolean loadContents() {
            this.myBeforeContent = TodoCheckinHandlerWorker.getRevisionContent(this.myBeforeRevision);
            if (this.myBeforeContent == null) {
                TodoCheckinHandlerWorker.this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)this.myAfterFile, (Object)VcsBundle.message((String)"checkin.can.not.load.previous.revision", (Object[])new Object[0])));
                return false;
            }
            this.myAfterChangeContent = TodoCheckinHandlerWorker.getRevisionContent(this.myAfterChangeRevision);
            if (this.myAfterChangeContent == null) {
                TodoCheckinHandlerWorker.this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)this.myAfterFile, (Object)VcsBundle.message((String)"checkin.can.not.load.current.revision", (Object[])new Object[0])));
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        protected List<LineFragment> computeFragments() {
            LineOffsets beforeLineOffsets = LineOffsetsUtil.create((CharSequence)this.myBeforeContent);
            LineOffsets afterChangeLineOffsets = LineOffsetsUtil.create((CharSequence)this.myAfterChangeContent);
            LineOffsets afterLineOffsets = LineOffsetsUtil.create((CharSequence)this.myAfterContent);
            FairDiffIterable committedLines = RangesBuilder.compareLines((CharSequence)this.myBeforeContent, (CharSequence)this.myAfterChangeContent, (LineOffsets)beforeLineOffsets, (LineOffsets)afterChangeLineOffsets);
            FairDiffIterable localLines = RangesBuilder.compareLines((CharSequence)this.myAfterChangeContent, (CharSequence)this.myAfterContent, (LineOffsets)afterChangeLineOffsets, (LineOffsets)afterLineOffsets);
            ChangedRangesShifter builder = new ChangedRangesShifter();
            List<Range> ranges = builder.execute(committedLines, localLines);
            DiffIterable iterable = DiffIterableUtil.create(ranges, (int)beforeLineOffsets.getLineCount(), (int)afterLineOffsets.getLineCount());
            List list = ComparisonManagerImpl.convertIntoLineFragments((LineOffsets)beforeLineOffsets, (LineOffsets)afterLineOffsets, (DiffIterable)iterable);
            if (list == null) {
                NonLocalEditedFileProcessor.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterFilePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beforeRevision";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterChangeRevision";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterContent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterTodoItems";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$NonLocalEditedFileProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker$NonLocalEditedFileProcessor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeFragments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }

    private static final class RightLineFragmentConvertor
    implements Convertor<LineFragment, TextRange> {
        private final String myContent;

        private RightLineFragmentConvertor(String content) {
            this.myContent = content;
        }

        public TextRange convert(LineFragment o) {
            int start2 = o.getStartOffset2();
            int end = o.getEndOffset2();
            int prevLineStart = this.myContent.lastIndexOf(10, start2 - 2) + 1;
            return new TextRange(prevLineStart, Math.max(start2, end - 1));
        }
    }

    private static final class LeftLineFragmentConvertor
    implements Convertor<LineFragment, TextRange> {
        private final String myContent;

        private LeftLineFragmentConvertor(String content) {
            this.myContent = content;
        }

        public TextRange convert(LineFragment o) {
            int start2 = o.getStartOffset1();
            int end = o.getEndOffset1();
            int prevLineStart = this.myContent.lastIndexOf(10, start2 - 2) + 1;
            return new TextRange(prevLineStart, Math.max(start2, end - 1));
        }
    }
}

