/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.calculators;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.codesmells.DependencyGraph;
import com.jetbrains.php.refactoring.codesmells.DependencyMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LCOM4MetricsCalculator {
    private final List<Method> myMethodsToAnalyze;
    private final PhpClass myClass;
    DependencyGraph<PhpClassMember> myGraph;

    public LCOM4MetricsCalculator(@NotNull PhpClass aClass) {
        if (aClass == null) {
            LCOM4MetricsCalculator.$$$reportNull$$$0(0);
        }
        this.myClass = aClass;
        this.myMethodsToAnalyze = ContainerUtil.filter((Object[])aClass.getOwnMethods(), e -> !PhpLangUtil.isMagicMethod((CharSequence)e.getName()) && !e.isAbstract());
        ArrayList<Object> classMembers = new ArrayList<Object>();
        classMembers.addAll(this.myMethodsToAnalyze);
        classMembers.addAll(Arrays.asList(aClass.getOwnFields()));
        this.myGraph = new DependencyGraph(classMembers, this.collectDependencies());
    }

    private DependencyMap<PhpClassMember, PhpClassMember> collectDependencies() {
        final DependencyMap dependencyMap = new DependencyMap();
        for (final Method method : this.myMethodsToAnalyze) {
            PhpControlFlowUtil.processFlow((PhpControlFlow)method.getControlFlow(), (PhpInstructionProcessor)new PhpInstructionProcessor(){

                public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                    Field field;
                    PsiElement resolvedElement;
                    FieldReference fieldReference = instruction.getFieldReference();
                    if (fieldReference != null && (resolvedElement = fieldReference.resolve()) instanceof Field && (field = (Field)resolvedElement).getContainingClass() == method.getContainingClass()) {
                        dependencyMap.add((Object)method, (Object)field);
                        dependencyMap.add((Object)field, (Object)method);
                    }
                    return super.processAccessFieldByVariableInstruction(instruction);
                }

                public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction instruction) {
                    FieldReference fieldReference = (FieldReference)instruction.getAnchor();
                    Field field = (Field)fieldReference.resolve();
                    if (field != null && field.getContainingClass() == method.getContainingClass()) {
                        dependencyMap.add((Object)method, (Object)field);
                        dependencyMap.add((Object)field, (Object)method);
                    }
                    return super.processAccessFieldInObjectContextInstruction(instruction);
                }

                public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                    Method resolvedMethod;
                    PsiElement resolve;
                    FunctionReference functionReference = instruction.getFunctionReference();
                    if (functionReference instanceof MethodReference && (resolve = functionReference.resolve()) instanceof Method && (resolvedMethod = (Method)resolve).getContainingClass() == LCOM4MetricsCalculator.this.myClass) {
                        dependencyMap.add((Object)method, (Object)resolvedMethod);
                        dependencyMap.add((Object)resolvedMethod, (Object)method);
                    }
                    return super.processPhpCallInstruction(instruction);
                }
            });
        }
        return dependencyMap;
    }

    public int getLcom() {
        return this.myGraph.getComponents().size();
    }

    public double getTcc() {
        int numberOfPairsFromSameComponent = 0;
        int size = this.myMethodsToAnalyze.size();
        if (size < 2) {
            return 1.0;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (i == j || this.myGraph.getContainingGraphComponent((Object)((PhpClassMember)this.myMethodsToAnalyze.get(i))) != this.myGraph.getContainingGraphComponent((Object)((PhpClassMember)this.myMethodsToAnalyze.get(j)))) continue;
                ++numberOfPairsFromSameComponent;
            }
        }
        return (double)numberOfPairsFromSameComponent / (double)(size * (size - 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/php/architecture/complexityMetrics/calculators/LCOM4MetricsCalculator", "<init>"));
    }
}

