/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.clazz;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorsGenerator;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import java.util.Collection;

public class PhpClassMembersEntitySetMatrix {
    private final MultiMap<PhpClassMember, PhpClassMember> myEntitySets = MultiMap.createSet();

    public PhpClassMembersEntitySetMatrix(Collection<PhpClassMember> members) {
        for (final PhpClassMember member : members) {
            this.myEntitySets.putValue((Object)member, (Object)member);
            if (member instanceof Field) {
                this.addUsingMethods(member);
                this.addUsingMethodsViaAccessors((Field)member);
            }
            if (!(member instanceof Method)) continue;
            PhpControlFlowUtil.processFlow((PhpControlFlow)((Method)member).getControlFlow(), (PhpInstructionProcessor)new PhpInstructionProcessor(){

                public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction instruction) {
                    FieldReference fieldReference = (FieldReference)instruction.getAnchor();
                    Field field = (Field)fieldReference.resolve();
                    if (field != null) {
                        PhpClassMembersEntitySetMatrix.this.myEntitySets.putValue((Object)member, (Object)field);
                    }
                    return super.processAccessFieldInObjectContextInstruction(instruction);
                }

                public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                    PsiElement field;
                    FieldReference fieldReference = instruction.getFieldReference();
                    if (fieldReference != null && (field = fieldReference.resolve()) instanceof Field) {
                        PhpClassMembersEntitySetMatrix.this.myEntitySets.putValue((Object)member, (Object)((PhpClassMember)field));
                    }
                    return super.processAccessFieldByVariableInstruction(instruction);
                }

                public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                    PsiElement method;
                    PsiElement anchor = instruction.getAnchor();
                    if (anchor instanceof MethodReference && (method = ((MethodReference)anchor).resolve()) instanceof PhpClassMember) {
                        PhpClassMembersEntitySetMatrix.this.myEntitySets.putValue((Object)member, (Object)((PhpClassMember)method));
                    }
                    return super.processPhpCallInstruction(instruction);
                }
            });
        }
    }

    public MultiMap<PhpClassMember, PhpClassMember> getEntitySets() {
        return this.myEntitySets;
    }

    private void addUsingMethodsViaAccessors(Field member) {
        PhpAccessorsGenerator accessorsGenerator = new PhpAccessorsGenerator(member);
        for (Method getter : accessorsGenerator.findGetters()) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)getter, (SearchScope)GlobalSearchScope.fileScope((PsiFile)member.getContainingFile()))) {
                this.updateEntitySet(member, reference);
            }
        }
    }

    private void updateEntitySet(Field member, PsiReference reference) {
        PhpClassMember containingMember = (PhpClassMember)PhpPsiUtil.getParentByCondition((PsiElement)reference.getElement(), e -> e instanceof Method && ((Method)e).getContainingClass() == member.getContainingClass());
        if (containingMember != null) {
            this.myEntitySets.putValue((Object)member, (Object)containingMember);
        }
    }

    private void addUsingMethods(PhpClassMember member) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)member, (SearchScope)GlobalSearchScope.fileScope((PsiFile)member.getContainingFile()))) {
            PhpClassMember containingMember = (PhpClassMember)PhpPsiUtil.getParentByCondition((PsiElement)reference.getElement(), e -> e instanceof Method && ((Method)e).getContainingClass() == member.getContainingClass());
            if (containingMember == null) continue;
            this.myEntitySets.putValue((Object)member, (Object)containingMember);
        }
    }
}

