/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.clazz;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.ClassClusteringProvider;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.extractClass.PhpExtractClassHandler;
import com.jetbrains.php.refactoring.extractClass.PhpExtractMembersToClassDialog;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpExtractClassQuickFix
extends PhpQuickFixBase {
    private final SmartPsiElementPointer<PhpClass> myClassPointer;

    public PhpExtractClassQuickFix(PhpClass clazz) {
        this.myClassPointer = SmartPointerManager.getInstance((Project)clazz.getProject()).createSmartPsiElementPointer((PsiElement)clazz);
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PhpArchitectureBundle.message("quickfix.php.extract.class", new Object[0]);
        if (string == null) {
            PhpExtractClassQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpExtractClassQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpExtractClassQuickFix.$$$reportNull$$$0(2);
        }
        PhpClass clazz = (PhpClass)this.myClassPointer.getElement();
        PhpExtractClassQuickFix.doExtractClass(project, clazz);
    }

    public static void doExtractClass(@NotNull Project project, PhpClass clazz) {
        if (project == null) {
            PhpExtractClassQuickFix.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            return;
        }
        List<PhpClassMember> members = ClassClusteringProvider.filterClassMembers(PhpExtractClassHandler.getClassMembers((PhpClass)clazz));
        HashSet selectedMembers = new HashSet();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.compute(() -> selectedMembers.addAll(ClassClusteringProvider.doClusteringAndGetTheBestCluster(members))), PhpArchitectureBundle.message("progress.title.finding.the.best.candidate", new Object[0]), true, project);
        PhpExtractMembersToClassDialog dialog = new PhpExtractMembersToClassDialog(PhpExtractClassHandler.createClassMembersInfo((List)PhpExtractClassHandler.getClassMembers((PhpClass)clazz), selectedMembers), false);
        dialog.show();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            PhpExtractClassQuickFix.$$$reportNull$$$0(4);
        }
        if (previewDescriptor == null) {
            PhpExtractClassQuickFix.$$$reportNull$$$0(5);
        }
        return new IntentionPreviewInfo.Html(PhpArchitectureBundle.message("shows.extract.members.to.class.dialog", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/inspections/clazz/PhpExtractClassQuickFix";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/inspections/clazz/PhpExtractClassQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doExtractClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

