/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.clazz;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.architecture.complexityMetrics.calculators.LCOM4MetricsCalculator;
import com.jetbrains.php.architecture.complexityMetrics.inspections.clazz.PhpExtractClassQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class PhpLackOfCohesionInspection
extends PhpInspection {
    private static final int METRIC_THRESHOLD = 1;
    private static final int NUMBER_OF_FIELDS = 10;
    private static final int NUMBER_OF_METHODS = 10;
    public int myLcomThreshold = 1;
    public int myMinimumNumberOfFields = 10;
    public int myMinimumNumberOfMethods = 10;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpLackOfCohesionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                if (!clazz.isAbstract()) {
                    int lcom = new LCOM4MetricsCalculator(clazz).getLcom();
                    if (clazz.getOwnMethods().length > PhpLackOfCohesionInspection.this.myMinimumNumberOfMethods && clazz.getOwnFields().length > PhpLackOfCohesionInspection.this.myMinimumNumberOfFields && lcom > PhpLackOfCohesionInspection.this.myLcomThreshold) {
                        holder.registerProblem(Objects.requireNonNull(clazz.getNameIdentifier()), PhpArchitectureBundle.message("inspection.message.class.has.lack.cohesion.metric", clazz.getName(), lcom), new LocalQuickFix[]{new PhpExtractClassQuickFix(clazz)});
                    }
                }
                super.visitPhpClass(clazz);
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"myLcomThreshold", (String)PhpArchitectureBundle.message("inspection.php.lack.of.cohesion.metric.options.metric.LCOM.threshold", new Object[0]), (int)0, (int)2), OptPane.number((String)"myMinimumNumberOfFields", (String)PhpArchitectureBundle.message("inspection.php.lack.of.cohesion.metric.options.minimal.number.of.fields", new Object[0]), (int)1, (int)10000), OptPane.number((String)"myMinimumNumberOfMethods", (String)PhpArchitectureBundle.message("inspection.php.lack.of.cohesion.metric.options.minimal.number.of.methods", new Object[0]), (int)1, (int)10000)});
        if (optPane == null) {
            PhpLackOfCohesionInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/inspections/clazz/PhpLackOfCohesionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/inspections/clazz/PhpLackOfCohesionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

