/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.method;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics.CyclomaticComplexityVisitor;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractFunction.PhpExtractMethodQuickfix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodBlockCodeFragment;
import org.jetbrains.annotations.NotNull;

public final class PhpFunctionCyclomaticComplexityInspection
extends PhpInspection {
    private static final int COMPLEXITY_LIMIT = 20;
    public int limit = 20;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"limit", (String)PhpArchitectureBundle.message("inspection.php.complex.function.option.cyclomatic.complexity.limit", new Object[0]), (int)1, (int)1000)});
        if (optPane == null) {
            PhpFunctionCyclomaticComplexityInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpFunctionCyclomaticComplexityInspection.$$$reportNull$$$0(1);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }

            public void visitPhpFunction(Function function) {
                CyclomaticComplexityVisitor visitor = new CyclomaticComplexityVisitor();
                function.accept((PsiElementVisitor)visitor);
                if (visitor.getValue() > PhpFunctionCyclomaticComplexityInspection.this.limit) {
                    PsiElement highlightedFunctionPart = function.getNameIdentifier();
                    if (highlightedFunctionPart == null) {
                        highlightedFunctionPart = function.getFirstChild();
                    }
                    holder.registerProblem(highlightedFunctionPart, PhpArchitectureBundle.message("inspection.message.cyclomatic.complexity.is.too.high.0", visitor.getValue()), new LocalQuickFix[]{new PhpExtractMethodQuickfix((Condition<? super PhpExtractMethodBlockCodeFragment>)((Condition)fragment -> {
                        visitor.reset();
                        PhpPsiElementFactory.createFunction((Project)function.getProject(), (String)("function f() {" + fragment.generateCodeText() + "}")).accept((PsiElementVisitor)visitor);
                        return visitor.getValue() <= PhpFunctionCyclomaticComplexityInspection.this.limit;
                    }))});
                }
                super.visitPhpFunction(function);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/inspections/method/PhpFunctionCyclomaticComplexityInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/inspections/method/PhpFunctionCyclomaticComplexityInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

