/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.method;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics.HalsteadMetric;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractFunction.PhpExtractMethodQuickfix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpHalsteadMetricInspection
extends PhpInspection {
    public static final int DEFAULT_COMPLEXITY_THRESHOLD = 50;
    public int myComplexityThreshold = 50;
    private HalsteadMetric myMetric;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"myComplexityThreshold", (String)PhpArchitectureBundle.message("inspection.php.halstead.metric.option.halstead.metric.limit", new Object[0]), (int)1, (int)1000)});
        if (optPane == null) {
            PhpHalsteadMetricInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpHalsteadMetricInspection.$$$reportNull$$$0(1);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                this.processFunction((Function)method);
                super.visitPhpMethod(method);
            }

            public void visitPhpFunction(Function function) {
                this.processFunction(function);
                super.visitPhpFunction(function);
            }

            private void processFunction(Function function) {
                PsiElement nameIdentifier;
                PhpHalsteadMetricInspection.this.myMetric = new HalsteadMetric(PhpHalsteadMetricInspection.this.myComplexityThreshold);
                function.accept((PsiElementVisitor)PhpHalsteadMetricInspection.this.myMetric.getHalsteadVisitor());
                double complexity = PhpHalsteadMetricInspection.this.myMetric.calculateComplexity();
                if (complexity > (double)PhpHalsteadMetricInspection.this.myComplexityThreshold && (nameIdentifier = function.getNameIdentifier()) != null) {
                    holder.registerProblem(nameIdentifier, PhpArchitectureBundle.message("inspection.message.halstead.complexity.metrics.is.too.high.0", complexity), new LocalQuickFix[]{new PhpExtractMethodQuickfix()});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/inspections/method/PhpHalsteadMetricInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/inspections/method/PhpHalsteadMetricInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

