/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.architecture.complexityMetrics.PhpRecursiveElementWalkingVisitor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HalsteadMetric {
    private final Set<String> myOperators = new HashSet<String>();
    private final Set<String> myOperands = new HashSet<String>();
    private int myNumberOfOperands;
    private final double myComplexityThreshold;
    private static final TokenSet myTokensToConsider;

    public HalsteadMetric(double complexityThreshold) {
        this.myComplexityThreshold = complexityThreshold;
    }

    public void registerOperator(@Nullable PsiElement operator) {
        if (operator != null) {
            this.myOperators.add(operator.getText());
        }
    }

    public void registerOperand(@Nullable PsiElement operand) {
        if (operand != null) {
            this.myOperands.add(operand.getText());
            ++this.myNumberOfOperands;
        }
    }

    private int getNumDistinctOperands() {
        return this.myOperands.size();
    }

    private int getNumDistinctOperators() {
        return this.myOperators.size();
    }

    public double calculateComplexity() {
        int N2 = this.myNumberOfOperands;
        int n1 = this.getNumDistinctOperators();
        int n2 = this.getNumDistinctOperands();
        return n2 == 0 ? 0.0 : (double)n1 / 2.0 * ((double)N2 / (double)n2);
    }

    @NotNull
    public PhpRecursiveElementWalkingVisitor getHalsteadVisitor() {
        return new PhpRecursiveElementWalkingVisitor(){

            private void stopIfThresholdReached() {
                if (HalsteadMetric.this.calculateComplexity() > HalsteadMetric.this.myComplexityThreshold) {
                    this.stopWalking();
                }
            }

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (myTokensToConsider.contains(element.getNode().getElementType())) {
                    HalsteadMetric.this.registerOperator(element);
                }
                this.stopIfThresholdReached();
                super.visitElement(element);
            }

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                PhpPsiElement leftOperand = assignmentExpression.getVariable();
                HalsteadMetric.this.registerOperand((PsiElement)leftOperand);
                this.stopIfThresholdReached();
                super.visitPhpAssignmentExpression(assignmentExpression);
            }

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                PsiElement leftOperand = expression.getLeftOperand();
                HalsteadMetric.this.registerOperand(leftOperand);
                this.stopIfThresholdReached();
                super.visitPhpBinaryExpression(expression);
            }

            public void visitPhpUnaryExpression(UnaryExpression expr) {
                HalsteadMetric.this.registerOperand((PsiElement)expr.getValue());
                this.stopIfThresholdReached();
                super.visitPhpUnaryExpression(expr);
            }

            public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
                HalsteadMetric.this.registerOperand((PsiElement)expression.getVariable());
                this.stopIfThresholdReached();
                super.visitPhpSelfAssignmentExpression(expression);
            }

            public void visitPhpExpression(PhpExpression expression) {
                HalsteadMetric.this.registerOperand((PsiElement)expression);
                this.stopIfThresholdReached();
                super.visitPhpExpression(expression);
            }

            public void visitPhpReturn(PhpReturn returnStatement) {
                PsiElement argument = returnStatement.getArgument();
                HalsteadMetric.this.registerOperand(argument);
                this.stopIfThresholdReached();
                super.visitPhpReturn(returnStatement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/architecture/complexityMetrics/inspections/method/metrics/HalsteadMetric$1", "visitElement"));
            }
        };
    }

    static {
        TokenSet allowedOperators = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsBINARY_OPS, PhpTokenTypes.tsKEYWORDS, PhpTokenTypes.tsBRACKETS, PhpTokenTypes.tsKEYWORDS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opCOMMA})});
        TokenSet disallowedOperators = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwFUNCTION}), PhpTokenTypes.tsMODIFIERS});
        myTokensToConsider = TokenSet.andNot((TokenSet)allowedOperators, (TokenSet)disallowedOperators);
    }
}

