/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics;

import com.intellij.psi.PsiElement;
import com.jetbrains.php.architecture.complexityMetrics.PhpRecursiveElementWalkingVisitor;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.While;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpNestingDepthVisitor
extends PhpRecursiveElementWalkingVisitor {
    private final int myNestingThreshold;
    private int myNestingCounter = 0;
    private int myMaxNestingDepth = 0;
    private final Set<PsiElement> scopeEntered = new HashSet<PsiElement>();

    public PhpNestingDepthVisitor() {
        this(100);
    }

    public PhpNestingDepthVisitor(int nestingThreshold) {
        this.myNestingThreshold = nestingThreshold;
    }

    private void enterScope(PsiElement element) {
        this.scopeEntered.add(element);
        ++this.myNestingCounter;
        this.myMaxNestingDepth = Math.max(this.myMaxNestingDepth, this.myNestingCounter);
        if (this.myMaxNestingDepth >= this.myNestingThreshold) {
            this.stopWalking();
        }
    }

    private void exitScope(PsiElement element) {
        if (this.scopeEntered.remove(element)) {
            --this.myNestingCounter;
        }
    }

    public void visitPhpGroupStatement(GroupStatement groupStatement) {
        PsiElement parent = groupStatement.getParent();
        if (!(parent instanceof ControlStatement || parent instanceof Try || parent instanceof Function && !((Function)parent).isClosure())) {
            this.enterScope((PsiElement)groupStatement);
        }
        super.visitPhpGroupStatement(groupStatement);
    }

    public void visitPhpIf(If ifStatement) {
        this.enterScope((PsiElement)ifStatement);
        super.visitPhpIf(ifStatement);
    }

    public void visitPhpFor(For forStatement) {
        this.enterScope((PsiElement)forStatement);
        super.visitPhpFor(forStatement);
    }

    public void visitPhpForeach(ForeachStatement foreach) {
        this.enterScope((PsiElement)foreach);
        super.visitPhpForeach(foreach);
    }

    public void visitPhpWhile(While whileStatement) {
        this.enterScope((PsiElement)whileStatement);
        super.visitPhpWhile(whileStatement);
    }

    public void visitPhpTry(Try tryStatement) {
        this.enterScope((PsiElement)tryStatement);
        super.visitPhpTry(tryStatement);
    }

    public void visitPhpCatch(Catch phpCatch) {
        this.enterScope((PsiElement)phpCatch);
        super.visitPhpCatch(phpCatch);
    }

    public void visitPhpFunction(Function function) {
        if (function.isClosure()) {
            this.enterScope((PsiElement)function);
        }
        super.visitPhpFunction(function);
    }

    public void visitPhpClass(PhpClass clazz) {
        this.enterScope((PsiElement)clazz);
        super.visitPhpClass(clazz);
    }

    @Override
    public void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            PhpNestingDepthVisitor.$$$reportNull$$$0(0);
        }
        super.elementFinished(element);
        this.exitScope(element);
    }

    public int getMaxNestingDepth() {
        return this.myMaxNestingDepth;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/architecture/complexityMetrics/inspections/method/metrics/PhpNestingDepthVisitor", "elementFinished"));
    }
}

