/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.architecture.complexityMetrics.inspections.clazz.PhpClassHasTooManyDeclaredMembersInspection;
import com.jetbrains.php.architecture.complexityMetrics.inspections.clazz.PhpComplexClassInspection;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.PhpMemberCanBePulledUpInspection;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.Clustering;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.JaccardDistance;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.MinimalClusterDistance;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ClassClusteringProvider {
    public static Clustering<PhpClassMember> getClustering(List<PhpClassMember> classMembers, JaccardDistance<PhpClassMember> jaccardDistance) {
        return new Clustering<PhpClassMember>(ContainerUtil.filter(classMembers, e -> !(e instanceof Method) || !PhpLangUtil.isMagicMethod((CharSequence)e.getName())), new MinimalClusterDistance<PhpClassMember>(jaccardDistance), cluster -> cluster.getEntities().stream().anyMatch(e -> e instanceof Method) && cluster.getEntities().size() > 2 && cluster.getEntities().size() < classMembers.size() / 2);
    }

    public static Set<PhpClassMember> doClusteringAndGetTheBestCluster(List<PhpClassMember> members) {
        JaccardDistance<PhpClassMember> jaccardDistance = PhpClassHasTooManyDeclaredMembersInspection.createJaccardDistance(members);
        Clustering<PhpClassMember> clustering = ClassClusteringProvider.getClustering(members, jaccardDistance);
        clustering.sort(jaccardDistance);
        return clustering.getEntitySetFromTheFirstCluster();
    }

    @NotNull
    public static Condition<PhpClassMember> notDelegatingMethod() {
        Condition condition = member -> {
            PsiElement resolvedMethod;
            PsiElement singleStatement;
            PsiElement memberReference;
            PsiElement methodBody;
            return !(member instanceof Method) || (methodBody = PhpPsiUtil.getChildByCondition((PsiElement)member, (Condition)GroupStatement.INSTANCEOF)) == null || methodBody.getChildren().length != 1 || !((memberReference = PhpPsiUtil.getChildByCondition((PsiElement)(singleStatement = PhpPsiUtil.getChildByCondition((PsiElement)methodBody, (Condition)Statement.INSTANCEOF)), (Condition)MemberReference.INSTANCEOF)) instanceof MethodReference) || !((resolvedMethod = ((MethodReference)memberReference).resolve()) instanceof Method) || !PhpMemberCanBePulledUpInspection.areDeclarationsFullyCompatible((Method)member, (Method)resolvedMethod);
        };
        if (condition == null) {
            ClassClusteringProvider.$$$reportNull$$$0(0);
        }
        return condition;
    }

    @NotNull
    public static List<PhpClassMember> filterClassMembers(List<PhpClassMember> phpClassMembers) {
        phpClassMembers = ContainerUtil.filter(phpClassMembers, e -> PhpComplexClassInspection.isMemberToConsider(e));
        List list = ContainerUtil.filter((Collection)phpClassMembers, ClassClusteringProvider.notDelegatingMethod());
        if (list == null) {
            ClassClusteringProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/architecture/complexityMetrics/quickFixes/extractClass/ClassClusteringProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "notDelegatingMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "filterClassMembers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

