/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.AverageClusterDistance;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.Cluster;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.Distance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Clustering<T> {
    public final List<Cluster<T>> myResultingClusters;
    private final Collection<T> myEntities;

    public Clustering(Collection<T> entities, Distance<Cluster<T>> clusterDistance, Predicate<Cluster<T>> isAllowed) {
        this.myEntities = entities;
        List clusters = entities.stream().map(e -> new Cluster<Object>(e)).collect(Collectors.toCollection(ArrayList::new));
        this.myResultingClusters = new ArrayList<Cluster<T>>();
        while (clusters.size() > 2) {
            double minimalDistance = 2.0;
            int firstClusterIndex = -1;
            int secondClusterIndex = -1;
            for (int i = 0; i < clusters.size(); ++i) {
                for (int j = i + 1; j < clusters.size(); ++j) {
                    double distanceBetweenClusters = clusterDistance.distance((Cluster)clusters.get(i), (Cluster)clusters.get(j));
                    if (!(minimalDistance > distanceBetweenClusters)) continue;
                    minimalDistance = distanceBetweenClusters;
                    firstClusterIndex = i;
                    secondClusterIndex = j;
                }
            }
            Cluster clusterToMergeIn = (Cluster)clusters.get(firstClusterIndex);
            clusterToMergeIn.merge((Cluster)clusters.get(secondClusterIndex));
            if (isAllowed.test(clusterToMergeIn)) {
                this.myResultingClusters.add(new Cluster(new HashSet(clusterToMergeIn.getEntities())));
            }
            clusters.remove(secondClusterIndex);
        }
    }

    public void sort(Distance<? super T> distance) {
        AverageClusterDistance<? super T> averageClusterDistance = new AverageClusterDistance<T>(distance);
        this.myResultingClusters.sort((e1, e2) -> -Double.compare(averageClusterDistance.distance((Cluster<? super T>)e1, new Cluster(this.myEntities.stream().filter(e -> !e1.getEntities().contains(e)).collect(Collectors.toSet()))), averageClusterDistance.distance((Cluster<? super T>)e2, new Cluster(this.myEntities.stream().filter(e -> !e2.getEntities().contains(e)).collect(Collectors.toSet())))));
    }

    public Set<T> getEntitySetFromTheFirstCluster() {
        Cluster firstItem = (Cluster)ContainerUtil.getFirstItem(this.myResultingClusters);
        return firstItem != null ? firstItem.getEntities() : Collections.emptySet();
    }

    public List<Cluster<T>> getClusters() {
        return this.myResultingClusters;
    }
}

