/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractFunction;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.PhpComplexFunctionInspection;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractFunction.PhpExtractFunctionFixLogger;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractFunction.PhpExtractMethodCandidate;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractFunction.PhpExtractMethodHandlerForBatchMode;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractFunction.PhpFunctionBlockCandidatesGenerator;
import com.jetbrains.php.architecture.complexityMetrics.ui.PhpExtractFunctionPanel;
import com.jetbrains.php.architecture.complexityMetrics.ui.PhpExtractMethodCandidateWithUsageAdapter;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodBlockCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractMethodQuickfix
extends PhpQuickFixBase {
    @NlsSafe
    public static final String EXTRACTED = "extracted";
    @Nullable
    private final Condition<? super PhpExtractMethodBlockCodeFragment> myFilter;
    public static final PhpExtractMethodQuickfix INSTANCE = new PhpExtractMethodQuickfix();

    public PhpExtractMethodQuickfix() {
        this(null);
    }

    public PhpExtractMethodQuickfix(@Nullable Condition<? super PhpExtractMethodBlockCodeFragment> filter) {
        this.myFilter = filter;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PhpArchitectureBundle.message("quickfix.php.extract.method", new Object[0]);
        if (string == null) {
            PhpExtractMethodQuickfix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpExtractMethodQuickfix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpExtractMethodQuickfix.$$$reportNull$$$0(2);
        }
        Function function = (Function)PhpPsiUtil.getParentOfClass((PsiElement)descriptor.getStartElement(), Function.class);
        assert (function != null);
        this.runFix(function);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            PhpExtractMethodQuickfix.$$$reportNull$$$0(3);
        }
        if (previewDescriptor == null) {
            PhpExtractMethodQuickfix.$$$reportNull$$$0(4);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            PhpExtractMethodQuickfix.$$$reportNull$$$0(5);
        }
        return intentionPreviewInfo;
    }

    public void runFix(@NotNull Function function) {
        if (function == null) {
            PhpExtractMethodQuickfix.$$$reportNull$$$0(6);
        }
        long startTime = System.nanoTime();
        Project project = function.getProject();
        if (CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)function)) {
            Ref candidateRef = new Ref();
            ArrayList<PhpExtractMethodCandidate> candidates = new ArrayList<PhpExtractMethodCandidate>();
            boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ApplicationManager.getApplication().runReadAction(() -> {
                    PhpFunctionBlockCandidatesGenerator functionBlockCandidatesGenerator = new PhpFunctionBlockCandidatesGenerator(function);
                    candidates.addAll(functionBlockCandidatesGenerator.getCandidates(this.myFilter));
                });
                PhpExtractMethodCandidate firstCandidate = (PhpExtractMethodCandidate)ContainerUtil.getFirstItem((List)candidates);
                if (firstCandidate != null) {
                    candidateRef.set((Object)firstCandidate.getFragment());
                }
            }, PhpArchitectureBundle.message("progress.title.finding.the.best.candidate", new Object[0]), true, project);
            if (!completed) {
                PhpExtractFunctionFixLogger.SEARCH_CANCELLED.log((Object)PhpComplexFunctionInspection.getNumberOfLines(function), (Object)PhpExtractFunctionFixLogger.durationInMillis(startTime));
            }
            if (!candidateRef.isNull()) {
                Editor editor = PsiEditorUtil.findEditor((PsiElement)((PhpExtractMethodBlockCodeFragment)candidateRef.get()).getStartStatement());
                if (editor != null) {
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        PhpExtractMethodQuickfix.showFragmentSelector(project, function, ContainerUtil.map(PhpExtractMethodQuickfix.getTop10Fragments(candidates), e -> new PhpExtractMethodCandidateWithUsageAdapter((PhpExtractMethodCandidate)e, new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)e.getStartStatement())))), editor, startTime);
                    } else {
                        new PhpExtractMethodHandlerForBatchMode(project).extractFromBlock(function.getProject(), editor, (PhpExtractMethodBlockCodeFragment)candidateRef.get(), false, false);
                    }
                }
            } else {
                PhpExtractFunctionFixLogger.UNABLE_TO_FIND_CANDIDATES.log((Object)PhpExtractFunctionFixLogger.durationInMillis(startTime));
                PhpExtractMethodQuickfix.showErrorMessage((Project)project, (String)PhpArchitectureBundle.message("quickfix.php.extract.method.hint.text.unable.to.find.extract.method.candidates", new Object[0]), (PsiElement)function);
            }
        }
    }

    @NotNull
    private static List<PhpExtractMethodCandidate> getTop10Fragments(List<PhpExtractMethodCandidate> filteredFragments) {
        List<PhpExtractMethodCandidate> list = filteredFragments.size() > 10 ? filteredFragments.subList(0, 10) : filteredFragments;
        if (list == null) {
            PhpExtractMethodQuickfix.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static void showFragmentSelector(@NotNull Project project, @NotNull Function function, @NotNull List<PhpExtractMethodCandidateWithUsageAdapter> filteredFragments, @NotNull Editor editor, long startTime) {
        if (project == null) {
            PhpExtractMethodQuickfix.$$$reportNull$$$0(8);
        }
        if (function == null) {
            PhpExtractMethodQuickfix.$$$reportNull$$$0(9);
        }
        if (filteredFragments == null) {
            PhpExtractMethodQuickfix.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            PhpExtractMethodQuickfix.$$$reportNull$$$0(11);
        }
        final AtomicReference<ScopeHighlighter> highlighter = new AtomicReference<ScopeHighlighter>(new ScopeHighlighter(editor));
        PhpExtractFunctionPanel functionPanel = new PhpExtractFunctionPanel(project, function, editor, filteredFragments, highlighter);
        JComponent functionCandidatePanel = functionPanel.createPanel();
        functionCandidatePanel.setMinimumSize(new Dimension(500, 130));
        functionCandidatePanel.setBorder((Border)JBUI.Borders.empty());
        ComponentPopupBuilder componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder(functionCandidatePanel, (JComponent)functionPanel.getMyExtractFunctionsCandidateTable()).setRequestFocus(true).setMovable(true).setTitle(PhpArchitectureBundle.message("extract.class.popup.title.code.to.extract", new Object[0]));
        JComponent contentComponent = editor.getContentComponent();
        JBPopup popup = componentPopupBuilder.createPopup();
        functionPanel.setDelegatePopup(popup);
        popup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ((ScopeHighlighter)highlighter.getAndSet(null)).dropHighlight();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/architecture/complexityMetrics/quickFixes/extractFunction/PhpExtractMethodQuickfix$1", "onClosed"));
            }
        });
        Rectangle visibleRect = contentComponent.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width - 500, visibleRect.y);
        popup.show(new RelativePoint((Component)contentComponent, point));
        PhpExtractFunctionFixLogger.POPUP_SHOWN.log((Object)filteredFragments.size(), (Object)PhpExtractFunctionFixLogger.durationInMillis(startTime));
        functionPanel.getMyExtractFunctionsCandidateTable().requestFocus();
    }

    public static boolean isBlockValid(@NotNull PhpExtractMethodBlockCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodQuickfix.$$$reportNull$$$0(12);
        }
        return PhpExtractMethodHandler.validateBlockFragment((PhpExtractMethodBlockCodeFragment)fragment) == null;
    }

    public boolean availableInBatchMode() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/quickFixes/extractFunction/PhpExtractMethodQuickfix";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filteredFragments";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/quickFixes/extractFunction/PhpExtractMethodQuickfix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTop10Fragments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runFix";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showFragmentSelector";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isBlockValid";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

