/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractFunction;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractFunction.PhpExtractMethodCandidate;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractFunction.PhpExtractMethodQuickfix;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodBlockCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFunctionBlockCandidatesGenerator {
    private static final Logger LOG = Logger.getInstance(PhpFunctionBlockCandidatesGenerator.class);
    public static final int MINIMAL_CANDIDATE_SIZE = 3;
    public static final int MAX_CANDIDATES_NUMBER = 1000;
    public final Function myFunction;
    private final Collection<PhpExtractMethodCandidate> myFragmentList;

    public Collection<PhpExtractMethodCandidate> getCandidates() {
        return this.getCandidates(null);
    }

    public Collection<PhpExtractMethodCandidate> getCandidates(@Nullable Condition<? super PhpExtractMethodBlockCodeFragment> filter) {
        List filteredCandidates = ContainerUtil.sorted((Collection)ContainerUtil.filter(this.myFragmentList, PhpFunctionBlockCandidatesGenerator.getFilterValidBlocks(filter)));
        LOG.info("Candidates number after filtering: " + filteredCandidates.size());
        return this.filterSimilarCandidates(filteredCandidates);
    }

    public Collection<PhpExtractMethodCandidate> filterSimilarCandidates(Collection<PhpExtractMethodCandidate> methodCandidates) {
        ArrayList<PhpExtractMethodCandidate> filteredCandidate = new ArrayList<PhpExtractMethodCandidate>();
        for (PhpExtractMethodCandidate candidate : methodCandidates) {
            if (PhpFunctionBlockCandidatesGenerator.hasSimilarButWorseCandidate(filteredCandidate, candidate)) {
                filteredCandidate.remove(ContainerUtil.find(filteredCandidate, e1 -> candidate.getTextRange().contains(e1.getTextRange()) && candidate.score() >= e1.score()));
            }
            if (!PhpFunctionBlockCandidatesGenerator.doesntHaveSimilarButBetterCandidate(filteredCandidate, candidate)) continue;
            filteredCandidate.add(candidate);
        }
        return filteredCandidate;
    }

    private static boolean doesntHaveSimilarButBetterCandidate(@NotNull List<PhpExtractMethodCandidate> filteredCandidate, @NotNull PhpExtractMethodCandidate candidate) {
        if (filteredCandidate == null) {
            PhpFunctionBlockCandidatesGenerator.$$$reportNull$$$0(0);
        }
        if (candidate == null) {
            PhpFunctionBlockCandidatesGenerator.$$$reportNull$$$0(1);
        }
        return ContainerUtil.find(filteredCandidate, e -> e.getTextRange().contains(candidate.getTextRange()) && e.score() >= candidate.score()) == null;
    }

    private static boolean hasSimilarButWorseCandidate(@NotNull List<PhpExtractMethodCandidate> filteredCandidate, @NotNull PhpExtractMethodCandidate candidate) {
        if (filteredCandidate == null) {
            PhpFunctionBlockCandidatesGenerator.$$$reportNull$$$0(2);
        }
        if (candidate == null) {
            PhpFunctionBlockCandidatesGenerator.$$$reportNull$$$0(3);
        }
        return ContainerUtil.find(filteredCandidate, e1 -> candidate.getTextRange().contains(e1.getTextRange()) && candidate.score() >= e1.score()) != null;
    }

    public PhpFunctionBlockCandidatesGenerator(Function function) {
        this.myFunction = function;
        this.myFragmentList = new ArrayList<PhpExtractMethodCandidate>();
        int counter = 0;
        ArrayDeque<Object> toProcess = new ArrayDeque<Object>();
        toProcess.add(function);
        while (!toProcess.isEmpty()) {
            PsiElement polledElement = (PsiElement)toProcess.poll();
            for (PsiElement psiElement : polledElement.getChildren()) {
                List<Statement> childStatements = Arrays.stream(psiElement.getChildren()).filter(e -> e instanceof Statement).map(e -> (Statement)e).collect(Collectors.toList());
                toProcess.addAll(childStatements);
                for (int i = 0; i < childStatements.size(); ++i) {
                    Statement firstStatement = (Statement)childStatements.get(i);
                    for (int j = i; j < childStatements.size(); ++j) {
                        Set inputVariables;
                        PhpExtractMethodCandidate extractMethodCandidate;
                        Set<PhpPsiElement> outputVariables;
                        PhpExtractMethodBlockCodeFragment blockCodeFragment;
                        Statement lastStatement = (Statement)childStatements.get(j);
                        PhpScopeHolder scope = (PhpScopeHolder)PhpPsiUtil.getParentByCondition((PsiElement)firstStatement, (Condition)PhpScopeHolder.INSTANCE_OF);
                        if (scope == null || !this.isNotTooLargeCandidate(blockCodeFragment = new PhpExtractMethodBlockCodeFragment(firstStatement, lastStatement, scope)) || !this.isNotTooSmallCandidate(blockCodeFragment) || !PhpFunctionBlockCandidatesGenerator.isComplexEnough(childStatements, i, j) || PhpExtractMethodHandler.validateBlockFragment((PhpExtractMethodBlockCodeFragment)blockCodeFragment) != null || ++counter >= 1000 || (outputVariables = PhpFunctionBlockCandidatesGenerator.getOutputVariablesEstimate(function, (PhpExtractMethodCodeFragment)blockCodeFragment)).size() >= 2 || (extractMethodCandidate = new PhpExtractMethodCandidate(blockCodeFragment, inputVariables = PhpExtractMethodHandler.getInputVariables((PhpExtractMethodCodeFragment)blockCodeFragment), outputVariables)).getInputVariables().size() > Math.max(4, function.getParameters().length)) continue;
                        this.myFragmentList.add(extractMethodCandidate);
                    }
                }
            }
        }
        LOG.info("Candidates generated: " + counter);
    }

    @NotNull
    public static Set<PhpPsiElement> getOutputVariablesEstimate(final @NotNull Function function, final @NotNull PhpExtractMethodCodeFragment fragment) {
        if (function == null) {
            PhpFunctionBlockCandidatesGenerator.$$$reportNull$$$0(4);
        }
        if (fragment == null) {
            PhpFunctionBlockCandidatesGenerator.$$$reportNull$$$0(5);
        }
        final Set predefinedVariables = function.getPredefinedVariables();
        final LinkedHashSet<PhpPsiElement> set = new LinkedHashSet<PhpPsiElement>();
        final HashSet names = new HashSet();
        PhpControlFlowUtil.processFlow((PhpControlFlow)function.getControlFlow(), (PhpInstructionProcessor)new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                CharSequence variableName;
                PhpAccessInstruction.Access access;
                PhpPsiElement anchor = instruction.getAnchor();
                if (fragment.contains(anchor.getTextRange()) && ((access = instruction.getAccess()).isWrite() || access.isWriteRef() || access.isReadWrite() || access.isReadRef() || access.isUnset() || !PhpWorkaroundUtil.getArrayAccess((PhpAccessVariableInstruction)instruction).isRead()) && !PhpExtractMethodHandler.isIgnoredVariables((CharSequence)(variableName = instruction.getVariableName()), (Set)predefinedVariables) && !names.contains(variableName) && (PhpControlFlowUtil.isReferenced((PhpScopeHolder)function, (PhpAccessVariableInstruction)instruction) || PhpExtractMethodHandler.hasReadAccess((PhpAccessVariableInstruction)instruction, (PhpAccessInstruction.Access)access, (PhpExtractMethodCodeFragment)fragment))) {
                    names.add(variableName.toString());
                    set.add(anchor);
                    if (set.size() > 1) {
                        return false;
                    }
                }
                return true;
            }
        });
        LinkedHashSet<PhpPsiElement> linkedHashSet = set;
        if (linkedHashSet == null) {
            PhpFunctionBlockCandidatesGenerator.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    private boolean isNotTooLargeCandidate(PhpExtractMethodBlockCodeFragment blockCodeFragment) {
        return (double)blockCodeFragment.getTextRange().getLength() < (double)this.myFunction.getTextRange().getLength() * 0.75;
    }

    private boolean isNotTooSmallCandidate(PhpExtractMethodBlockCodeFragment blockCodeFragment) {
        return (double)blockCodeFragment.getTextRange().getLength() > (double)this.myFunction.getTextRange().getLength() * 0.05;
    }

    private static boolean isComplexEnough(List<Statement> block, int i, int j) {
        return j - i + 1 >= 3 || PhpFunctionBlockCandidatesGenerator.hasGroupStatement(block.subList(i, j + 1));
    }

    private static boolean hasGroupStatement(List<Statement> statementsToCheck) {
        return statementsToCheck.stream().anyMatch(e -> ControlStatement.INSTANCEOF.value(e));
    }

    @NotNull
    public static Condition<PhpExtractMethodBlockCodeFragment> getFilterValidBlocks(@Nullable Condition<? super PhpExtractMethodBlockCodeFragment> myFilter) {
        Condition filterValidBlocks = myFilter != null ? Conditions.and(myFilter, e -> PhpExtractMethodQuickfix.isBlockValid(e)) : e -> PhpExtractMethodQuickfix.isBlockValid(e);
        Condition condition = filterValidBlocks;
        if (condition == null) {
            PhpFunctionBlockCandidatesGenerator.$$$reportNull$$$0(7);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filteredCandidate";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/quickFixes/extractFunction/PhpFunctionBlockCandidatesGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/quickFixes/extractFunction/PhpFunctionBlockCandidatesGenerator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariablesEstimate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterValidBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doesntHaveSimilarButBetterCandidate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasSimilarButWorseCandidate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOutputVariablesEstimate";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

