/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.ui;

import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractFunction.PhpExtractMethodCandidate;
import com.jetbrains.php.architecture.complexityMetrics.ui.ExtractCandidateFirstStatementRenderer;
import com.jetbrains.php.architecture.complexityMetrics.ui.ExtractFunctionCandidateTableModel;
import com.jetbrains.php.architecture.complexityMetrics.ui.LineNumberRenderer;
import com.jetbrains.php.architecture.complexityMetrics.ui.PhpExtractMethodCandidateWithUsageAdapter;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodBlockCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodDialog;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodHandler;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodParameterInfo;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodSettings;
import com.jetbrains.php.refactoring.extractMethod.PhpParametersFolder;
import com.jetbrains.php.refactoring.extractMethod.inplace.PhpExtractMethodPopupProvider;
import com.jetbrains.php.refactoring.extractMethod.inplace.PhpInplaceMethodExtractor;
import com.jetbrains.php.refactoring.ui.PhpCodeComponentsFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020 J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\nJ\u001e\u0010/\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\f\u00100\u001a\b\u0012\u0004\u0012\u00020\"01H\u0002R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/jetbrains/php/architecture/complexityMetrics/ui/PhpExtractFunctionPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "function", "Lcom/jetbrains/php/lang/psi/elements/Function;", "editor", "Lcom/intellij/openapi/editor/Editor;", "candidates", "", "Lcom/jetbrains/php/architecture/complexityMetrics/ui/PhpExtractMethodCandidateWithUsageAdapter;", "highlighter", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/codeInsight/unwrap/ScopeHighlighter;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/php/lang/psi/elements/Function;Lcom/intellij/openapi/editor/Editor;Ljava/util/List;Ljava/util/concurrent/atomic/AtomicReference;)V", "myExtractFunctionsCandidateTable", "Lcom/intellij/ui/table/JBTable;", "getMyExtractFunctionsCandidateTable", "()Lcom/intellij/ui/table/JBTable;", "myExtractFunctionsScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "myProject", "myFunction", "myMethodSignaturePreview", "Lcom/intellij/refactoring/ui/MethodSignatureComponent;", "myCandidates", "myEditor", "myCandidatesPresentation", "", "", "myPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "setDelegatePopup", "", "jbPopup", "calculateSignature", "phpExtractMethodCandidate", "Lcom/jetbrains/php/architecture/complexityMetrics/quickFixes/extractFunction/PhpExtractMethodCandidate;", "typeAnnotation", "e", "Lcom/jetbrains/php/refactoring/extractMethod/PhpExtractMethodParameterInfo;", "returnTypePresentation", "createPanel", "Ljavax/swing/JComponent;", "doExtractMethod", "selectedBlockFragment", "executeRefactoringCommand", "command", "Lkotlin/Function0;", "intellij.php.architecture"})
public final class PhpExtractFunctionPanel {
    @NotNull
    private final JBTable myExtractFunctionsCandidateTable;
    @NotNull
    private final JBScrollPane myExtractFunctionsScrollPane;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Function myFunction;
    @NotNull
    private final MethodSignatureComponent myMethodSignaturePreview;
    @NotNull
    private final List<PhpExtractMethodCandidateWithUsageAdapter> myCandidates;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final Map<PhpExtractMethodCandidateWithUsageAdapter, String> myCandidatesPresentation;
    @Nullable
    private JBPopup myPopup;

    public PhpExtractFunctionPanel(@NotNull Project project, @NotNull Function function, @NotNull Editor editor, @NotNull List<? extends PhpExtractMethodCandidateWithUsageAdapter> candidates, @NotNull AtomicReference<ScopeHighlighter> highlighter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        Intrinsics.checkNotNullParameter(highlighter, (String)"highlighter");
        this.myProject = project;
        this.myFunction = function;
        MethodSignatureComponent methodSignatureComponent = PhpCodeComponentsFactory.createPhpMethodSignaturePreview((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)methodSignatureComponent, (String)"createPhpMethodSignaturePreview(...)");
        this.myMethodSignaturePreview = methodSignatureComponent;
        this.myCandidates = candidates;
        this.myEditor = editor;
        this.myMethodSignaturePreview.setFocusable(false);
        this.myMethodSignaturePreview.setMinimumSize(new Dimension(500, 200));
        this.myMethodSignaturePreview.setPreferredSize(new Dimension(500, 200));
        this.myMethodSignaturePreview.setMaximumSize(new Dimension(500, 200));
        this.myPopup = null;
        ExtractFunctionCandidateTableModel extractFunctionCandidateTableModel = new ExtractFunctionCandidateTableModel(candidates);
        this.myExtractFunctionsCandidateTable = new JBTable(extractFunctionCandidateTableModel){

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)ks, (String)"ks");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getKeyCode() == 10) {
                        if (e.getID() == 401 && !this.isEditing() && e.getModifiersEx() == 0) {
                            this.doExtractMethod((PhpExtractMethodCandidateWithUsageAdapter)myCandidates.get(this.getSelectedRow()));
                        }
                        e.consume();
                        return true;
                    }
                    if (e.getKeyCode() != 27 || e.getID() != 401) break block3;
                    JBPopup jBPopup = myPopup;
                    if (jBPopup != null) {
                        jBPopup.cancel();
                    }
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            protected void processMouseEvent(MouseEvent e) {
                if (e != null && e.getClickCount() == 2) {
                    this.doExtractMethod((PhpExtractMethodCandidateWithUsageAdapter)myCandidates.get(this.getSelectedRow()));
                }
                super.processMouseEvent(e);
            }
        };
        (this.myExtractFunctionsCandidateTable).setMinimumSize(new Dimension(-1, 100));
        (this.myExtractFunctionsCandidateTable).setTableHeader(null);
        this.myCandidatesPresentation = new HashMap();
        for (PhpExtractMethodCandidateWithUsageAdapter it : this.myCandidates) {
            Map<PhpExtractMethodCandidateWithUsageAdapter, String> map = this.myCandidatesPresentation;
            PhpExtractMethodCandidate phpExtractMethodCandidate = it.getCandidate();
            Intrinsics.checkNotNullExpressionValue((Object)phpExtractMethodCandidate, (String)"getCandidate(...)");
            String string = this.calculateSignature(phpExtractMethodCandidate);
            map.put(it, string);
        }
        this.myExtractFunctionsCandidateTable.setSelectionMode(0);
        (this.myExtractFunctionsCandidateTable).getSelectionModel().addListSelectionListener(arg_0 -> PhpExtractFunctionPanel._init_$lambda$0(candidates, this, highlighter, arg_0));
        (this.myExtractFunctionsCandidateTable).getSelectionModel().setSelectionInterval(0, 0);
        this.myExtractFunctionsScrollPane = new JBScrollPane((Component)this.myExtractFunctionsCandidateTable);
        this.myExtractFunctionsScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myExtractFunctionsScrollPane.setMaximumSize(new Dimension(500, 100));
    }

    @NotNull
    public final JBTable getMyExtractFunctionsCandidateTable() {
        return this.myExtractFunctionsCandidateTable;
    }

    public final void setDelegatePopup(@NotNull JBPopup jbPopup) {
        Intrinsics.checkNotNullParameter((Object)jbPopup, (String)"jbPopup");
        this.myPopup = jbPopup;
        this.myExtractFunctionsCandidateTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)new LineNumberRenderer()));
        this.myExtractFunctionsCandidateTable.getColumnModel().getColumn(0).setMaxWidth(50);
        this.myExtractFunctionsCandidateTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)((Object)new ExtractCandidateFirstStatementRenderer()));
        this.myExtractFunctionsCandidateTable.setShowGrid(false);
    }

    private final String calculateSignature(PhpExtractMethodCandidate phpExtractMethodCandidate) {
        StringBuilder parametersBuilder = new StringBuilder();
        List list = PhpExtractMethodDialog.getParameterItems((PhpExtractMethodCodeFragment)((PhpExtractMethodCodeFragment)phpExtractMethodCandidate), phpExtractMethodCandidate.getInputVariables(), phpExtractMethodCandidate.getOutputVariables(), (PhpParametersFolder)new PhpParametersFolder());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameterItems(...)");
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)parametersBuilder, (CharSequence)",\n\t", null, null, (int)0, null, arg_0 -> PhpExtractFunctionPanel.calculateSignature$lambda$1(this, arg_0), (int)60, null);
        Set set = PhpExtractMethodDialog.suggestNames((Project)this.myProject, (PhpExtractMethodCodeFragment)((PhpExtractMethodCodeFragment)phpExtractMethodCandidate), phpExtractMethodCandidate.getOutputVariables());
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"suggestNames(...)");
        Set suggestNames = set;
        String functionName = suggestNames.isEmpty() ? "extracted" : (String)CollectionsKt.first((Iterable)suggestNames);
        String string = phpExtractMethodCandidate.getFragment().generateCodeText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateCodeText(...)");
        String generateCodeText = string;
        String[] stringArray = new String[]{"\n"};
        String startText = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)generateCodeText, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        String[] stringArray2 = new String[]{"\n"};
        String endText = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)generateCodeText, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
        String functionText = "function " + functionName + "(\n" + parametersBuilder + "\n) " + this.returnTypePresentation(phpExtractMethodCandidate) + " {\n\t" + startText + "\n\t// method body\n\t" + endText + "\n}";
        Function function = PhpPsiElementFactory.createFunction((Project)this.myProject, (String)functionText);
        Intrinsics.checkNotNullExpressionValue((Object)function, (String)"createFunction(...)");
        Function createFunction = function;
        String string2 = CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)createFunction).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        return string2;
    }

    private final String typeAnnotation(PhpExtractMethodParameterInfo e) {
        CharSequence charSequence = e.getTypeText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getTypeText(...)");
        if (charSequence.length() == 0) {
            return "";
        }
        return e.getTypeText() + " ";
    }

    private final String returnTypePresentation(PhpExtractMethodCandidate phpExtractMethodCandidate) {
        PhpPsiElement first;
        Set<PhpPsiElement> set = phpExtractMethodCandidate.getOutputVariables();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getOutputVariables(...)");
        Set<PhpPsiElement> outputVariables = set;
        if (outputVariables.size() == 0) {
            return ":void";
        }
        if (outputVariables.size() == 1 && (first = (PhpPsiElement)CollectionsKt.first((Iterable)outputVariables)) instanceof PhpTypedElement) {
            String returnTypePresentation = PhpExtractMethodHandler.getReturnTypePresentation((Project)this.myProject, (PhpType)((PhpTypedElement)first).getType(), (Function)this.myFunction);
            if (returnTypePresentation != null) {
                return ":" + returnTypePresentation;
            }
            return "";
        }
        return "";
    }

    @NotNull
    public final JComponent createPanel() {
        DialogPanel popupPanel = BuilderKt.panel(arg_0 -> PhpExtractFunctionPanel.createPanel$lambda$7(this, arg_0));
        popupPanel.setPreferredFocusedComponent((JComponent)this.myExtractFunctionsCandidateTable);
        return (JComponent)popupPanel;
    }

    public final void doExtractMethod(@NotNull PhpExtractMethodCandidateWithUsageAdapter selectedBlockFragment) {
        Intrinsics.checkNotNullParameter((Object)selectedBlockFragment, (String)"selectedBlockFragment");
        JBPopup jBPopup = this.myPopup;
        Intrinsics.checkNotNull((Object)jBPopup);
        jBPopup.cancel();
        PhpExtractMethodBlockCodeFragment fragment = selectedBlockFragment.getCandidate().getFragment();
        if (!this.myEditor.getSelectionModel().hasSelection()) {
            this.myEditor.getSelectionModel().setSelection(fragment.getStartOffset(), fragment.getEndOffset());
        }
        PsiFile psiFile = fragment.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        PhpExtractMethodSettings settings = PhpExtractMethodHandler.getSettingsForInplace((PhpExtractMethodCodeFragment)((PhpExtractMethodCodeFragment)fragment), (boolean)false);
        PhpInplaceMethodExtractor inplaceMethodExtractor = new PhpInplaceMethodExtractor(this.myProject, file, this.myEditor, (PhpExtractMethodCodeFragment)fragment, settings, new PhpExtractMethodPopupProvider());
        Runnable runnable = () -> PhpExtractFunctionPanel.doExtractMethod$lambda$9(this, inplaceMethodExtractor);
        runnable.run();
    }

    private final void executeRefactoringCommand(Project project, Function0<Unit> command) {
        CommandProcessor.getInstance().executeCommand(project, () -> PhpExtractFunctionPanel.executeRefactoringCommand$lambda$10(command), PhpExtractMethodHandler.getRefactoringName(), null);
    }

    private static final void _init_$lambda$0(List $candidates, PhpExtractFunctionPanel this$0, AtomicReference $highlighter, ListSelectionEvent it) {
        PhpExtractMethodCandidateWithUsageAdapter phpExtractMethodCandidate = (PhpExtractMethodCandidateWithUsageAdapter)$candidates.get((this$0.myExtractFunctionsCandidateTable).getSelectedRow());
        this$0.myMethodSignaturePreview.setSignature((String)((HashMap)this$0.myCandidatesPresentation).get(phpExtractMethodCandidate));
        Object v = $highlighter.get();
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        ScopeHighlighter h = (ScopeHighlighter)v;
        h.dropHighlight();
        PhpExtractMethodBlockCodeFragment blockFragment = phpExtractMethodCandidate.getCandidate().getFragment();
        if (blockFragment != null && blockFragment.isValid()) {
            TextRange textRange = blockFragment.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            TextRange range = textRange;
            PsiElement psiElement = blockFragment.getStartElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getStartElement(...)");
            PsiElement element = psiElement;
            new OpenFileDescriptor(element.getProject(), element.getContainingFile().getVirtualFile(), element.getTextOffset()).navigate(false);
            h.highlight(Pair.create((Object)range, (Object)CollectionsKt.listOf((Object)range)));
        }
    }

    private static final CharSequence calculateSignature$lambda$1(PhpExtractFunctionPanel this$0, PhpExtractMethodParameterInfo e) {
        Intrinsics.checkNotNull((Object)e);
        return this$0.typeAnnotation(e) + "$" + e.getName();
    }

    private static final Unit createPanel$lambda$7$lambda$2(PhpExtractFunctionPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.myExtractFunctionsScrollPane).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$7$lambda$4$lambda$3(MethodSignatureComponent $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setMinimumSize((Dimension)new JBDimension(100, 100));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$7$lambda$4(PhpExtractFunctionPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.myMethodSignaturePreview).align((Align)AlignX.FILL.INSTANCE).applyToComponent(PhpExtractFunctionPanel::createPanel$lambda$7$lambda$4$lambda$3);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$7$lambda$6$lambda$5(PhpExtractFunctionPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PhpExtractMethodCandidateWithUsageAdapter selectedBlockFragment = this$0.myCandidates.get(this$0.myExtractFunctionsCandidateTable.getSelectedRow());
        JBPopup jBPopup = this$0.myPopup;
        if (jBPopup != null) {
            jBPopup.closeOk(null);
        }
        this$0.doExtractMethod(selectedBlockFragment);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$7$lambda$6(PhpExtractFunctionPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PhpArchitectureBundle.message("extract.class.popup.window.button", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ExtractMethod"))};
        Cell.comment$default((Cell)$this$row.button(string, arg_0 -> PhpExtractFunctionPanel.createPanel$lambda$7$lambda$6$lambda$5(this$0, arg_0)), (String)PhpArchitectureBundle.message("extract.class.popup.label.to.extract.any.other.piece.code.select.it.in.editor.invoke.extract.method.refactoring.0", objectArray), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$7(PhpExtractFunctionPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExtractFunctionPanel.createPanel$lambda$7$lambda$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExtractFunctionPanel.createPanel$lambda$7$lambda$4(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExtractFunctionPanel.createPanel$lambda$7$lambda$6(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit doExtractMethod$lambda$9$lambda$8(PhpInplaceMethodExtractor $inplaceMethodExtractor) {
        Object[] objectArray = new String[]{"extracted"};
        $inplaceMethodExtractor.performInplaceRefactoring(ContainerUtil.newLinkedHashSet((Object[])objectArray));
        return Unit.INSTANCE;
    }

    private static final void doExtractMethod$lambda$9(PhpExtractFunctionPanel this$0, PhpInplaceMethodExtractor $inplaceMethodExtractor) {
        this$0.executeRefactoringCommand(this$0.myProject, (Function0<Unit>)((Function0)() -> PhpExtractFunctionPanel.doExtractMethod$lambda$9$lambda$8($inplaceMethodExtractor)));
    }

    private static final void executeRefactoringCommand$lambda$10(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

