/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.interact;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.event.MouseEvent;
import org.jetbrains.letsPlot.commons.event.MouseEventSpec;
import org.jetbrains.letsPlot.commons.event.MouseWheelEvent;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.registration.CompositeRegistration;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.core.interact.InteractionContext;
import org.jetbrains.letsPlot.core.interact.InteractionTarget;
import org.jetbrains.letsPlot.core.interact.ui.UiControl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0017\u001a\u00020\u0006H\u0086\u0002J\t\u0010\u0018\u001a\u00020\u0013H\u0086\u0002J\t\u0010\u0019\u001a\u00020\u000fH\u0086\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u00020\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001b0\u001eR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/interact/MouseWheelInteraction;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "ctx", "Lorg/jetbrains/letsPlot/core/interact/InteractionContext;", "(Lorg/jetbrains/letsPlot/core/interact/InteractionContext;)V", "_target", "Lorg/jetbrains/letsPlot/core/interact/InteractionTarget;", "disposed", "", "reg", "Lorg/jetbrains/letsPlot/commons/registration/CompositeRegistration;", "target", "getTarget", "()Lorg/jetbrains/letsPlot/core/interact/InteractionTarget;", "<set-?>", "", "zoomDelta", "getZoomDelta", "()D", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "zoomOrigin", "getZoomOrigin", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "component1", "component2", "component3", "dispose", "", "loop", "onZoomed", "Lkotlin/Function1;", "plot-base"})
@SourceDebugExtension(value={"SMAP\nMouseWheelInteraction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MouseWheelInteraction.kt\norg/jetbrains/letsPlot/core/interact/MouseWheelInteraction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class MouseWheelInteraction
implements Disposable {
    @NotNull
    private final InteractionContext ctx;
    private boolean disposed;
    @NotNull
    private final CompositeRegistration reg;
    @Nullable
    private InteractionTarget _target;
    @NotNull
    private DoubleVector zoomOrigin;
    private double zoomDelta;

    public MouseWheelInteraction(@NotNull InteractionContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        this.ctx = ctx2;
        this.reg = new CompositeRegistration(new Registration[0]);
        this.zoomOrigin = DoubleVector.Companion.getZERO();
    }

    @NotNull
    public final InteractionTarget component1() {
        return this.getTarget();
    }

    @NotNull
    public final DoubleVector component2() {
        return this.zoomOrigin;
    }

    public final double component3() {
        return this.zoomDelta;
    }

    @NotNull
    public final InteractionTarget getTarget() {
        InteractionTarget interactionTarget = this._target;
        if (interactionTarget == null) {
            throw new IllegalStateException("Mouse wheel zoom target wasn't acquired.");
        }
        return interactionTarget;
    }

    @NotNull
    public final DoubleVector getZoomOrigin() {
        return this.zoomOrigin;
    }

    public final double getZoomDelta() {
        return this.zoomDelta;
    }

    public final void loop(@NotNull Function1<? super MouseWheelInteraction, Unit> onZoomed) {
        Intrinsics.checkNotNullParameter(onZoomed, (String)"onZoomed");
        if (!(!this.disposed)) {
            boolean $i$a$-check-MouseWheelInteraction$loop$32 = false;
            String $i$a$-check-MouseWheelInteraction$loop$32 = "Disposed.";
            throw new IllegalStateException($i$a$-check-MouseWheelInteraction$loop$32.toString());
        }
        if (!(this._target == null)) {
            boolean bl = false;
            String string = "Mouse wheel zoom has already started.";
            throw new IllegalStateException(string.toString());
        }
        this.reg.add(this.ctx.getEventsManager().onMouseEvent(MouseEventSpec.MOUSE_WHEEL_ROTATED, (Function2<? super UiControl, ? super MouseEvent, Unit>)((Function2)new Function2<UiControl, MouseEvent, Unit>(this, onZoomed){
            final /* synthetic */ MouseWheelInteraction this$0;
            final /* synthetic */ Function1<MouseWheelInteraction, Unit> $onZoomed;
            {
                this.this$0 = $receiver;
                this.$onZoomed = $onZoomed;
                super(2);
            }

            public final void invoke(@Nullable UiControl uiControl, @NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MouseWheelEvent e2 = (MouseWheelEvent)e;
                e2.setPreventDefault(true);
                MouseWheelInteraction.access$setZoomOrigin$p(this.this$0, e2.getLocation().toDoubleVector());
                MouseWheelInteraction.access$setZoomDelta$p(this.this$0, e2.getScrollAmount());
                MouseWheelInteraction.access$set_target$p(this.this$0, MouseWheelInteraction.access$getCtx$p(this.this$0).findTarget(e2.getLocation().toDoubleVector()));
                this.$onZoomed.invoke((Object)this.this$0);
            }
        })));
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            System.out.println((Object)"MouseWheelInteraction dispose.");
            this.disposed = true;
            this._target = null;
            this.reg.dispose();
        }
    }

    public static final /* synthetic */ void access$setZoomOrigin$p(MouseWheelInteraction $this, DoubleVector doubleVector) {
        $this.zoomOrigin = doubleVector;
    }

    public static final /* synthetic */ void access$setZoomDelta$p(MouseWheelInteraction $this, double d) {
        $this.zoomDelta = d;
    }

    public static final /* synthetic */ void access$set_target$p(MouseWheelInteraction $this, InteractionTarget interactionTarget) {
        $this._target = interactionTarget;
    }

    public static final /* synthetic */ InteractionContext access$getCtx$p(MouseWheelInteraction $this) {
        return $this.ctx;
    }
}

